/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.google.common.base.Joiner;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.Config;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.LegacyUtil;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiIngredientFast {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final int blacklistItemColor = Color.yellow.getRGB();
    private static final int blacklistWildColor = Color.red.getRGB();
    private static final int blacklistModColor = Color.blue.getRGB();
    private final Rectangle area;
    private final int padding;
    private final ItemModelMesher itemModelMesher;
    @Nullable
    private IIngredientListElement element;
    private boolean blocked = false;

    public GuiIngredientFast(int xPosition, int yPosition, int padding) {
        this.padding = padding;
        int size = 16 + 2 * padding;
        this.area = new Rectangle(xPosition, yPosition, size, size);
        this.itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void setElement(IIngredientListElement element) {
        this.element = element;
    }

    @Nullable
    public IIngredientListElement getElement() {
        return this.element;
    }

    public void clear() {
        this.element = null;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.element != null && this.area.contains(mouseX, mouseY);
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void renderItemAndEffectIntoGUI() {
        if (this.element == null) {
            return;
        }
        Object ingredient = this.element.getIngredient();
        if (!(ingredient instanceof ItemStack)) {
            return;
        }
        try {
            this.renderItemAndEffectIntoGUI(this.element);
        }
        catch (RuntimeException e) {
            throw GuiIngredientFast.createRenderIngredientException(e, this.element);
        }
        catch (LinkageError e) {
            throw GuiIngredientFast.createRenderIngredientException(e, this.element);
        }
    }

    private void renderItemAndEffectIntoGUI(IIngredientListElement<ItemStack> element) {
        ItemStack itemStack = element.getIngredient();
        IBakedModel bakedModel = this.itemModelMesher.func_178089_a(itemStack);
        bakedModel = bakedModel.func_188617_f().handleItemState(bakedModel, itemStack, null, null);
        if (Config.isEditModeEnabled()) {
            GuiIngredientFast.renderEditMode(element, this.area, this.padding);
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)(this.area.x + this.padding) + 8.0f), (float)((float)(this.area.y + this.padding) + 8.0f), (float)150.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)-16.0f, (float)16.0f);
        bakedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Minecraft minecraft = Minecraft.func_71410_x();
        RenderItem renderItem = minecraft.func_175599_af();
        renderItem.func_175036_a(bakedModel, itemStack);
        if (itemStack.func_77962_s()) {
            this.renderEffect(bakedModel);
        }
        GlStateManager.func_179121_F();
    }

    private void renderEffect(IBakedModel model) {
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        RenderItem renderItem = minecraft.func_175599_af();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179112_b((int)768, (int)1);
        textureManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderItem.func_175035_a(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderItem.func_175035_a(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        textureManager.func_110577_a(TextureMap.field_110575_b);
    }

    public void renderSlow() {
        if (this.element != null) {
            if (Config.isEditModeEnabled()) {
                GuiIngredientFast.renderEditMode(this.element, this.area, this.padding);
            }
            try {
                GuiIngredientFast.renderSlow(this.element, this.area, this.padding);
            }
            catch (RuntimeException e) {
                throw GuiIngredientFast.createRenderIngredientException(e, this.element);
            }
            catch (LinkageError e) {
                throw GuiIngredientFast.createRenderIngredientException(e, this.element);
            }
        }
    }

    private static <T> void renderSlow(IIngredientListElement<T> element, Rectangle area, int padding) {
        IIngredientRenderer<T> ingredientRenderer = element.getIngredientRenderer();
        T ingredient = element.getIngredient();
        ingredientRenderer.render(Minecraft.func_71410_x(), area.x + padding, area.y + padding, ingredient);
    }

    public void renderOverlay(Minecraft minecraft) {
        if (this.element == null) {
            return;
        }
        Object ingredient = this.element.getIngredient();
        if (!(ingredient instanceof ItemStack)) {
            return;
        }
        ItemStack itemStack = (ItemStack)ingredient;
        try {
            this.renderOverlay(minecraft, itemStack);
        }
        catch (RuntimeException e) {
            throw GuiIngredientFast.createRenderIngredientException(e, this.element);
        }
        catch (LinkageError e) {
            throw GuiIngredientFast.createRenderIngredientException(e, this.element);
        }
    }

    private void renderOverlay(Minecraft minecraft, ItemStack itemStack) {
        FontRenderer font = GuiIngredientFast.getFontRenderer(minecraft, itemStack);
        RenderItem renderItem = minecraft.func_175599_af();
        renderItem.func_180453_a(font, itemStack, this.area.x + this.padding, this.area.y + this.padding, null);
    }

    private static <V> void renderEditMode(IIngredientListElement<V> element, Rectangle area, int padding) {
        IIngredientHelper<V> ingredientHelper;
        V ingredient = element.getIngredient();
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.ITEM, ingredientHelper = element.getIngredientHelper())) {
            GuiScreen.func_73734_a((int)(area.x + padding), (int)(area.y + padding), (int)(area.x + 8 + padding), (int)(area.y + 16 + padding), (int)blacklistItemColor);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.WILDCARD, ingredientHelper)) {
            GuiScreen.func_73734_a((int)(area.x + 8 + padding), (int)(area.y + padding), (int)(area.x + 16 + padding), (int)(area.y + 16 + padding), (int)blacklistWildColor);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.MOD_ID, ingredientHelper)) {
            GuiScreen.func_73734_a((int)(area.x + padding), (int)(area.y + 8 + padding), (int)(area.x + 16 + padding), (int)(area.y + 16 + padding), (int)blacklistModColor);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static FontRenderer getFontRenderer(Minecraft minecraft, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        FontRenderer fontRenderer = item.getFontRenderer(itemStack);
        if (fontRenderer == null) {
            fontRenderer = minecraft.field_71466_p;
        }
        return fontRenderer;
    }

    public void drawHighlight() {
        if (this.element == null) {
            return;
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GuiUtils.drawGradientRect((int)0, (int)this.area.x, (int)this.area.y, (int)(this.area.x + this.area.width), (int)(this.area.y + this.area.height), (int)-2130706433, (int)-2130706433);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179126_j();
    }

    public void drawTooltip(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.element == null) {
            return;
        }
        GuiIngredientFast.drawTooltip(minecraft, this.element, mouseX, mouseY);
    }

    private static <V> void drawTooltip(Minecraft minecraft, IIngredientListElement<V> element, int mouseX, int mouseY) {
        V ingredient = element.getIngredient();
        IIngredientRenderer<V> ingredientRenderer = element.getIngredientRenderer();
        List<String> tooltip = GuiIngredientFast.getTooltip(minecraft, element);
        FontRenderer fontRenderer = ingredientRenderer.getFontRenderer(minecraft, ingredient);
        if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            TooltipRenderer.drawHoveringText(itemStack, minecraft, tooltip, mouseX, mouseY, fontRenderer);
        } else {
            TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY, fontRenderer);
        }
    }

    private static <V> List<String> getTooltip(Minecraft minecraft, IIngredientListElement<V> element) {
        List<String> tooltip = GuiIngredientFast.getIngredientTooltipSafe(minecraft, element);
        V ingredient = element.getIngredient();
        IIngredientHelper<V> ingredientHelper = element.getIngredientHelper();
        tooltip = ForgeModIdHelper.getInstance().addModNameToIngredientTooltip(tooltip, ingredient, ingredientHelper);
        int maxWidth = 125;
        for (String tooltipLine : tooltip) {
            int width = minecraft.field_71466_p.func_78256_a(tooltipLine);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        if (Config.getColorSearchMode() != Config.SearchMode.DISABLED) {
            GuiIngredientFast.addColorSearchInfoToTooltip(minecraft, element, tooltip, maxWidth);
        }
        if (Config.isEditModeEnabled()) {
            GuiIngredientFast.addEditModeInfoToTooltip(minecraft, element, tooltip, maxWidth);
        }
        return tooltip;
    }

    private static <V> List<String> getIngredientTooltipSafe(Minecraft minecraft, IIngredientListElement<V> element) {
        IIngredientRenderer<V> ingredientRenderer = element.getIngredientRenderer();
        V ingredient = element.getIngredient();
        try {
            return LegacyUtil.getTooltip(ingredientRenderer, minecraft, ingredient, minecraft.field_71474_y.field_82882_x);
        }
        catch (RuntimeException e) {
            Log.error("Tooltip crashed.", e);
        }
        catch (LinkageError e) {
            Log.error("Tooltip crashed.", e);
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(TextFormatting.RED + Translator.translateToLocal("jei.tooltip.error.crash"));
        return tooltip;
    }

    private static <V> void addColorSearchInfoToTooltip(Minecraft minecraft, IIngredientListElement<V> element, List<String> tooltip, int maxWidth) {
        ColorNamer colorNamer = Internal.getColorNamer();
        V ingredient = element.getIngredient();
        IIngredientHelper<V> ingredientHelper = element.getIngredientHelper();
        Iterable<Color> colors = ingredientHelper.getColors(ingredient);
        Collection<String> colorNames = colorNamer.getColorNames(colors, false);
        if (!colorNames.isEmpty()) {
            String colorNamesString = Joiner.on((String)", ").join(colorNames);
            String colorNamesLocalizedString = TextFormatting.GRAY + Translator.translateToLocalFormatted("jei.tooltip.item.colors", colorNamesString);
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(colorNamesLocalizedString, maxWidth));
        }
    }

    private static <V> void addEditModeInfoToTooltip(Minecraft minecraft, IIngredientListElement<V> element, List<String> tooltip, int maxWidth) {
        String description;
        String message;
        V ingredient = element.getIngredient();
        IIngredientHelper<V> ingredientHelper = element.getIngredientHelper();
        tooltip.add("");
        tooltip.add(TextFormatting.ITALIC + Translator.translateToLocal("gui.jei.editMode.description"));
        String controlKeyLocalization = Translator.translateToLocal(Minecraft.field_142025_a ? "key.jei.ctrl.mac" : "key.jei.ctrl");
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.ITEM, ingredientHelper)) {
            message = Translator.translateToLocal("gui.jei.editMode.description.show").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.YELLOW + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        } else {
            message = Translator.translateToLocal("gui.jei.editMode.description.hide").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.YELLOW + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        }
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.WILDCARD, ingredientHelper)) {
            message = Translator.translateToLocal("gui.jei.editMode.description.show.wild").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.RED + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        } else {
            message = Translator.translateToLocal("gui.jei.editMode.description.hide.wild").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.RED + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        }
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.MOD_ID, ingredientHelper)) {
            message = Translator.translateToLocal("gui.jei.editMode.description.show.mod.id").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.BLUE + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        } else {
            message = Translator.translateToLocal("gui.jei.editMode.description.hide.mod.id").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.BLUE + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        }
    }

    private static <T> ReportedException createRenderIngredientException(Throwable throwable, IIngredientListElement<T> element) {
        final T ingredient = element.getIngredient();
        final IIngredientHelper<T> ingredientHelper = Internal.getIngredientRegistry().getIngredientHelper(ingredient);
        CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering ingredient");
        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Ingredient being rendered");
        crashreportcategory.func_189529_a("Ingredient Mod", (ICrashReportDetail)new ICrashReportDetail<String>(){

            public String call() throws Exception {
                return ForgeModIdHelper.getInstance().getModNameForIngredient(ingredient, ingredientHelper);
            }
        });
        crashreportcategory.func_189529_a("Ingredient Info", (ICrashReportDetail)new ICrashReportDetail<String>(){

            public String call() throws Exception {
                return ingredientHelper.getErrorInfo(ingredient);
            }
        });
        throw new ReportedException(crashreport);
    }
}

