/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.Focus;
import mezz.jei.ingredients.IngredientUtil;
import mezz.jei.recipes.RecipeMap;
import mezz.jei.recipes.RecipeRegistry;

public class InternalRecipeRegistryPlugin
implements IRecipeRegistryPlugin {
    private final RecipeRegistry recipeRegistry;
    private final ImmutableMultimap<String, String> categoriesForRecipeCatalystKeys;
    private final IIngredientRegistry ingredientRegistry;
    private final ImmutableMap<String, IRecipeCategory> recipeCategoriesMap;
    private final RecipeMap recipeInputMap;
    private final RecipeMap recipeOutputMap;
    private final ListMultimap<IRecipeCategory, IRecipeWrapper> recipeWrappersForCategories;

    public InternalRecipeRegistryPlugin(RecipeRegistry recipeRegistry, ImmutableMultimap<String, String> categoriesForRecipeCatalystKeys, IIngredientRegistry ingredientRegistry, ImmutableMap<String, IRecipeCategory> recipeCategoriesMap, RecipeMap recipeInputMap, RecipeMap recipeOutputMap, ListMultimap<IRecipeCategory, IRecipeWrapper> recipeWrappersForCategories) {
        this.recipeRegistry = recipeRegistry;
        this.categoriesForRecipeCatalystKeys = categoriesForRecipeCatalystKeys;
        this.ingredientRegistry = ingredientRegistry;
        this.recipeCategoriesMap = recipeCategoriesMap;
        this.recipeInputMap = recipeInputMap;
        this.recipeOutputMap = recipeOutputMap;
        this.recipeWrappersForCategories = recipeWrappersForCategories;
    }

    @Override
    public <V> List<String> getRecipeCategoryUids(IFocus<V> focus) {
        focus = Focus.check(focus);
        V ingredient = focus.getValue();
        switch (focus.getMode()) {
            case INPUT: {
                return this.recipeInputMap.getRecipeCategories(ingredient);
            }
            case OUTPUT: {
                return this.recipeOutputMap.getRecipeCategories(ingredient);
            }
        }
        return this.getRecipeCategories();
    }

    private ImmutableList<String> getRecipeCategories() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : this.recipeCategoriesMap.entrySet()) {
            IRecipeCategory recipeCategory = (IRecipeCategory)entry.getValue();
            if (this.recipeRegistry.getRecipeWrappers(recipeCategory).isEmpty()) continue;
            builder.add(entry.getKey());
        }
        return builder.build();
    }

    @Override
    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        focus = Focus.check(focus);
        V ingredient = focus.getValue();
        IIngredientHelper<V> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        if (focus.getMode() == IFocus.Mode.INPUT) {
            ImmutableList<T> recipes = this.recipeInputMap.getRecipeWrappers(recipeCategory, ingredient);
            String recipeCategoryUid = recipeCategory.getUid();
            for (String inputKey : IngredientUtil.getUniqueIdsWithWildcard(ingredientHelper, ingredient)) {
                if (!this.categoriesForRecipeCatalystKeys.get((Object)inputKey).contains((Object)recipeCategoryUid)) continue;
                ImmutableSet specificRecipes = ImmutableSet.copyOf(recipes);
                List recipesForCategory = this.recipeWrappersForCategories.get(recipeCategory);
                ArrayList<T> allRecipes = new ArrayList<T>(recipes);
                for (IRecipeWrapper recipe : recipesForCategory) {
                    if (specificRecipes.contains((Object)recipe)) continue;
                    allRecipes.add(recipe);
                }
                return allRecipes;
            }
            return recipes;
        }
        return this.recipeOutputMap.getRecipeWrappers(recipeCategory, ingredient);
    }

    @Override
    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory) {
        List recipeWrappers = this.recipeWrappersForCategories.get(recipeCategory);
        return Collections.unmodifiableList(recipeWrappers);
    }
}

