/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mezz.jei.Internal;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public class BrewingRecipeUtil {
    public static final ItemStack POTION = new ItemStack((Item)Items.field_151068_bn);
    public static final ItemStack WATER_BOTTLE = PotionUtils.func_185188_a((ItemStack)POTION.func_77946_l(), (PotionType)PotionTypes.field_185230_b);
    private final Map<String, Integer> brewingStepCache = new HashMap<String, Integer>();
    private final Multimap<String, String> potionMap = HashMultimap.create();

    public BrewingRecipeUtil() {
        this.clearCache();
    }

    public void addRecipe(ItemStack inputPotion, ItemStack outputPotion) {
        String potionInputUid = Internal.getStackHelper().getUniqueIdentifierForStack(inputPotion);
        String potionOutputUid = Internal.getStackHelper().getUniqueIdentifierForStack(outputPotion);
        this.potionMap.put((Object)potionOutputUid, (Object)potionInputUid);
        this.clearCache();
    }

    public int getBrewingSteps(ItemStack outputPotion) {
        String potionInputUid = Internal.getStackHelper().getUniqueIdentifierForStack(outputPotion);
        return this.getBrewingSteps(potionInputUid, new HashSet<String>());
    }

    private void clearCache() {
        if (this.brewingStepCache.size() != 1) {
            this.brewingStepCache.clear();
            String waterBottleUid = Internal.getStackHelper().getUniqueIdentifierForStack(WATER_BOTTLE);
            this.brewingStepCache.put(waterBottleUid, 0);
        }
    }

    private int getBrewingSteps(String potionOutputUid, Set<String> previousSteps) {
        Integer brewingSteps = this.brewingStepCache.get(potionOutputUid);
        if (brewingSteps == null) {
            previousSteps.add(potionOutputUid);
            Collection prevPotions = this.potionMap.get((Object)potionOutputUid);
            if (!prevPotions.isEmpty()) {
                int minPrevSteps = Integer.MAX_VALUE;
                for (String prevPotion : prevPotions) {
                    if (previousSteps.contains(prevPotion)) continue;
                    int prevSteps = this.getBrewingSteps(prevPotion, previousSteps);
                    minPrevSteps = Math.min(minPrevSteps, prevSteps);
                }
                if (minPrevSteps < Integer.MAX_VALUE) {
                    brewingSteps = minPrevSteps + 1;
                    this.brewingStepCache.put(potionOutputUid, brewingSteps);
                }
            }
        }
        if (brewingSteps == null) {
            return Integer.MAX_VALUE;
        }
        return brewingSteps;
    }
}

