/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.suffixtree;

import gnu.trove.map.TCharObjectMap;
import gnu.trove.map.hash.TCharObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.TIntSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import javax.annotation.Nullable;
import mezz.jei.suffixtree.Edge;

class Node {
    private final IntList data;
    private final TCharObjectMap<Edge> edges = new TCharObjectHashMap();
    @Nullable
    private Node suffix = null;

    Node() {
        this.data = new IntArrayList(0);
    }

    void getData(final TIntSet ret) {
        ret.addAll((Collection)this.data);
        this.edges.forEachValue((TObjectProcedure)new TObjectProcedure<Edge>(){

            public boolean execute(Edge e) {
                e.getDest().getData(ret);
                return true;
            }
        });
    }

    boolean addRef(int index) {
        if (this.contains(index)) {
            return false;
        }
        this.addIndex(index);
        Node iter = this.suffix;
        while (iter != null && iter.addRef(index)) {
            iter = iter.suffix;
        }
        return true;
    }

    private boolean contains(int index) {
        return this.data.contains(index);
    }

    void addEdge(char ch, Edge e) {
        this.edges.put(ch, (Object)e);
    }

    @Nullable
    Edge getEdge(char ch) {
        return (Edge)this.edges.get(ch);
    }

    @Nullable
    Node getSuffix() {
        return this.suffix;
    }

    void setSuffix(Node suffix) {
        this.suffix = suffix;
    }

    private void addIndex(int index) {
        this.data.add(index);
    }

    public String toString() {
        return "Node: size:" + this.data.size() + " Edges: " + this.edges.toString();
    }
}

