/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.config.Config;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IPaged;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseHelper;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.render.GuiIngredientFast;
import mezz.jei.render.GuiIngredientFastList;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;

public abstract class IngredientGrid
implements IShowsRecipeFocuses,
IPaged {
    private static final int INGREDIENT_PADDING = 1;
    private static final int INGREDIENT_WIDTH = GuiItemStackGroup.getWidth(1);
    private static final int INGREDIENT_HEIGHT = GuiItemStackGroup.getHeight(1);
    private Rectangle area = new Rectangle();
    protected final GuiIngredientFastList guiIngredientList;

    public IngredientGrid(IIngredientRegistry ingredientRegistry) {
        this.guiIngredientList = new GuiIngredientFastList(ingredientRegistry);
    }

    public void updateBounds(Rectangle area, Collection<Rectangle> exclusionAreas) {
        int columns = area.width / INGREDIENT_WIDTH;
        int rows = area.height / INGREDIENT_HEIGHT;
        int width = columns * INGREDIENT_WIDTH;
        int height = rows * INGREDIENT_HEIGHT;
        int x = area.x + (area.width - width) / 2;
        int y = area.y + (area.height - height) / 2;
        this.area = new Rectangle(x, y, width, height);
        this.guiIngredientList.clear();
        for (int row = 0; row < rows; ++row) {
            int y1 = y + row * INGREDIENT_HEIGHT;
            for (int column = 0; column < columns; ++column) {
                int x1 = x + column * INGREDIENT_WIDTH;
                GuiIngredientFast guiIngredientFast = new GuiIngredientFast(x1, y1, 1);
                Rectangle stackArea = guiIngredientFast.getArea();
                boolean blocked = MathUtil.intersects(exclusionAreas, stackArea);
                guiIngredientFast.setBlocked(blocked);
                this.guiIngredientList.add(guiIngredientFast);
            }
        }
    }

    public void updateLayout(Collection<Rectangle> guiExclusionAreas) {
        for (GuiIngredientFast guiIngredientFast : this.guiIngredientList.getAllGuiIngredients()) {
            Rectangle stackArea = guiIngredientFast.getArea();
            boolean blocked = MathUtil.intersects(guiExclusionAreas, stackArea);
            guiIngredientFast.setBlocked(blocked);
        }
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY) {
        GuiIngredientFast hovered;
        GlStateManager.func_179084_k();
        this.guiIngredientList.render(minecraft);
        if (!IngredientGrid.shouldShowDeleteItemTooltip(minecraft) && this.isMouseOver(mouseX, mouseY) && (hovered = this.guiIngredientList.getHovered(mouseX, mouseY)) != null) {
            hovered.drawHighlight();
        }
        GlStateManager.func_179141_d();
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (IngredientGrid.shouldShowDeleteItemTooltip(minecraft)) {
                String deleteItem = Translator.translateToLocal("jei.tooltip.delete.item");
                TooltipRenderer.drawHoveringText(minecraft, deleteItem, mouseX, mouseY);
            } else {
                GuiIngredientFast hovered = this.guiIngredientList.getHovered(mouseX, mouseY);
                if (hovered != null) {
                    hovered.drawTooltip(minecraft, mouseX, mouseY);
                }
            }
        }
    }

    private static boolean shouldShowDeleteItemTooltip(Minecraft minecraft) {
        if (Config.isDeleteItemsInCheatModeActive()) {
            EntityPlayerSP player = minecraft.field_71439_g;
            if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                JeiRuntime runtime = Internal.getRuntime();
                return runtime == null || !runtime.getRecipesGui().isOpen();
            }
        }
        return false;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    public boolean handleMouseClicked(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            Minecraft minecraft = Minecraft.func_71410_x();
            JeiRuntime runtime = Internal.getRuntime();
            if (Config.isDeleteItemsInCheatModeActive() && (runtime == null || !runtime.getRecipesGui().isOpen())) {
                EntityPlayerSP player = minecraft.field_71439_g;
                ItemStack itemStack = player.field_71071_by.func_70445_o();
                if (!itemStack.func_190926_b()) {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
                    JustEnoughItems.getProxy().sendPacketToServer(packet);
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public IIngredientListElement getElementUnderMouse() {
        IIngredientListElement element;
        GuiIngredientFast hovered = this.guiIngredientList.getHovered(MouseHelper.getX(), MouseHelper.getY());
        if (hovered != null && (element = hovered.getElement()) != null) {
            return element;
        }
        return null;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ClickedIngredient<?> clicked = this.guiIngredientList.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                clicked.setAllowsCheating();
            }
            return clicked;
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    public abstract int getPageCount();

    public abstract int getPageNum();

    public abstract List<IIngredientListElement> getVisibleElements();
}

