/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.startup.StackHelper;
import net.minecraft.item.ItemStack;

public class IngredientSet<V>
extends AbstractSet<V> {
    private final UidGenerator<V> uidGenerator;
    private final Map<String, V> ingredients;

    public static <V> IngredientSet<V> create(Class<V> ingredientClass, final IIngredientHelper<V> ingredientHelper) {
        UidGenerator uidGenerator;
        if (ingredientClass == ItemStack.class) {
            final StackHelper stackHelper = Internal.getStackHelper();
            uidGenerator = new UidGenerator<V>(){

                @Override
                public String getUniqueId(V ingredient) {
                    return stackHelper.getUniqueIdentifierForStack((ItemStack)ingredient, StackHelper.UidMode.FULL);
                }
            };
        } else {
            uidGenerator = new UidGenerator<V>(){

                @Override
                public String getUniqueId(V ingredient) {
                    return ingredientHelper.getUniqueId(ingredient);
                }
            };
        }
        return new IngredientSet<V>(uidGenerator);
    }

    private IngredientSet(UidGenerator<V> uidGenerator) {
        this.uidGenerator = uidGenerator;
        this.ingredients = new LinkedHashMap<String, V>();
    }

    @Override
    public boolean add(V v) {
        String uid = this.uidGenerator.getUniqueId(v);
        return this.ingredients.put(uid, v) == null;
    }

    @Override
    public boolean remove(Object o) {
        String uid = this.uidGenerator.getUniqueId(o);
        return this.ingredients.remove(uid) != null;
    }

    @Override
    public boolean contains(Object o) {
        String uid = this.uidGenerator.getUniqueId(o);
        return this.ingredients.containsKey(uid);
    }

    @Override
    public void clear() {
        this.ingredients.clear();
    }

    @Override
    public Iterator<V> iterator() {
        return this.ingredients.values().iterator();
    }

    @Override
    public int size() {
        return this.ingredients.size();
    }

    private static interface UidGenerator<V> {
        public String getUniqueId(V var1);
    }
}

