/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.tweaks;

import iguanaman.iguanatweakstconstruct.tweaks.RepairCraftingRecipe;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.util.IPattern;

public class PartCraftingRecipe
implements IRecipe {
    private ItemStack outputPart;

    public boolean matches(InventoryCrafting inventoryCrafting, World world) {
        this.outputPart = null;
        ItemStack pattern = null;
        ItemStack input = null;
        for (int i = 0; i < inventoryCrafting.getSizeInventory(); ++i) {
            ItemStack slot = inventoryCrafting.getStackInSlot(i);
            if (slot == null) continue;
            if (slot.getItem() instanceof IPattern) {
                if (pattern != null) {
                    return false;
                }
                pattern = slot;
                continue;
            }
            if (input != null) {
                return false;
            }
            input = slot;
        }
        if (pattern == null || input == null) {
            return false;
        }
        if (!PatternBuilder.instance.toolPatterns.contains(pattern.getItem())) {
            return false;
        }
        ItemStack[] output = PatternBuilder.instance.getToolPart(input, pattern, null);
        if (output == null) {
            return false;
        }
        for (ItemStack stack : output) {
            if (stack == null) continue;
            this.outputPart = stack;
            return true;
        }
        return false;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventory) {
        return this.outputPart;
    }

    public int getRecipeSize() {
        return 2;
    }

    public ItemStack getRecipeOutput() {
        return this.outputPart;
    }

    static {
        RecipeSorter.register((String)"IguanaTweaksTConstruct:part", RepairCraftingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }
}

