/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.leveling.commands;

import iguanaman.iguanatweakstconstruct.leveling.LevelingLogic;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;

public class IguanaCommandLevelUpTool
extends CommandBase {
    public String getCommandName() {
        return "leveluptool";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processCommand(ICommandSender icommandsender, String[] astring) {
        long requiredHeadXP;
        int hLevel;
        EntityPlayerMP entityplayermp = astring.length >= 1 ? IguanaCommandLevelUpTool.getPlayer((ICommandSender)icommandsender, (String)astring[0]) : IguanaCommandLevelUpTool.getCommandSenderAsPlayer((ICommandSender)icommandsender);
        ItemStack equipped = entityplayermp.getCurrentEquippedItem();
        if (equipped == null || !(equipped.getItem() instanceof ToolCore)) throw new WrongUsageException("Player must have a Tinker's Construct tool in hand", new Object[0]);
        NBTTagCompound tags = equipped.getTagCompound().getCompoundTag("InfiTool");
        if (!tags.hasKey("ToolLevel")) throw new WrongUsageException("Player must have a levelable Tinker's Construct tool in hand", new Object[0]);
        int level = tags.getInteger("ToolLevel");
        int n = hLevel = tags.hasKey("HarvestLevel") ? (hLevel = tags.getInteger("HarvestLevel")) : -1;
        if ((level < 1 || level > 5) && hLevel < TConstructRegistry.getMaterial((String)"Copper").harvestLevel() && hLevel >= TConstructRegistry.getMaterial((String)"Manyullyn").harvestLevel()) throw new WrongUsageException("Players tool is already max level", new Object[0]);
        Long toolXP = tags.hasKey("ToolEXP") ? tags.getLong("ToolEXP") : -1L;
        Long headXP = tags.hasKey("HeadEXP") ? tags.getLong("HeadEXP") : -1L;
        long requiredToolXP = (long)LevelingLogic.getRequiredXp(equipped, tags) - toolXP;
        long l = requiredHeadXP = tags.hasKey("HeadEXP") && hLevel >= TConstructRegistry.getMaterial((String)"Copper").harvestLevel() && hLevel < TConstructRegistry.getMaterial((String)"Manyullyn").harvestLevel() ? (long)LevelingLogic.getRequiredXp(equipped, tags) - headXP : -1L;
        if (requiredHeadXP < requiredToolXP && requiredHeadXP > 0L) {
            LevelingLogic.updateXP(equipped, (EntityPlayer)entityplayermp, toolXP + requiredHeadXP, headXP + requiredHeadXP);
        } else {
            LevelingLogic.updateXP(equipped, (EntityPlayer)entityplayermp, toolXP + requiredToolXP, headXP + requiredToolXP);
        }
        if (entityplayermp == icommandsender) return;
    }

    public static int parseIntWithMinMax(ICommandSender par0ICommandSender, String par1Str, int min, int max) {
        return IguanaCommandLevelUpTool.parseIntBounded((ICommandSender)par0ICommandSender, (String)par1Str, (int)min, (int)max);
    }

    public String getCommandUsage(ICommandSender icommandsender) {
        return null;
    }

    public int compareTo(Object arg0) {
        return 0;
    }
}

