/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.food;

import iguanaman.hungeroverhaul.HungerOverhaul;
import iguanaman.hungeroverhaul.common.config.Config;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.StarvationEvent;

public class FoodEventHandler {
    @SubscribeEvent
    public void onFoodEaten(FoodEvent.FoodEaten event) {
        int duration;
        if (!event.player.world.isRemote && event.player.world.getGameRules().getBoolean("naturalRegeneration") && Config.healthRegenRatePercentage > 0 && Config.addWellFedEffect && (duration = (int)(Math.pow(event.foodValues.hunger * 100, 1.2) * (double)Config.wellFedDurationMultiplier)) >= 30) {
            PotionEffect currentEffect = event.player.getActivePotionEffect(HungerOverhaul.potionWellFed);
            if (currentEffect != null) {
                duration += currentEffect.getDuration();
            }
            event.player.addPotionEffect(new PotionEffect(HungerOverhaul.potionWellFed, duration, 0, true, true));
        }
        if (Config.foodRegensHealth) {
            float canHeal;
            float toHeal = Math.round((float)event.foodValues.hunger / (float)Config.foodHealDivider);
            if (toHeal > (canHeal = event.player.getMaxHealth() - event.player.getHealth())) {
                toHeal = canHeal;
            }
            if (toHeal > 0.0f) {
                event.player.heal(toHeal);
            }
        }
    }

    @SubscribeEvent
    public void allowExhaustion(ExhaustionEvent.AllowExhaustion event) {
        if (Config.hungerLossRatePercentage == 0.0f) {
            AppleCoreAPI.mutator.setHunger(event.player, 19);
            AppleCoreAPI.mutator.setSaturation(event.player, 0.0f);
            AppleCoreAPI.mutator.setExhaustion(event.player, 0.0f);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void getMaxExhaustion(ExhaustionEvent.GetMaxExhaustion event) {
        EnumDifficulty difficulty = event.player.world.getDifficulty();
        float hungerLossRate = event.maxExhaustionLevel / (Config.hungerLossRatePercentage / 100.0f);
        if (Config.difficultyScalingHunger) {
            if (difficulty == EnumDifficulty.PEACEFUL) {
                hungerLossRate *= 1.6666666f;
            } else if (difficulty == EnumDifficulty.EASY) {
                hungerLossRate *= 1.3333334f;
            }
        }
        event.maxExhaustionLevel = hungerLossRate;
    }

    @SubscribeEvent
    public void onExhausted(ExhaustionEvent.Exhausted event) {
        if (event.player.getFoodStats().getSaturationLevel() <= 0.0f) {
            event.deltaHunger = -1;
        }
    }

    @SubscribeEvent
    public void allowHealthRegen(HealthRegenEvent.AllowRegen event) {
        if (event.player.getFoodStats().getFoodLevel() >= Config.minHungerToHeal && Config.healthRegenRatePercentage > 0 && event.player.world.getGameRules().getBoolean("naturalRegeneration") && event.player.shouldHeal()) {
            event.setResult(Event.Result.ALLOW);
        } else {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onHealthRegenTick(HealthRegenEvent.GetRegenTickPeriod event) {
        float wellfedModifier = 1.0f;
        if (event.player.isPotionActive(HungerOverhaul.potionWellFed)) {
            wellfedModifier = 1.0f - Config.wellFedEffectiveness;
        }
        EnumDifficulty difficulty = event.player.world.getDifficulty();
        float difficultyModifierHealing = 1.0f;
        if (Config.difficultyScalingHealing) {
            if (difficulty.getDifficultyId() <= EnumDifficulty.EASY.getDifficultyId()) {
                difficultyModifierHealing = 0.75f;
            } else if (difficulty == EnumDifficulty.HARD) {
                difficultyModifierHealing = 1.5f;
            }
        }
        float lowHealthModifier = 1.0f;
        if (Config.modifyRegenRateOnLowHealth) {
            lowHealthModifier = event.player.getMaxHealth() - event.player.getHealth();
            lowHealthModifier *= (float)Config.lowHealthRegenRateModifier / 100.0f;
            lowHealthModifier *= difficultyModifierHealing;
            lowHealthModifier = (float)Math.pow(lowHealthModifier + 1.0f, 1.5);
        }
        event.regenTickPeriod = Math.round(80.0f * difficultyModifierHealing * wellfedModifier * lowHealthModifier / ((float)Config.healthRegenRatePercentage / 100.0f));
    }

    @SubscribeEvent
    public void onHealthRegen(HealthRegenEvent.Regen event) {
        if (Config.disableHealingHungerDrain) {
            event.deltaExhaustion = 0.0f;
        }
    }

    @SubscribeEvent
    public void onStarve(StarvationEvent.Starve event) {
        event.starveDamage = Config.damageOnStarve;
    }

    @SubscribeEvent
    public void onFoodStatsAddition(FoodEvent.FoodStatsAddition event) {
        if (Config.hungerLossRatePercentage == 0.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFoodStartEating(LivingEntityUseItemEvent.Start event) {
        int hunger;
        if (Config.modifyFoodEatingSpeed && AppleCoreAPI.accessor.isFood(event.getItem()) && (hunger = FoodValues.get((ItemStack)event.getItem()).hunger) > 0) {
            event.setDuration(hunger * 8 + 8);
        }
    }
}

