package iguanaman.hungeroverhaul.common;

import java.util.ArrayList;
import java.util.List;

import com.pam.harvestcraft.blocks.growables.BlockPamCrop;
import com.pam.harvestcraft.blocks.growables.BlockPamFruit;
import com.progwml6.natura.overworld.NaturaOverworld;

import iguanaman.hungeroverhaul.module.harvestcraft.helper.PamsModsHelper;
import iguanaman.hungeroverhaul.module.natura.helper.NaturaHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class BlockHelper
{
    public static List<ItemStack> modifyCropDrops(List<ItemStack> drops, IBlockState state, int minSeeds, int maxSeeds, int minProduce, int maxProduce)
    {
        List<ItemStack> modifiedDrops = new ArrayList<ItemStack>();

        int seeds = RandomHelper.getRandomIntFromRange(minSeeds, maxSeeds);
        int produce = RandomHelper.getRandomIntFromRange(minProduce, maxProduce);
        ItemStack seedItem = BlockHelper.getSeedsOfBlock(state, seeds);
        ItemStack produceItem = BlockHelper.getProduceOfBlock(state, produce);
        boolean produceIsNotSeed = (seedItem.func_77973_b() != produceItem.func_77973_b() || seedItem.func_77952_i() != produceItem.func_77952_i());

        boolean shouldProduceNotDrop = BlockHelper.shouldProduceNotDrop(state);

        for (ItemStack item : drops)
        {
            // don't include seed/produce already in the list; we'll add them back afterwards
            if (item.func_77969_a(seedItem) || item.func_77969_a(produceItem))
            {
                continue;
            }

            modifiedDrops.add(item);
        }

        // only add seeds if they are different from produce
        if (produceIsNotSeed && seedItem.func_190916_E() > 0)
        {
            modifiedDrops.add(seedItem);
        }

        if (produceItem.func_190916_E() > 0 && !shouldProduceNotDrop)
        {
            modifiedDrops.add(produceItem);
        }

        return modifiedDrops;
    }

    public static ItemStack getSeedOfBlock(IBlockState state)
    {
        return getSeedsOfBlock(state, 1);
    }

    public static ItemStack getSeedsOfBlock(IBlockState state, int num)
    {
        return new ItemStack(getSeedItem(state), num, getSeedMetadata(state));
    }

    public static ItemStack getProduceOfBlock(IBlockState state)
    {
        return getProduceOfBlock(state, 1);
    }

    public static ItemStack getProduceOfBlock(IBlockState state, int num)
    {
        return new ItemStack(getProduceItem(state), num, getProduceMetadata(state));
    }

    public static Item getSeedItem(IBlockState state)
    {
        Item itemDropped = state.func_177230_c().func_180660_a(state, RandomHelper.random, 0);

        if (Loader.isModLoaded("natura") && (state.func_177230_c() == NaturaOverworld.barleyCrop || state.func_177230_c() == NaturaOverworld.cottonCrop))
        {
            Item seedForProduct = NaturaHelper.cropToSeedMap.get(state.func_177230_c());

            if (seedForProduct != Items.field_190931_a)
            {
                return seedForProduct;
            }
        }
        else if (Loader.isModLoaded("harvestcraft") && state.func_177230_c() instanceof BlockPamCrop)
        {
            Item seedForProduct = PamsModsHelper.productToSeedMap.get(itemDropped);

            if (seedForProduct != Items.field_190931_a)
            {
                return seedForProduct;
            }
        }

        return itemDropped;
    }

    public static Item getProduceItem(IBlockState state)
    {
        return state.func_177230_c().func_180660_a(state, RandomHelper.random, 0);
    }

    public static int getProduceMetadata(IBlockState state)
    {
        return state.func_177230_c().func_180651_a(state);
    }

    public static int getSeedMetadata(IBlockState state)
    {
        if (Loader.isModLoaded("natura") && state.func_177230_c() == NaturaOverworld.barleyCrop)
        {
            return NaturaOverworld.barley_seeds.func_77946_l().func_77952_i();
        }
        else if (Loader.isModLoaded("natura") && state.func_177230_c() == NaturaOverworld.cottonCrop)
        {
            return NaturaOverworld.cotton_seeds.func_77946_l().func_77952_i();
        }
        else
        {
            return state.func_177230_c().func_180651_a(state);
        }
    }

    public static boolean shouldProduceNotDrop(IBlockState state)
    {
        if (Loader.isModLoaded("harvestcraft") && state.func_177230_c() instanceof BlockPamFruit)
        {
            Block seed = PamsModsHelper.fruitBlockToBlockMap.get(state.func_177230_c());

            if (seed == state.func_177230_c() || seed == Blocks.field_150350_a)
            {
                return true;
            }
        }

        return false;
    }
}
