/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.food;

import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.library.ItemAndBlockList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;

public class FoodModifier {
    private static HashMap<ItemStack, FoodValues> modifiedFoodValues = new HashMap();
    public static ItemAndBlockList blacklist = new ItemAndBlockList();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void getModifiedFoodValues(FoodEvent.GetFoodValues event) {
        if (!Config.modifyFoodValues) {
            return;
        }
        if (blacklist.contains(event.food)) {
            return;
        }
        FoodValues modifiedFoodValues = FoodModifier.lookupModifiedFoodValues(event.food);
        if (modifiedFoodValues != null) {
            event.foodValues = modifiedFoodValues;
        } else {
            int hunger = Math.max(Math.round((float)event.foodValues.hunger / Config.foodHungerDivider), 1);
            float saturation = event.foodValues.saturationModifier;
            if (Config.foodHungerToSaturationDivider != 0.0f) {
                saturation = (float)hunger / Config.foodHungerToSaturationDivider;
            }
            event.foodValues = new FoodValues(hunger, saturation /= Config.foodSaturationDivider);
        }
    }

    public static void setModifiedFoodValues(Item item, FoodValues values) {
        FoodModifier.setModifiedFoodValues(new ItemStack(item), values);
    }

    public static void setModifiedFoodValues(ItemStack stack, FoodValues values) {
        ItemStack foundMatchingFood = FoodModifier.findMatchingFood(stack);
        if (!foundMatchingFood.func_190926_b()) {
            modifiedFoodValues.remove(foundMatchingFood);
        }
        modifiedFoodValues.put(stack, values);
    }

    private static FoodValues lookupModifiedFoodValues(ItemStack stack) {
        ItemStack foundMatchingFood = FoodModifier.findMatchingFood(stack);
        return foundMatchingFood != null ? modifiedFoodValues.get(foundMatchingFood) : null;
    }

    private static ItemStack findMatchingFood(ItemStack stack) {
        for (Map.Entry<ItemStack, FoodValues> entry : modifiedFoodValues.entrySet()) {
            if (!stack.func_77969_a(entry.getKey())) continue;
            return entry.getKey();
        }
        return ItemStack.field_190927_a;
    }
}

