/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.module.event;

import com.pam.harvestcraft.blocks.growables.BlockPamCrop;
import com.pam.harvestcraft.blocks.growables.BlockPamFruit;
import com.pam.harvestcraft.blocks.growables.BlockPamFruitLog;
import com.pam.harvestcraft.item.items.ItemPamSeedFood;
import com.progwml6.natura.overworld.block.crops.BlockNaturaBarley;
import com.progwml6.natura.overworld.block.crops.BlockNaturaCotton;
import iguanaman.hungeroverhaul.common.BlockHelper;
import iguanaman.hungeroverhaul.common.ClientHelper;
import iguanaman.hungeroverhaul.common.RandomHelper;
import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.library.ItemAndBlockList;
import iguanaman.hungeroverhaul.module.growth.PlantGrowthModule;
import iguanaman.hungeroverhaul.module.growth.modification.PlantGrowthModification;
import iguanaman.hungeroverhaul.module.harvestcraft.helper.PamsModsHelper;
import iguanaman.hungeroverhaul.module.reflection.ReflectionModule;
import iguanaman.hungeroverhaul.module.seed.GrassSeedsModule;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockPotato;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodValues;

public class HungerOverhaulEventHook {
    private static long lastRightClickCrop;
    public static ItemAndBlockList rightClickHarvestBlacklist;
    public static ItemAndBlockList harvestDropsBlacklist;

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Random rand = new Random();
        if (event.getEntityLiving() instanceof EntityAnimal) {
            NBTTagCompound tags;
            float rndBreed = RandomHelper.nextFloat(rand, Config.breedingTimeoutMultiplier);
            float rndChild = RandomHelper.nextFloat(rand, Config.childDurationMultiplier);
            EntityAgeable ageable = (EntityAgeable)event.getEntityLiving();
            int growingAge = ageable.getGrowingAge();
            if (growingAge > 0 && rndBreed >= 1.0f) {
                ageable.setGrowingAge(++growingAge);
            } else if (growingAge < 0 && rndChild >= 1.0f) {
                ageable.setGrowingAge(--growingAge);
            }
            if (Config.eggTimeoutMultiplier > 1.0f && event.getEntityLiving() instanceof EntityChicken) {
                float rnd = RandomHelper.nextFloat(rand, Config.eggTimeoutMultiplier);
                EntityChicken chicken = (EntityChicken)event.getEntityLiving();
                if (chicken.timeUntilNextEgg > 0 && rnd >= 1.0f) {
                    ++chicken.timeUntilNextEgg;
                }
            }
            if (Config.milkedTimeout > 0 && event.getEntityLiving() instanceof EntityCow && event.getEntityLiving().world.getTotalWorldTime() % 20L == 0L && (tags = event.getEntityLiving().getEntityData()).hasKey("Milked")) {
                int milked = tags.getInteger("Milked");
                if (--milked <= 0) {
                    tags.removeTag("Milked");
                } else {
                    tags.setInteger("Milked", milked);
                }
            }
        }
        if (!event.getEntityLiving().world.isRemote) {
            NBTTagCompound tags = event.getEntityLiving().getEntityData();
            if (tags.hasKey("HungerOverhaulCheck")) {
                int lastCheck = tags.getInteger("HungerOverhaulCheck");
                if (--lastCheck <= 0) {
                    tags.removeTag("HungerOverhaulCheck");
                } else {
                    tags.setInteger("HungerOverhaulCheck", lastCheck);
                }
            } else {
                EntityPlayer player;
                float healthPercent = event.getEntityLiving().getHealth() / event.getEntityLiving().getMaxHealth();
                int foodLevel = 20;
                boolean creative = false;
                boolean isPlayer = false;
                if (event.getEntityLiving() instanceof EntityPlayer) {
                    player = (EntityPlayer)event.getEntityLiving();
                    creative = player.capabilities.isCreativeMode;
                    foodLevel = player.getFoodStats().getFoodLevel();
                    isPlayer = true;
                } else {
                    healthPercent /= 2.0f;
                }
                if (event.getEntityLiving() instanceof EntityPlayer && Config.constantHungerLoss) {
                    player = (EntityPlayer)event.getEntityLiving();
                    if (!player.capabilities.isCreativeMode && !player.isDead) {
                        player.addExhaustion(0.01f);
                    }
                }
                if (Config.addLowStatEffects) {
                    int difficultyModifierEffects = 2;
                    if (Config.difficultyScalingEffects && event.getEntityLiving().world.getDifficulty() != null) {
                        difficultyModifierEffects = event.getEntityLiving().world.getDifficulty().getDifficultyId();
                        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
                            difficultyModifierEffects = difficultyModifierEffects * -1 + 3;
                        }
                    }
                    if (!creative && isPlayer && !event.getEntityLiving().isDead && healthPercent > 0.0f) {
                        if (Config.addLowHealthSlowness || Config.addLowHungerSlowness) {
                            if (Config.addLowHungerSlowness && foodLevel <= 1 || Config.addLowHealthSlowness && healthPercent <= 0.05f) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 19, 1 + difficultyModifierEffects, true, true));
                            } else if (Config.addLowHungerSlowness && foodLevel <= 2 || Config.addLowHealthSlowness && healthPercent <= 0.1f) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 19, difficultyModifierEffects, true, true));
                            } else if ((Config.addLowHungerSlowness && foodLevel <= 3 || Config.addLowHealthSlowness && healthPercent <= 0.15f) && difficultyModifierEffects >= 1) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 19, -1 + difficultyModifierEffects, true, true));
                            } else if ((Config.addLowHungerSlowness && foodLevel <= 4 || Config.addLowHealthSlowness && healthPercent <= 0.2f) && difficultyModifierEffects >= 2) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 19, -2 + difficultyModifierEffects, true, true));
                            } else if ((Config.addLowHungerSlowness && foodLevel <= 5 || Config.addLowHealthSlowness && healthPercent <= 0.25f) && difficultyModifierEffects >= 3) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 19, -3 + difficultyModifierEffects, true, true));
                            }
                        }
                        if (Config.addLowHealthMiningSlowdown || Config.addLowHungerMiningSlowdown) {
                            if (Config.addLowHungerMiningSlowdown && foodLevel <= 1 || Config.addLowHealthMiningSlowdown && healthPercent <= 0.05f) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.MINING_FATIGUE, 19, 1 + difficultyModifierEffects, true, true));
                            } else if (Config.addLowHungerMiningSlowdown && foodLevel <= 2 || Config.addLowHealthMiningSlowdown && healthPercent <= 0.1f) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.MINING_FATIGUE, 19, difficultyModifierEffects, true, true));
                            } else if ((Config.addLowHungerMiningSlowdown && foodLevel <= 3 || Config.addLowHealthMiningSlowdown && healthPercent <= 0.15f) && difficultyModifierEffects >= 1) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.MINING_FATIGUE, 19, -1 + difficultyModifierEffects, true, true));
                            } else if ((Config.addLowHungerMiningSlowdown && foodLevel <= 4 || Config.addLowHealthMiningSlowdown && healthPercent <= 0.2f) && difficultyModifierEffects >= 2) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.MINING_FATIGUE, 19, -2 + difficultyModifierEffects, true, true));
                            } else if ((Config.addLowHungerMiningSlowdown && foodLevel <= 5 || Config.addLowHealthMiningSlowdown && healthPercent <= 0.25f) && difficultyModifierEffects >= 3) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.MINING_FATIGUE, 19, -3 + difficultyModifierEffects, true, true));
                            }
                        }
                        if (Config.addLowHealthWeakness || Config.addLowHungerWeakness) {
                            if ((Config.addLowHungerWeakness && foodLevel <= 1 || Config.addLowHealthWeakness && healthPercent <= 0.05f) && difficultyModifierEffects >= 1) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.WEAKNESS, 19, -1 + difficultyModifierEffects, true, true));
                            } else if ((Config.addLowHungerWeakness && foodLevel <= 2 || Config.addLowHealthWeakness && healthPercent <= 0.1f) && difficultyModifierEffects >= 2) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.WEAKNESS, 19, -2 + difficultyModifierEffects, true, true));
                            } else if ((Config.addLowHungerWeakness && foodLevel <= 3 || Config.addLowHealthWeakness && healthPercent <= 0.15f) && difficultyModifierEffects >= 3) {
                                event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.WEAKNESS, 19, -3 + difficultyModifierEffects, true, true));
                            }
                        }
                        if (Config.addLowHungerNausea && foodLevel <= 1 || Config.addLowHealthNausea && healthPercent <= 0.05f) {
                            event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.NAUSEA, 19, 0, true, true));
                        }
                    }
                }
                tags.setInteger("HungerOverhaulCheck", 9);
            }
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event) {
        if (Config.modifyHoeUse) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            ItemStack itemStack = event.getCurrent();
            EntityPlayer player = event.getEntityPlayer();
            IBlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            if ((block == Blocks.DIRT || block == Blocks.GRASS) && this.isWaterNearby(world, pos)) {
                if (Config.hoeToolDamageMultiplier > 1) {
                    itemStack.damageItem(Config.hoeToolDamageMultiplier - 1, (EntityLivingBase)player);
                }
            } else if (block == Blocks.GRASS && !this.isWaterNearby(world, pos)) {
                Block farmland = Blocks.FARMLAND;
                SoundType soundtype = farmland.getSoundType(farmland.getDefaultState(), world, pos, (Entity)player);
                world.playSound(player, pos, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                if (!event.getWorld().isRemote && Config.seedChance > 0) {
                    ItemStack seed;
                    int seedChance = Config.seedChance;
                    if (world.getDifficulty().getDifficultyId() < 2) {
                        seedChance *= 2;
                    } else if (world.getDifficulty().getDifficultyId() == 3) {
                        seedChance = Math.max(Math.round((float)seedChance / 2.0f), 1);
                    }
                    if (event.getWorld().rand.nextInt(100) <= seedChance && (seed = GrassSeedsModule.getSeedFromTillingGrass(event.getWorld().rand)) != null) {
                        EntityItem ei = new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, seed.copy());
                        ei.motionY = 0.025000000372529;
                        world.spawnEntityInWorld((Entity)ei);
                    }
                    world.setBlockState(pos, Blocks.DIRT.getDefaultState());
                }
                if (Config.hoeToolDamageMultiplier > 1) {
                    itemStack.damageItem(Config.hoeToolDamageMultiplier - 1, (EntityLivingBase)player);
                }
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        if (Config.addGuiText) {
            Minecraft mc = Minecraft.getMinecraft();
            EntityPlayerSP player = mc.player;
            if (!(player.isDead || player.capabilities.isCreativeMode || mc.gameSettings.showDebugInfo)) {
                float healthPercent = player.getHealth() / player.getMaxHealth();
                if (healthPercent <= 0.15f) {
                    event.getLeft().add(TextFormatting.RED + I18n.translateToLocal((String)"ui.health.dying") + TextFormatting.RESET);
                } else if (healthPercent <= 0.3f) {
                    event.getLeft().add(TextFormatting.YELLOW + I18n.translateToLocal((String)"ui.health.injured") + TextFormatting.RESET);
                } else if (healthPercent < 0.5f) {
                    event.getLeft().add(TextFormatting.WHITE + I18n.translateToLocal((String)"ui.health.hurt") + TextFormatting.RESET);
                }
                if (player.getFoodStats().getFoodLevel() <= 6) {
                    event.getRight().add(TextFormatting.RED + I18n.translateToLocal((String)"ui.hunger.starving") + TextFormatting.RESET);
                } else if (player.getFoodStats().getFoodLevel() <= 10) {
                    event.getRight().add(TextFormatting.YELLOW + I18n.translateToLocal((String)"ui.hunger.hungry") + TextFormatting.RESET);
                } else if (player.getFoodStats().getFoodLevel() <= 14) {
                    event.getRight().add(TextFormatting.WHITE + I18n.translateToLocal((String)"ui.hunger.peckish") + TextFormatting.RESET);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        if (Config.milkedTimeout > 0 && event.getEntityPlayer() != null && event.getTarget() != null && event.getTarget() instanceof EntityCow) {
            Item item;
            EnumHand hand;
            EntityCow cow = (EntityCow)event.getTarget();
            EntityPlayer player = event.getEntityPlayer();
            ItemStack equipped = player.getHeldItem(hand = event.getHand());
            if (equipped != null && equipped.getItem() != null && ((item = equipped.getItem()) instanceof ItemBucket && FluidStack.loadFluidStackFromNBT((NBTTagCompound)equipped.getTagCompound()) == null || cow instanceof EntityMooshroom && item == Items.BOWL)) {
                NBTTagCompound tags = cow.getEntityData();
                if (tags.hasKey("Milked")) {
                    event.setCanceled(true);
                    if (!player.world.isRemote) {
                        cow.playSound(SoundEvents.ENTITY_COW_HURT, 0.4f, (event.getEntity().world.rand.nextFloat() - event.getEntity().world.rand.nextFloat()) * 0.2f + 1.0f);
                    }
                } else {
                    tags.setInteger("Milked", Config.milkedTimeout * 60);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            AppleCoreAPI.mutator.setHealthRegenTickCounter(player, 0);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (lastRightClickCrop == event.getWorld().getTotalWorldTime()) {
            event.setCanceled(true);
        }
        if (Config.foodsUnplantable && Loader.isModLoaded((String)"harvestcraft") && event.getEntityPlayer().getHeldItem(event.getHand()) != null && event.getEntityPlayer().getHeldItem(event.getHand()).getItem() instanceof ItemPamSeedFood) {
            if (event.getWorld().isRemote) {
                if (PamsModsHelper.canPlantSeedFoodAt(event.getEntityPlayer().getHeldItem(event.getHand()), event.getEntityPlayer(), event.getWorld(), event.getPos(), event.getFace())) {
                    event.setCanceled(true);
                    return;
                }
            } else {
                event.setUseItem(Event.Result.DENY);
            }
            return;
        }
        if (!Config.enableRightClickHarvesting) {
            return;
        }
        IBlockState clicked_state = event.getWorld().getBlockState(event.getPos());
        IBlockState real_state = clicked_state.getBlock().getActualState(clicked_state, (IBlockAccess)event.getWorld(), event.getPos());
        Block clicked_block = clicked_state.getBlock();
        IBlockState resultingState = null;
        if (rightClickHarvestBlacklist.contains(clicked_block)) {
            return;
        }
        if (Loader.isModLoaded((String)"natura") && clicked_block.getClass() == BlockNaturaCotton.class) {
            if ((Integer)real_state.getValue((IProperty)BlockNaturaCotton.AGE) == 4) {
                resultingState = real_state.withProperty((IProperty)BlockNaturaCotton.AGE, (Comparable)Integer.valueOf(0));
            }
        } else if (Loader.isModLoaded((String)"natura") && clicked_block.getClass() == BlockNaturaBarley.class) {
            if ((Integer)real_state.getValue((IProperty)BlockNaturaBarley.AGE) == 3) {
                resultingState = real_state.withProperty((IProperty)BlockNaturaBarley.AGE, (Comparable)Integer.valueOf(0));
            }
        } else if (clicked_block.getClass() == BlockCrops.class || clicked_block.getClass() == BlockCarrot.class || clicked_block.getClass() == BlockPotato.class) {
            if ((Integer)real_state.getValue((IProperty)BlockCrops.AGE) >= 7) {
                resultingState = real_state.withProperty((IProperty)BlockCrops.AGE, (Comparable)Integer.valueOf(0));
            }
        } else if (clicked_block.getClass() == BlockBeetroot.class) {
            if ((Integer)real_state.getValue((IProperty)BlockBeetroot.BEETROOT_AGE) >= 3) {
                resultingState = real_state.withProperty((IProperty)BlockBeetroot.BEETROOT_AGE, (Comparable)Integer.valueOf(0));
            }
        } else if (Loader.isModLoaded((String)"harvestcraft") && clicked_block.getClass() == BlockPamCrop.class) {
            if (ReflectionModule.pamCropAgeFound && (Integer)real_state.getValue((IProperty)ReflectionModule.pamCropAge) >= 3) {
                resultingState = real_state.withProperty((IProperty)ReflectionModule.pamCropAge, (Comparable)Integer.valueOf(0));
            }
        } else if (Loader.isModLoaded((String)"harvestcraft") && clicked_block.getClass() == BlockPamFruit.class) {
            if (ReflectionModule.pamFruitAgeFound && (Integer)real_state.getValue((IProperty)ReflectionModule.pamFruitAge) >= 2) {
                resultingState = real_state.withProperty((IProperty)ReflectionModule.pamFruitAge, (Comparable)Integer.valueOf(0));
            }
        } else if (Loader.isModLoaded((String)"harvestcraft") && clicked_block.getClass() == BlockPamFruitLog.class && ReflectionModule.pamFruitLogAgeFound && (Integer)real_state.getValue((IProperty)ReflectionModule.pamFruitLogAge) >= 2) {
            resultingState = real_state.withProperty((IProperty)ReflectionModule.pamFruitLogAge, (Comparable)Integer.valueOf(0));
        }
        if (resultingState != null) {
            if (!event.getWorld().isRemote && !event.getWorld().restoringBlockSnapshots) {
                List drops = clicked_block.getDrops((IBlockAccess)event.getWorld(), event.getPos(), clicked_state, 0);
                List<ItemStack> modifiedDrops = BlockHelper.modifyCropDrops(drops, clicked_state, Config.seedsPerHarvestRightClickMin, Config.seedsPerHarvestRightClickMax, Config.producePerHarvestRightClickMin, Config.producePerHarvestRightClickMax);
                for (ItemStack drop : modifiedDrops) {
                    Block.spawnAsEntity((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack)drop);
                }
            }
            event.getWorld().setBlockState(event.getPos(), resultingState, 2);
            lastRightClickCrop = event.getWorld().getTotalWorldTime();
            if (event.getWorld().isRemote) {
                ClientHelper.sendRightClickPacket(event.getPos(), event.getFace(), event.getHand(), 0.0f, 0.0f, 0.0f);
                event.setCanceled(true);
            } else {
                event.setUseItem(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        boolean fullyGrown;
        boolean eligable;
        if (!Config.modifyCropDropsBreak) {
            return;
        }
        if (harvestDropsBlacklist.contains(event.getState().getBlock())) {
            return;
        }
        IBlockState state = event.getState();
        Block block = state.getBlock();
        boolean isPamCrop = Loader.isModLoaded((String)"harvestcraft") && block.getClass() == BlockPamCrop.class;
        boolean isPamFruit = Loader.isModLoaded((String)"harvestcraft") && block.getClass() == BlockPamFruit.class;
        boolean isPamFruitLog = Loader.isModLoaded((String)"harvestcraft") && block.getClass() == BlockPamFruitLog.class;
        boolean isCottonCrop = Loader.isModLoaded((String)"natura") && block.getClass() == BlockNaturaCotton.class;
        boolean isBarleyCrop = Loader.isModLoaded((String)"natura") && block.getClass() == BlockNaturaBarley.class;
        boolean isBeetrootCrop = block.getClass() == BlockBeetroot.class;
        boolean isVanillaCrop = block.getClass() == BlockCrops.class || block.getClass() == BlockCarrot.class || block.getClass() == BlockPotato.class;
        boolean bl = eligable = isCottonCrop || isBarleyCrop || isVanillaCrop || isBeetrootCrop || isPamCrop || isPamFruit || isPamFruitLog;
        if (!eligable) {
            return;
        }
        boolean bl2 = fullyGrown = isVanillaCrop && (Integer)state.getValue((IProperty)BlockCrops.AGE) >= 7 || isBeetrootCrop && (Integer)state.getValue((IProperty)BlockBeetroot.BEETROOT_AGE) >= 3 || isCottonCrop && (Integer)state.getValue((IProperty)BlockNaturaCotton.AGE) == 4 || isBarleyCrop && (Integer)state.getValue((IProperty)BlockNaturaBarley.AGE) == 3 || ReflectionModule.pamCropAgeFound && isPamCrop && (Integer)state.getValue((IProperty)ReflectionModule.pamCropAge) == 3 || ReflectionModule.pamFruitAgeFound && isPamFruit && (Integer)state.getValue((IProperty)ReflectionModule.pamFruitAge) == 2 || ReflectionModule.pamFruitLogAgeFound && isPamFruitLog && (Integer)state.getValue((IProperty)ReflectionModule.pamFruitLogAge) == 2;
        if (!fullyGrown) {
            return;
        }
        List<ItemStack> modifiedDrops = BlockHelper.modifyCropDrops(event.getDrops(), state, Config.seedsPerHarvestBreakMin, Config.seedsPerHarvestBreakMax, Config.producePerHarvestBreakMin, Config.producePerHarvestBreakMax);
        event.getDrops().clear();
        for (ItemStack drop : modifiedDrops) {
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderTooltips(ItemTooltipEvent event) {
        if (Config.addFoodTooltips && AppleCoreAPI.accessor.isFood(event.getItemStack())) {
            FoodValues values = FoodValues.get((ItemStack)event.getItemStack());
            int hungerFill = values.hunger;
            float satiation = values.saturationModifier * 20.0f - (float)hungerFill;
            String mealDescriptor = "";
            String adjective = null;
            String noun = hungerFill <= 1 ? "morsel" : (hungerFill <= 2 ? "snack" : (hungerFill <= 5 ? "lightmeal" : (hungerFill <= 8 ? "meal" : (hungerFill <= 11 ? "largemeal" : "feast"))));
            if (satiation >= 3.0f) {
                adjective = "hearty";
            } else if (satiation >= 2.0f) {
                adjective = "wholesome";
            } else if (satiation > 0.0f) {
                adjective = "nourishing";
            } else if (satiation < 0.0f) {
                adjective = "unfulfilling";
            }
            if (adjective != null && I18n.canTranslate((String)("tooltip.meal." + adjective + "_" + noun))) {
                mealDescriptor = I18n.translateToLocal((String)("tooltip.meal." + adjective + "_" + noun));
            } else {
                mealDescriptor = I18n.translateToLocal((String)("tooltip.meal." + noun));
                if (adjective != null) {
                    mealDescriptor = I18n.translateToLocalFormatted((String)I18n.translateToLocal((String)("tooltip.meal." + adjective)), (Object[])new Object[]{mealDescriptor});
                }
            }
            int topIndex = event.getToolTip().size() > 0 ? 1 : 0;
            event.getToolTip().add(topIndex, mealDescriptor.substring(0, 1).toUpperCase() + mealDescriptor.substring(1));
        }
        if (Config.wrongBiomeRegrowthMultiplier > 1.0f) {
            Block block;
            PlantGrowthModification growthModification = null;
            if (event.getItemStack().getItem() instanceof IPlantable) {
                growthModification = PlantGrowthModule.getPlantGrowthModification(((IPlantable)event.getItemStack().getItem()).getPlant((IBlockAccess)event.getEntityPlayer().world, BlockPos.ORIGIN).getBlock());
            } else if (event.getItemStack().getItem() instanceof ItemBlock) {
                Block block2 = Block.getBlockFromItem((Item)event.getItemStack().getItem());
                if (block2 != null) {
                    growthModification = PlantGrowthModule.getPlantGrowthModification(block2);
                }
            } else if (Loader.isModLoaded((String)"harvestcraft") && (block = PamsModsHelper.fruitItemToBlockMap.get(event.getItemStack().getItem())) != null) {
                growthModification = PlantGrowthModule.getPlantGrowthModification(block);
            }
            if (growthModification != null && !growthModification.biomeGrowthModifiers.isEmpty()) {
                String tooltip = "";
                for (BiomeDictionary.Type biomeType : growthModification.biomeGrowthModifiers.keySet()) {
                    tooltip = tooltip + biomeType.toString().substring(0, 1).toUpperCase() + biomeType.toString().substring(1).toLowerCase() + ", ";
                }
                event.getToolTip().add(I18n.translateToLocal((String)"tooltip.meal.crop_grows_best_in"));
                event.getToolTip().add(tooltip.substring(0, tooltip.length() - 2));
            }
        }
    }

    private boolean isWaterNearby(World world, BlockPos pos) {
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = i - 4; l <= i + 4; ++l) {
            for (int i1 = j; i1 <= j + 1; ++i1) {
                for (int j1 = k - 4; j1 <= k + 4; ++j1) {
                    if (world.getBlockState((BlockPos)mutableblockpos.setPos(l, i1, j1)).getMaterial() != Material.WATER) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        Block enderLilly;
        lastRightClickCrop = 0L;
        rightClickHarvestBlacklist = new ItemAndBlockList();
        harvestDropsBlacklist = new ItemAndBlockList();
        if (Loader.isModLoaded((String)"extrautils2") && (enderLilly = Block.getBlockFromName((String)"extrautils2:enderlilly")) != null) {
            rightClickHarvestBlacklist.add(enderLilly);
            harvestDropsBlacklist.add(enderLilly);
        }
    }
}

