package iguanaman.hungeroverhaul.module.tinkersconstruct;

import iguanaman.hungeroverhaul.common.config.Config;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.shared.TinkerCommons;

public class TinkersConstructModule
{
    public static void init()
    {
        if (Config.dryingRackTimeMultiplier != 1)
        {
            int dryingTime = 20 * 60 * 20; //in minutes

            if (TConstruct.pulseManager.isPulseLoaded(TinkerGadgets.PulseId))
            {
                NBTTagCompound rottonFleshTag = new NBTTagCompound();
                rottonFleshTag.func_74782_a("input", new ItemStack(Items.field_151078_bh).func_77955_b(new NBTTagCompound()));
                rottonFleshTag.func_74782_a("output", TinkerCommons.jerkyMonster.func_77955_b(new NBTTagCompound()));
                rottonFleshTag.func_74768_a("time", dryingTime);
                FMLInterModComms.sendMessage("tconstruct", "addDryingRecipe", rottonFleshTag);

                NBTTagCompound beefTag = new NBTTagCompound();
                beefTag.func_74782_a("input", new ItemStack(Items.field_151082_bd).func_77955_b(new NBTTagCompound()));
                beefTag.func_74782_a("output", TinkerCommons.jerkyBeef.func_77955_b(new NBTTagCompound()));
                beefTag.func_74768_a("time", dryingTime);
                FMLInterModComms.sendMessage("tconstruct", "addDryingRecipe", beefTag);

                NBTTagCompound chickenTag = new NBTTagCompound();
                chickenTag.func_74782_a("input", new ItemStack(Items.field_151076_bf).func_77955_b(new NBTTagCompound()));
                chickenTag.func_74782_a("output", TinkerCommons.jerkyChicken.func_77955_b(new NBTTagCompound()));
                chickenTag.func_74768_a("time", dryingTime);
                FMLInterModComms.sendMessage("tconstruct", "addDryingRecipe", chickenTag);

                NBTTagCompound porkchopTag = new NBTTagCompound();
                porkchopTag.func_74782_a("input", new ItemStack(Items.field_151147_al).func_77955_b(new NBTTagCompound()));
                porkchopTag.func_74782_a("output", TinkerCommons.jerkyPork.func_77955_b(new NBTTagCompound()));
                porkchopTag.func_74768_a("time", dryingTime);
                FMLInterModComms.sendMessage("tconstruct", "addDryingRecipe", porkchopTag);

                NBTTagCompound muttonTag = new NBTTagCompound();
                muttonTag.func_74782_a("input", new ItemStack(Items.field_179561_bm).func_77955_b(new NBTTagCompound()));
                muttonTag.func_74782_a("output", TinkerCommons.jerkyMutton.func_77955_b(new NBTTagCompound()));
                muttonTag.func_74768_a("time", dryingTime);
                FMLInterModComms.sendMessage("tconstruct", "addDryingRecipe", muttonTag);

                NBTTagCompound rabbitTag = new NBTTagCompound();
                rabbitTag.func_74782_a("input", new ItemStack(Items.field_179558_bo).func_77955_b(new NBTTagCompound()));
                rabbitTag.func_74782_a("output", TinkerCommons.jerkyRabbit.func_77955_b(new NBTTagCompound()));
                rabbitTag.func_74768_a("time", dryingTime);
                FMLInterModComms.sendMessage("tconstruct", "addDryingRecipe", rabbitTag);

                NBTTagCompound fishTag = new NBTTagCompound();
                fishTag.func_74782_a("input", new ItemStack(Items.field_151115_aP, 1, 0).func_77955_b(new NBTTagCompound()));
                fishTag.func_74782_a("output", TinkerCommons.jerkyFish.func_77955_b(new NBTTagCompound()));
                fishTag.func_74768_a("time", dryingTime);
                FMLInterModComms.sendMessage("tconstruct", "addDryingRecipe", fishTag);

                NBTTagCompound salmonTag = new NBTTagCompound();
                salmonTag.func_74782_a("input", new ItemStack(Items.field_151115_aP, 1, 1).func_77955_b(new NBTTagCompound()));
                salmonTag.func_74782_a("output", TinkerCommons.jerkySalmon.func_77955_b(new NBTTagCompound()));
                salmonTag.func_74768_a("time", dryingTime);
                FMLInterModComms.sendMessage("tconstruct", "addDryingRecipe", salmonTag);

                NBTTagCompound clownfishTag = new NBTTagCompound();
                clownfishTag.func_74782_a("input", new ItemStack(Items.field_151115_aP, 1, 1).func_77955_b(new NBTTagCompound()));
                clownfishTag.func_74782_a("output", TinkerCommons.jerkyClownfish.func_77955_b(new NBTTagCompound()));
                clownfishTag.func_74768_a("time", dryingTime);
                FMLInterModComms.sendMessage("tconstruct", "addDryingRecipe", clownfishTag);

                NBTTagCompound pufferTag = new NBTTagCompound();
                pufferTag.func_74782_a("input", new ItemStack(Items.field_151115_aP, 1, 1).func_77955_b(new NBTTagCompound()));
                pufferTag.func_74782_a("output", TinkerCommons.jerkyClownfish.func_77955_b(new NBTTagCompound()));
                pufferTag.func_74768_a("time", dryingTime);
                FMLInterModComms.sendMessage("tconstruct", "addDryingRecipe", pufferTag);
            }
        }
    }
}
