/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul;

import com.google.common.collect.ImmutableList;
import iguanaman.hungeroverhaul.common.config.Config;
import iguanaman.hungeroverhaul.module.biomesoplenty.BiomesOPlentyModule;
import iguanaman.hungeroverhaul.module.bonemeal.BonemealModule;
import iguanaman.hungeroverhaul.module.event.HungerOverhaulEventHook;
import iguanaman.hungeroverhaul.module.event.IMCHandler;
import iguanaman.hungeroverhaul.module.food.FoodEventHandler;
import iguanaman.hungeroverhaul.module.food.FoodModifier;
import iguanaman.hungeroverhaul.module.growth.PlantGrowthModule;
import iguanaman.hungeroverhaul.module.harvestcraft.HarvestCraftModule;
import iguanaman.hungeroverhaul.module.harvestcraft.helper.PamsModsHelper;
import iguanaman.hungeroverhaul.module.hunger.RespawnHungerModule;
import iguanaman.hungeroverhaul.module.json.JsonModule;
import iguanaman.hungeroverhaul.module.loot.LootModule;
import iguanaman.hungeroverhaul.module.natura.NaturaModule;
import iguanaman.hungeroverhaul.module.natura.helper.NaturaHelper;
import iguanaman.hungeroverhaul.module.reflection.ReflectionModule;
import iguanaman.hungeroverhaul.module.seed.GrassSeedsModule;
import iguanaman.hungeroverhaul.module.tinkersconstruct.TinkersConstructModule;
import iguanaman.hungeroverhaul.module.tweak.TweaksModule;
import iguanaman.hungeroverhaul.module.vanilla.VanillaModule;
import iguanaman.hungeroverhaul.module.vanilla.potion.PotionWellFed;
import iguanaman.hungeroverhaul.module.village.VillageModule;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="hungeroverhaul", name="Hunger Overhaul", version="1.10.2-1.1.0.jenkins112", dependencies="required-after:Forge@[12.18.0.1993,);required-after:AppleCore;after:tconstruct;after:harvestcraft;after:natura@[1.10.2-4.1.0.24,);after:ic2;after:*", acceptedMinecraftVersions="[1.10.2, 1.11)")
public class HungerOverhaul {
    public static final String modID = "hungeroverhaul";
    public static final String modVersion = "1.10.2-1.1.0.jenkins112";
    public static final String modName = "Hunger Overhaul";
    public static final Logger log = LogManager.getLogger((String)"hungeroverhaul");
    @Mod.Instance(value="hungeroverhaul")
    public static HungerOverhaul instance;
    public static Potion potionWellFed;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.load(event);
        JsonModule.preinit(event.getModConfigurationDirectory());
        potionWellFed = new PotionWellFed();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new FoodEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FoodModifier());
        MinecraftForge.EVENT_BUS.register((Object)new PlantGrowthModule());
        MinecraftForge.EVENT_BUS.register((Object)new BonemealModule());
        VanillaModule.init();
        if (Loader.isModLoaded((String)"harvestcraft")) {
            PamsModsHelper.loadHC();
            HarvestCraftModule.init();
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            TinkersConstructModule.init();
        }
        if (Loader.isModLoaded((String)"natura")) {
            NaturaHelper.loadNatura();
            NaturaModule.init();
        }
        if (Loader.isModLoaded((String)"biomesoplenty")) {
            BiomesOPlentyModule.init();
        }
        JsonModule.init();
        VillageModule.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Config.removeTallGrassSeeds || Config.allSeedsEqual) {
            GrassSeedsModule.postInit();
        }
        VanillaModule.postInit();
        ReflectionModule.postInit();
        TweaksModule.postInit();
        VillageModule.postInit();
        LootModule.postInit();
        MinecraftForge.EVENT_BUS.register((Object)new HungerOverhaulEventHook());
        MinecraftForge.EVENT_BUS.register((Object)new RespawnHungerModule());
        MinecraftForge.EVENT_BUS.register((Object)new LootModule());
    }

    @Mod.EventHandler
    public void handleIMCMessages(FMLInterModComms.IMCEvent event) {
        IMCHandler.processMessages((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }
}

