/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.hungeroverhaul.util;

import com.pam.harvestcraft.ItemPamSeedFood;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import iguanaman.hungeroverhaul.config.IguanaConfig;
import iguanaman.hungeroverhaul.module.ModuleGrassSeeds;
import iguanaman.hungeroverhaul.module.ModulePlantGrowth;
import iguanaman.hungeroverhaul.module.PamsModsHelper;
import iguanaman.hungeroverhaul.util.BlockHelper;
import iguanaman.hungeroverhaul.util.ClientHelper;
import iguanaman.hungeroverhaul.util.ItemAndBlockList;
import iguanaman.hungeroverhaul.util.PlantGrowthModification;
import iguanaman.hungeroverhaul.util.RandomHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.natura.blocks.crops.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodValues;

public class IguanaEventHook {
    private static long lastRightClickCrop;
    public static ItemAndBlockList rightClickHarvestBlacklist;
    public static ItemAndBlockList harvestDropsBlacklist;

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Random rand = new Random();
        if (event.entityLiving instanceof EntityAnimal) {
            NBTTagCompound tags;
            float rndBreed = RandomHelper.nextFloat(rand, IguanaConfig.breedingTimeoutMultiplier);
            float rndChild = RandomHelper.nextFloat(rand, IguanaConfig.childDurationMultiplier);
            EntityAgeable ageable = (EntityAgeable)event.entityLiving;
            int growingAge = ageable.func_70874_b();
            if (growingAge > 0 && rndBreed >= 1.0f) {
                ageable.func_70873_a(++growingAge);
            } else if (growingAge < 0 && rndChild >= 1.0f) {
                ageable.func_70873_a(--growingAge);
            }
            if (IguanaConfig.eggTimeoutMultiplier > 1.0f && event.entityLiving instanceof EntityChicken) {
                float rnd = RandomHelper.nextFloat(rand, IguanaConfig.eggTimeoutMultiplier);
                EntityChicken chicken = (EntityChicken)event.entityLiving;
                if (chicken.field_70887_j > 0 && rnd >= 1.0f) {
                    ++chicken.field_70887_j;
                }
            }
            if (IguanaConfig.milkedTimeout > 0 && event.entityLiving instanceof EntityCow && event.entityLiving.worldObj.func_82737_E() % 20L == 0L && (tags = event.entityLiving.getEntityData()).func_74764_b("Milked")) {
                int milked = tags.func_74762_e("Milked");
                if (--milked <= 0) {
                    tags.func_82580_o("Milked");
                } else {
                    tags.func_74768_a("Milked", milked);
                }
            }
        }
        if (!event.entityLiving.worldObj.field_72995_K) {
            NBTTagCompound tags = event.entityLiving.getEntityData();
            if (tags.func_74764_b("HungerOverhaulCheck")) {
                int lastCheck = tags.func_74762_e("HungerOverhaulCheck");
                if (--lastCheck <= 0) {
                    tags.func_82580_o("HungerOverhaulCheck");
                } else {
                    tags.func_74768_a("HungerOverhaulCheck", lastCheck);
                }
            } else {
                EntityPlayer player;
                float healthPercent = event.entityLiving.func_110143_aJ() / event.entityLiving.func_110138_aP();
                int foodLevel = 20;
                boolean creative = false;
                boolean isPlayer = false;
                if (event.entityLiving instanceof EntityPlayer) {
                    player = (EntityPlayer)event.entityLiving;
                    creative = player.field_71075_bZ.field_75098_d;
                    foodLevel = player.func_71024_bL().func_75116_a();
                    isPlayer = true;
                } else {
                    healthPercent /= 2.0f;
                }
                if (event.entityLiving instanceof EntityPlayer && IguanaConfig.constantHungerLoss) {
                    player = (EntityPlayer)event.entityLiving;
                    if (!player.field_71075_bZ.field_75098_d && !player.field_70128_L) {
                        player.func_71020_j(0.01f);
                    }
                }
                if (IguanaConfig.addLowStatEffects) {
                    int difficultyModifierEffects = 2;
                    if (IguanaConfig.difficultyScalingEffects && event.entityLiving.worldObj.difficultySetting != null) {
                        difficultyModifierEffects = event.entityLiving.worldObj.difficultySetting.func_151525_a();
                        if (!(event.entityLiving instanceof EntityPlayer)) {
                            difficultyModifierEffects = difficultyModifierEffects * -1 + 3;
                        }
                    }
                    if (!creative && isPlayer && !event.entityLiving.field_70128_L && healthPercent > 0.0f) {
                        if (IguanaConfig.addLowHealthSlowness || IguanaConfig.addLowHungerSlowness) {
                            if (IguanaConfig.addLowHungerSlowness && foodLevel <= 1 || IguanaConfig.addLowHealthSlowness && healthPercent <= 0.05f) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.moveSlowdown.id, 19, 1 + difficultyModifierEffects, true));
                            } else if (IguanaConfig.addLowHungerSlowness && foodLevel <= 2 || IguanaConfig.addLowHealthSlowness && healthPercent <= 0.1f) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.moveSlowdown.id, 19, difficultyModifierEffects, true));
                            } else if ((IguanaConfig.addLowHungerSlowness && foodLevel <= 3 || IguanaConfig.addLowHealthSlowness && healthPercent <= 0.15f) && difficultyModifierEffects >= 1) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.moveSlowdown.id, 19, -1 + difficultyModifierEffects, true));
                            } else if ((IguanaConfig.addLowHungerSlowness && foodLevel <= 4 || IguanaConfig.addLowHealthSlowness && healthPercent <= 0.2f) && difficultyModifierEffects >= 2) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.moveSlowdown.id, 19, -2 + difficultyModifierEffects, true));
                            } else if ((IguanaConfig.addLowHungerSlowness && foodLevel <= 5 || IguanaConfig.addLowHealthSlowness && healthPercent <= 0.25f) && difficultyModifierEffects >= 3) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.moveSlowdown.id, 19, -3 + difficultyModifierEffects, true));
                            }
                        }
                        if (IguanaConfig.addLowHealthMiningSlowdown || IguanaConfig.addLowHungerMiningSlowdown) {
                            if (IguanaConfig.addLowHungerMiningSlowdown && foodLevel <= 1 || IguanaConfig.addLowHealthMiningSlowdown && healthPercent <= 0.05f) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.digSlowdown.id, 19, 1 + difficultyModifierEffects, true));
                            } else if (IguanaConfig.addLowHungerMiningSlowdown && foodLevel <= 2 || IguanaConfig.addLowHealthMiningSlowdown && healthPercent <= 0.1f) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.digSlowdown.id, 19, difficultyModifierEffects, true));
                            } else if ((IguanaConfig.addLowHungerMiningSlowdown && foodLevel <= 3 || IguanaConfig.addLowHealthMiningSlowdown && healthPercent <= 0.15f) && difficultyModifierEffects >= 1) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.digSlowdown.id, 19, -1 + difficultyModifierEffects, true));
                            } else if ((IguanaConfig.addLowHungerMiningSlowdown && foodLevel <= 4 || IguanaConfig.addLowHealthMiningSlowdown && healthPercent <= 0.2f) && difficultyModifierEffects >= 2) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.digSlowdown.id, 19, -2 + difficultyModifierEffects, true));
                            } else if ((IguanaConfig.addLowHungerMiningSlowdown && foodLevel <= 5 || IguanaConfig.addLowHealthMiningSlowdown && healthPercent <= 0.25f) && difficultyModifierEffects >= 3) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.digSlowdown.id, 19, -3 + difficultyModifierEffects, true));
                            }
                        }
                        if (IguanaConfig.addLowHealthWeakness || IguanaConfig.addLowHungerWeakness) {
                            if ((IguanaConfig.addLowHungerWeakness && foodLevel <= 1 || IguanaConfig.addLowHealthWeakness && healthPercent <= 0.05f) && difficultyModifierEffects >= 1) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.weakness.id, 19, -1 + difficultyModifierEffects, true));
                            } else if ((IguanaConfig.addLowHungerWeakness && foodLevel <= 2 || IguanaConfig.addLowHealthWeakness && healthPercent <= 0.1f) && difficultyModifierEffects >= 2) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.weakness.id, 19, -2 + difficultyModifierEffects, true));
                            } else if ((IguanaConfig.addLowHungerWeakness && foodLevel <= 3 || IguanaConfig.addLowHealthWeakness && healthPercent <= 0.15f) && difficultyModifierEffects >= 3) {
                                event.entityLiving.func_70690_d(new PotionEffect(Potion.weakness.id, 19, -3 + difficultyModifierEffects, true));
                            }
                        }
                        if (IguanaConfig.addLowHungerNausea && foodLevel <= 1 || IguanaConfig.addLowHealthNausea && healthPercent <= 0.05f) {
                            event.entityLiving.func_70690_d(new PotionEffect(Potion.confusion.id, 19, 0, true));
                        }
                    }
                }
                tags.func_74768_a("HungerOverhaulCheck", 9);
            }
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event) {
        if (IguanaConfig.modifyHoeUse) {
            Block block = event.world.getBlock(event.x, event.y, event.z);
            if ((block == Blocks.dirt || block == Blocks.grass) && this.isWaterNearby(event.world, event.x, event.y, event.z)) {
                if (IguanaConfig.hoeToolDamageMultiplier > 1) {
                    event.current.func_77972_a(IguanaConfig.hoeToolDamageMultiplier - 1, (EntityLivingBase)event.entityPlayer);
                }
            } else if (block == Blocks.grass && !this.isWaterNearby(event.world, event.x, event.y, event.z)) {
                Block block1 = Blocks.farmland;
                event.world.playSoundEffect((double)((float)event.x + 0.5f), (double)((float)event.y + 0.5f), (double)((float)event.z + 0.5f), block1.stepSound.soundName, (block1.stepSound.getVolume() + 1.0f) / 2.0f, block1.stepSound.getPitch() * 0.8f);
                if (!event.world.field_72995_K && IguanaConfig.seedChance > 0) {
                    ItemStack seed;
                    int seedChance = IguanaConfig.seedChance;
                    if (event.world.difficultySetting.func_151525_a() < 2) {
                        seedChance *= 2;
                    } else if (event.world.difficultySetting.func_151525_a() == 3) {
                        seedChance = Math.max(Math.round((float)seedChance / 2.0f), 1);
                    }
                    if (event.world.field_73012_v.nextInt(100) <= seedChance && (seed = ModuleGrassSeeds.getSeedFromTillingGrass(event.world)) != null) {
                        block.dropBlockAsItem(event.world, event.x, event.y, event.z, seed);
                    }
                    event.world.setBlock(event.x, event.y, event.z, Blocks.dirt);
                }
                if (IguanaConfig.hoeToolDamageMultiplier > 1) {
                    event.current.func_77972_a(IguanaConfig.hoeToolDamageMultiplier - 1, (EntityLivingBase)event.entityPlayer);
                }
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        if (IguanaConfig.addGuiText) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.thePlayer;
            if (!(player.field_70128_L || player.field_71075_bZ.field_75098_d || mc.field_71474_y.field_74330_P)) {
                float healthPercent = player.func_110143_aJ() / player.func_110138_aP();
                if (healthPercent <= 0.15f) {
                    event.left.add(EnumChatFormatting.RED + StatCollector.translateToLocal((String)"hungeroverhaul.dying") + EnumChatFormatting.RESET);
                } else if (healthPercent <= 0.3f) {
                    event.left.add(EnumChatFormatting.YELLOW + StatCollector.translateToLocal((String)"hungeroverhaul.injured") + EnumChatFormatting.RESET);
                } else if (healthPercent < 0.5f) {
                    event.left.add(EnumChatFormatting.WHITE + StatCollector.translateToLocal((String)"hungeroverhaul.hurt") + EnumChatFormatting.RESET);
                }
                if (player.func_71024_bL().func_75116_a() <= 6) {
                    event.right.add(EnumChatFormatting.RED + StatCollector.translateToLocal((String)"hungeroverhaul.starving") + EnumChatFormatting.RESET);
                } else if (player.func_71024_bL().func_75116_a() <= 10) {
                    event.right.add(EnumChatFormatting.YELLOW + StatCollector.translateToLocal((String)"hungeroverhaul.hungry") + EnumChatFormatting.RESET);
                } else if (player.func_71024_bL().func_75116_a() <= 14) {
                    event.right.add(EnumChatFormatting.WHITE + StatCollector.translateToLocal((String)"hungeroverhaul.peckish") + EnumChatFormatting.RESET);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(EntityInteractEvent event) {
        if (IguanaConfig.milkedTimeout > 0 && event.entityPlayer != null && event.target != null && event.target instanceof EntityCow) {
            Item item;
            EntityCow cow = (EntityCow)event.target;
            EntityPlayer player = event.entityPlayer;
            ItemStack equipped = player.getCurrentEquippedItem();
            if (equipped != null && equipped.func_77973_b() != null && ((item = equipped.func_77973_b()) instanceof ItemBucket && ((ItemBucket)item).isFull == Blocks.air || cow instanceof EntityMooshroom && item == Items.bowl)) {
                NBTTagCompound tags = cow.getEntityData();
                if (tags.func_74764_b("Milked")) {
                    event.setCanceled(true);
                    if (!player.worldObj.field_72995_K) {
                        cow.playSound("mob.cow.hurt", 0.4f, (event.entity.worldObj.field_73012_v.nextFloat() - event.entity.worldObj.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    }
                } else {
                    tags.func_74768_a("Milked", IguanaConfig.milkedTimeout * 60);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            AppleCoreAPI.mutator.setHealthRegenTickCounter(player, 0);
        }
    }

    @SubscribeEvent
    public void onPlayerInteraction(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR && lastRightClickCrop == event.world.func_82737_E()) {
            event.setCanceled(true);
        }
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (IguanaConfig.foodsUnplantable && Loader.isModLoaded((String)"harvestcraft") && event.entityPlayer.getHeldItem() != null && event.entityPlayer.getHeldItem().func_77973_b() instanceof ItemPamSeedFood) {
            if (event.world.field_72995_K) {
                if (PamsModsHelper.canPlantSeedFoodAt(event.entityPlayer, event.entityPlayer.getHeldItem(), event.world, event.x, event.y, event.z, event.face)) {
                    event.setCanceled(true);
                }
            } else {
                event.useItem = Event.Result.DENY;
            }
            return;
        }
        if (!IguanaConfig.enableRightClickHarvesting) {
            return;
        }
        Block clicked = event.world.getBlock(event.x, event.y, event.z);
        int meta = event.world.getBlockMetadata(event.x, event.y, event.z);
        int resultingMeta = -1;
        if (rightClickHarvestBlacklist.contains(clicked)) {
            return;
        }
        if (Loader.isModLoaded((String)"Natura") && clicked instanceof CropBlock) {
            if (meta == 3 || meta == 8) {
                resultingMeta = meta == 3 ? 0 : 4;
            }
        } else if (clicked instanceof BlockCrops && meta >= 7) {
            resultingMeta = 0;
        }
        if (resultingMeta >= 0) {
            if (!event.world.field_72995_K && !event.world.restoringBlockSnapshots) {
                ArrayList drops = clicked.getDrops(event.world, event.x, event.y, event.z, meta, 0);
                float odds = ForgeEventFactory.fireBlockHarvesting((ArrayList)drops, (World)event.world, (Block)clicked, (int)event.x, (int)event.y, (int)event.z, (int)meta, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)event.entityPlayer);
                List<ItemStack> modifiedDrops = BlockHelper.modifyCropDrops(drops, clicked, meta, IguanaConfig.seedsPerHarvestRightClickMin, IguanaConfig.seedsPerHarvestRightClickMax, IguanaConfig.producePerHarvestRightClickMin, IguanaConfig.producePerHarvestRightClickMax);
                for (ItemStack drop : modifiedDrops) {
                    clicked.dropBlockAsItem(event.world, event.x, event.y, event.z, drop);
                }
            }
            event.world.setBlockMetadataWithNotify(event.x, event.y, event.z, resultingMeta, 2);
            lastRightClickCrop = event.world.func_82737_E();
            if (event.world.field_72995_K) {
                ClientHelper.sendRightClickPacket(event.x, event.y, event.z, event.face, event.entityPlayer.field_71071_by.func_70448_g(), 0.0f, 0.0f, 0.0f);
                event.setCanceled(true);
            } else {
                event.useItem = Event.Result.DENY;
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        boolean fullyGrown;
        boolean eligable;
        if (!IguanaConfig.modifyCropDropsBreak) {
            return;
        }
        if (harvestDropsBlacklist.contains(event.block)) {
            return;
        }
        boolean isNaturaCrop = Loader.isModLoaded((String)"Natura") && event.block instanceof CropBlock;
        boolean bl = eligable = isNaturaCrop || event.block instanceof BlockCrops;
        if (!eligable) {
            return;
        }
        boolean bl2 = fullyGrown = !isNaturaCrop && event.blockMetadata >= 7 || isNaturaCrop && event.blockMetadata == 3 || event.blockMetadata == 8;
        if (!fullyGrown) {
            return;
        }
        List<ItemStack> modifiedDrops = BlockHelper.modifyCropDrops(event.drops, event.block, event.blockMetadata, IguanaConfig.seedsPerHarvestBreakMin, IguanaConfig.seedsPerHarvestBreakMax, IguanaConfig.producePerHarvestBreakMin, IguanaConfig.producePerHarvestBreakMax);
        event.drops.clear();
        for (ItemStack drop : modifiedDrops) {
            event.drops.add(drop);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderTooltips(ItemTooltipEvent event) {
        if (IguanaConfig.addFoodTooltips && AppleCoreAPI.accessor.isFood(event.itemStack)) {
            FoodValues values = FoodValues.get((ItemStack)event.itemStack);
            int hungerFill = values.hunger;
            float satiation = values.saturationModifier * 20.0f - (float)hungerFill;
            String mealDescriptor = "";
            String adjective = null;
            String noun = hungerFill <= 1 ? "morsel" : (hungerFill <= 2 ? "snack" : (hungerFill <= 5 ? "lightmeal" : (hungerFill <= 8 ? "meal" : (hungerFill <= 11 ? "largemeal" : "feast"))));
            if (satiation >= 3.0f) {
                adjective = "hearty";
            } else if (satiation >= 2.0f) {
                adjective = "wholesome";
            } else if (satiation > 0.0f) {
                adjective = "nourishing";
            } else if (satiation < 0.0f) {
                adjective = "unfulfilling";
            }
            if (adjective != null && StatCollector.canTranslate((String)("hungeroverhaul." + adjective + "." + noun))) {
                mealDescriptor = StatCollector.translateToLocal((String)("hungeroverhaul." + adjective + "." + noun));
            } else {
                mealDescriptor = StatCollector.translateToLocal((String)("hungeroverhaul." + noun));
                if (adjective != null) {
                    mealDescriptor = StatCollector.translateToLocalFormatted((String)StatCollector.translateToLocal((String)("hungeroverhaul." + adjective)), (Object[])new Object[]{mealDescriptor});
                }
            }
            int topIndex = event.toolTip.size() > 0 ? 1 : 0;
            event.toolTip.add(topIndex, mealDescriptor.substring(0, 1).toUpperCase() + mealDescriptor.substring(1));
        }
        if (IguanaConfig.wrongBiomeRegrowthMultiplier > 1.0f) {
            PlantGrowthModification growthModification = null;
            if (event.itemStack.func_77973_b() instanceof IPlantable) {
                growthModification = ModulePlantGrowth.getPlantGrowthModification(((IPlantable)event.itemStack.func_77973_b()).getPlant((IBlockAccess)event.entityPlayer.worldObj, 0, 0, 0));
            } else if (event.itemStack.func_77973_b() instanceof ItemBlock) {
                Block block = Block.func_149634_a((Item)event.itemStack.func_77973_b());
                if (block != null) {
                    growthModification = ModulePlantGrowth.getPlantGrowthModification(block);
                }
            } else {
                Block block = PamsModsHelper.fruitItemToBlockMap.get(event.itemStack.func_77973_b());
                if (block != null) {
                    growthModification = ModulePlantGrowth.getPlantGrowthModification(block);
                }
            }
            if (growthModification != null && !growthModification.biomeGrowthModifiers.isEmpty()) {
                String tooltip = "";
                for (BiomeDictionary.Type biomeType : growthModification.biomeGrowthModifiers.keySet()) {
                    tooltip = tooltip + biomeType.toString().substring(0, 1).toUpperCase() + biomeType.toString().substring(1).toLowerCase() + ", ";
                }
                event.toolTip.add(StatCollector.translateToLocal((String)"hungeroverhaul.crop.grows.best.in"));
                event.toolTip.add(tooltip.substring(0, tooltip.length() - 2));
            }
        }
    }

    private boolean isWaterNearby(World par1World, int par2, int par3, int par4) {
        for (int l = par2 - 4; l <= par2 + 4; ++l) {
            for (int i1 = par3; i1 <= par3 + 1; ++i1) {
                for (int j1 = par4 - 4; j1 <= par4 + 4; ++j1) {
                    if (par1World.getBlock(l, i1, j1).getMaterial() != Material.water) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        Block infusedGrain;
        Block enderLilly;
        lastRightClickCrop = 0L;
        rightClickHarvestBlacklist = new ItemAndBlockList();
        harvestDropsBlacklist = new ItemAndBlockList();
        if (Loader.isModLoaded((String)"ExtraUtilities") && (enderLilly = Block.func_149684_b((String)"ExtraUtilities:plant/ender_lilly")) != null) {
            rightClickHarvestBlacklist.add(enderLilly);
            harvestDropsBlacklist.add(enderLilly);
        }
        if (Loader.isModLoaded((String)"ThaumicTinkerer") && (infusedGrain = Block.func_149684_b((String)"ThaumicTinkerer:infusedGrainBlock")) != null) {
            harvestDropsBlacklist.add(infusedGrain);
        }
    }
}

