/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.crafting.Detailing;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.TabTools;

public class TConstructRegistry {
    public static TConstructRegistry instance = new TConstructRegistry();
    public static TabTools toolTab;
    public static TabTools materialTab;
    public static TabTools blockTab;
    public static HashMap<String, Item> itemDirectory;
    static HashMap<String, ItemStack> itemstackDirectory;
    public static ArrayList<ToolCore> tools;
    public static HashMap<List, ItemStack> patternPartMapping;
    public static HashMap<Integer, ToolMaterial> toolMaterials;
    public static HashMap<String, ToolMaterial> toolMaterialStrings;
    public static HashMap<Integer, BowMaterial> bowMaterials;
    public static HashMap<Integer, ArrowMaterial> arrowMaterials;
    public static ArrayList<CustomMaterial> customMaterials;
    public static ArrayList<ActiveToolMod> activeModifiers;
    public static int[] drawbridgeState;
    public static int[] interchangableBlockMapping;
    public static int[] blockToItemMapping;

    public static void addItemToDirectory(String name, Item itemstack) {
        Item add = itemDirectory.get(name);
        if (add != null) {
            System.out.println("[TCon API] " + name + " is already present in the Item directory");
        }
        itemDirectory.put(name, itemstack);
    }

    public static Item getItem(String name) {
        Item ret = itemDirectory.get(name);
        if (ret == null) {
            System.out.println("[TCon API] Could not find " + name + " in the Item directory");
        }
        return ret;
    }

    public static void addItemStackToDirectory(String name, ItemStack itemstack) {
        ItemStack add = itemstackDirectory.get(name);
        if (add != null) {
            System.out.println("[TCon API] " + name + " is already present in the ItemStack directory");
        }
        itemstackDirectory.put(name, itemstack);
    }

    public static ItemStack getItemStack(String name) {
        ItemStack ret = itemstackDirectory.get(name);
        if (ret == null) {
            System.out.println("[TCon API] Could not find " + name + " in the ItemStack directory");
        }
        return ret;
    }

    public static void addPartMapping(int patternID, int patternMeta, int materialID, ItemStack output) {
        patternPartMapping.put(Arrays.asList(patternID, patternMeta, materialID), output);
    }

    public static ItemStack getPartMapping(int itemID, int metadata, int materialID) {
        ItemStack stack = patternPartMapping.get(Arrays.asList(itemID, metadata, materialID));
        if (stack != null) {
            return stack.func_77946_l();
        }
        return null;
    }

    public static void addToolMapping(ToolCore tool) {
        tools.add(tool);
    }

    public static ArrayList<ToolCore> getToolMapping() {
        return tools;
    }

    public static void addToolRecipe(ToolCore output, Item ... parts) {
        ToolBuilder tb = ToolBuilder.instance;
        if (parts.length < 1 || parts.length > 4 || parts.length == 3) {
            System.out.println("[TCon API] Wrong amount of items to craft into a tool");
        }
        ToolBuilder.addToolRecipe(output, parts);
    }

    public static void addToolMaterial(int materialID, String materialName, int harvestLevel, int durability, int miningspeed, int attack, float handleModifier, int reinforced, float stonebound, String style, String ability) {
        ToolMaterial mat = toolMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Material ID " + materialID + " is already occupied by " + mat.materialName);
        }
        mat = new ToolMaterial(materialName, harvestLevel, durability, miningspeed, attack, handleModifier, reinforced, stonebound, style, ability);
        toolMaterials.put(materialID, mat);
        toolMaterialStrings.put(materialName, mat);
    }

    public static void addToolMaterial(int materialID, String materialName, String displayName, int harvestLevel, int durability, int miningspeed, int attack, float handleModifier, int reinforced, float stonebound, String style, String ability) {
        ToolMaterial mat = toolMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Material ID " + materialID + " is already occupied by " + mat.materialName);
        }
        mat = new ToolMaterial(materialName, displayName, harvestLevel, durability, miningspeed, attack, handleModifier, reinforced, stonebound, style, ability);
        toolMaterials.put(materialID, mat);
        toolMaterialStrings.put(materialName, mat);
    }

    public static void addtoolMaterial(int materialID, ToolMaterial material) {
        ToolMaterial mat = toolMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Material ID " + materialID + " is already occupied by " + mat.materialName);
        }
        toolMaterials.put(materialID, mat);
        toolMaterialStrings.put(material.name(), mat);
    }

    public static ToolMaterial getMaterial(int key) {
        return toolMaterials.get(key);
    }

    public static ToolMaterial getMaterial(String key) {
        return toolMaterialStrings.get(key);
    }

    public static void addBowMaterial(int materialID, int durability, int drawSpeed, float speedMax) {
        BowMaterial mat = bowMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Bow Material ID " + materialID + " is already occupied");
        }
        mat = new BowMaterial(durability, drawSpeed, speedMax);
        bowMaterials.put(materialID, mat);
    }

    public static boolean validBowMaterial(int materialID) {
        return bowMaterials.containsKey(materialID);
    }

    public static BowMaterial getBowMaterial(int materialID) {
        return bowMaterials.get(materialID);
    }

    public static void addArrowMaterial(int materialID, float mass, float breakChance, float accuracy) {
        ArrowMaterial mat = arrowMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Arrow Material ID " + materialID + " is already occupied");
        }
        mat = new ArrowMaterial(mass, breakChance, accuracy);
        arrowMaterials.put(materialID, mat);
    }

    public static boolean validArrowMaterial(int materialID) {
        return arrowMaterials.containsKey(materialID);
    }

    public static ArrowMaterial getArrowMaterial(int materialID) {
        return arrowMaterials.get(materialID);
    }

    public static void addCustomMaterial(CustomMaterial mat) {
        if (mat != null) {
            customMaterials.add(mat);
        }
    }

    public static void addBowstringMaterial(int materialID, int value, ItemStack input, ItemStack craftingMaterial, float durability, float drawSpeed, float flightSpeed) {
        BowstringMaterial mat = new BowstringMaterial(materialID, value, input, craftingMaterial, durability, drawSpeed, flightSpeed);
        customMaterials.add(mat);
    }

    public static void addFletchingMaterial(int materialID, int value, ItemStack input, ItemStack craftingMaterial, float accuracy, float breakChance, float mass) {
        FletchingMaterial mat = new FletchingMaterial(materialID, value, input, craftingMaterial, accuracy, breakChance, mass);
        customMaterials.add(mat);
    }

    public static CustomMaterial getCustomMaterial(int materialID, Class<? extends CustomMaterial> clazz) {
        for (CustomMaterial mat : customMaterials) {
            if (!mat.getClass().equals(clazz) || mat.materialID != materialID) continue;
            return mat;
        }
        return null;
    }

    public static CustomMaterial getCustomMaterial(ItemStack input, Class<? extends CustomMaterial> clazz) {
        for (CustomMaterial mat : customMaterials) {
            if (!mat.getClass().equals(clazz) || !input.func_77969_a(mat.input)) continue;
            return mat;
        }
        return null;
    }

    public static LiquidCasting getTableCasting() {
        return instance.tableCasting();
    }

    LiquidCasting tableCasting() {
        try {
            Class<?> clazz = Class.forName("tconstruct.TConstruct");
            Method method = clazz.getMethod("getTableCasting", new Class[0]);
            LiquidCasting lc = (LiquidCasting)method.invoke((Object)this, new Object[0]);
            return lc;
        }
        catch (Exception e) {
            System.out.println("[TCon API] Could not find casting table recipes.");
            return null;
        }
    }

    public static LiquidCasting getBasinCasting() {
        return instance.basinCasting();
    }

    LiquidCasting basinCasting() {
        try {
            Class<?> clazz = Class.forName("tconstruct.TConstruct");
            Method method = clazz.getMethod("getBasinCasting", new Class[0]);
            LiquidCasting lc = (LiquidCasting)method.invoke((Object)this, new Object[0]);
            return lc;
        }
        catch (Exception e) {
            System.out.println("[TCon API] Could not find casting basin recipes.");
            return null;
        }
    }

    public static Detailing getChiselDetailing() {
        return instance.chiselDetailing();
    }

    Detailing chiselDetailing() {
        try {
            Class<?> clazz = Class.forName("tconstruct.TConstruct");
            Method method = clazz.getMethod("getChiselDetailing", new Class[0]);
            Detailing lc = (Detailing)method.invoke((Object)this, new Object[0]);
            return lc;
        }
        catch (Exception e) {
            System.out.println("[TCon API] Could not find chisel detailing recipes.");
            return null;
        }
    }

    public static void registerActiveToolMod(ActiveToolMod mod) {
        activeModifiers.add(mod);
    }

    static void initializeDrawbridgeState() {
        TConstructRegistry.drawbridgeState[Block.field_71981_t.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71980_u.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71979_v.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71978_w.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71986_z.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_71942_A.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71943_B.field_71990_ca] = 1;
        TConstructRegistry.interchangableBlockMapping[Block.field_71943_B.field_71990_ca] = Block.field_71942_A.field_71990_ca;
        TConstructRegistry.interchangableBlockMapping[Block.field_71942_A.field_71990_ca] = Block.field_71943_B.field_71990_ca;
        TConstructRegistry.drawbridgeState[Block.field_71944_C.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71938_D.field_71990_ca] = 1;
        TConstructRegistry.interchangableBlockMapping[Block.field_71938_D.field_71990_ca] = Block.field_71944_C.field_71990_ca;
        TConstructRegistry.interchangableBlockMapping[Block.field_71944_C.field_71990_ca] = Block.field_71938_D.field_71990_ca;
        TConstructRegistry.drawbridgeState[Block.field_71939_E.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71940_F.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71941_G.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71949_H.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71950_I.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71945_L.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71947_N.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71948_O.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71958_P.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_71960_R.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71959_S.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_71954_T.field_71990_ca] = 4;
        TConstructRegistry.drawbridgeState[Block.field_71953_U.field_71990_ca] = 4;
        TConstructRegistry.drawbridgeState[Block.field_71956_V.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_71955_W.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71963_Z.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72099_aa.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_72097_ad.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72107_ae.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72109_af.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72103_ag.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72105_ah.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72083_ai.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72081_al.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72091_am.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72093_an.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72087_ao.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72089_ap.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72069_aq.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72067_ar.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72065_as.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_72063_at.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72077_au.field_71990_ca] = 5;
        TConstructRegistry.drawbridgeState[Block.field_72075_av.field_71990_ca] = 1;
        TConstructRegistry.blockToItemMapping[Block.field_72075_av.field_71990_ca] = Item.field_77767_aC.field_77779_bT;
        TConstructRegistry.blockToItemMapping[Item.field_77767_aC.field_77779_bT] = Block.field_72075_av.field_71990_ca;
        TConstructRegistry.drawbridgeState[Block.field_72073_aw.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72071_ax.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72060_ay.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72058_az.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_72050_aA.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72051_aB.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72052_aC.field_71990_ca] = 3;
        TConstructRegistry.interchangableBlockMapping[Block.field_72051_aB.field_71990_ca] = Block.field_72052_aC.field_71990_ca;
        TConstructRegistry.interchangableBlockMapping[Block.field_72052_aC.field_71990_ca] = Block.field_72051_aB.field_71990_ca;
        TConstructRegistry.drawbridgeState[Block.field_72050_aA.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72053_aD.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72054_aE.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_72055_aF.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72056_aG.field_71990_ca] = 4;
        TConstructRegistry.drawbridgeState[Block.field_72057_aH.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72042_aI.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72043_aJ.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72044_aK.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72045_aL.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_72046_aM.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72047_aN.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72048_aO.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72049_aP.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72035_aQ.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72034_aR.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72037_aS.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72036_aT.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72039_aU.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72038_aV.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_72041_aW.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72040_aX.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72032_aY.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72031_aZ.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72061_ba.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72012_bb.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72013_bc.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72014_bd.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72015_be.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_72008_bf.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72009_bg.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_72010_bh.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72011_bi.field_71990_ca] = 3;
        TConstructRegistry.interchangableBlockMapping[Block.field_72010_bh.field_71990_ca] = Block.field_72011_bi.field_71990_ca;
        TConstructRegistry.interchangableBlockMapping[Block.field_72011_bi.field_71990_ca] = Block.field_72010_bh.field_71990_ca;
        TConstructRegistry.blockToItemMapping[Block.field_72010_bh.field_71990_ca] = Item.field_77742_bb.field_77779_bT;
        TConstructRegistry.blockToItemMapping[Block.field_72011_bi.field_71990_ca] = Item.field_77742_bb.field_77779_bT;
        TConstructRegistry.blockToItemMapping[Item.field_77742_bb.field_77779_bT] = Block.field_72010_bh.field_71990_ca;
        TConstructRegistry.drawbridgeState[Block.field_72004_bj.field_71990_ca] = 5;
        TConstructRegistry.drawbridgeState[Block.field_72005_bk.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72000_bn.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72001_bo.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72002_bp.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72003_bq.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71997_br.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71996_bs.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_71999_bt.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_71998_bu.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_71993_bv.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_71992_bw.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_71995_bx.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_71994_by.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_71991_bz.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72033_bA.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72098_bB.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72098_bB.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72094_bD.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_72096_bE.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72106_bF.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72108_bG.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72102_bH.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_72084_bK.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72078_bL.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72080_bM.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72086_bP.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_72088_bQ.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72068_bR.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72066_bS.field_71990_ca] = 5;
        TConstructRegistry.drawbridgeState[Block.field_72064_bT.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72062_bU.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72076_bV.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_72074_bW.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72072_bX.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_72070_bY.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_82517_cc.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_82518_cd.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_82515_ce.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_82516_cf.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_82513_cg.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_82514_ch.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_82511_ci.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_82512_cj.field_71990_ca] = 2;
        TConstructRegistry.drawbridgeState[Block.field_94347_ck.field_71990_ca] = 5;
        TConstructRegistry.drawbridgeState[Block.field_94348_cl.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_94345_cm.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_94346_cn.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_94343_co.field_71990_ca] = 1;
        TConstructRegistry.interchangableBlockMapping[Block.field_94346_cn.field_71990_ca] = Block.field_94343_co.field_71990_ca;
        TConstructRegistry.interchangableBlockMapping[Block.field_94343_co.field_71990_ca] = Block.field_94346_cn.field_71990_ca;
        TConstructRegistry.blockToItemMapping[Block.field_94346_cn.field_71990_ca] = Item.field_94585_bY.field_77779_bT;
        TConstructRegistry.blockToItemMapping[Block.field_94343_co.field_71990_ca] = Item.field_94585_bY.field_77779_bT;
        TConstructRegistry.blockToItemMapping[Item.field_94585_bY.field_77779_bT] = Block.field_94346_cn.field_71990_ca;
        TConstructRegistry.drawbridgeState[Block.field_94344_cp.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_94341_cq.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_94342_cr.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_94340_cs.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_94339_ct.field_71990_ca] = 1;
        TConstructRegistry.drawbridgeState[Block.field_94338_cu.field_71990_ca] = 3;
        TConstructRegistry.drawbridgeState[Block.field_94337_cv.field_71990_ca] = 4;
        TConstructRegistry.drawbridgeState[Block.field_96469_cy.field_71990_ca] = 3;
        TConstructRegistry.interchangableBlockMapping[Block.field_71979_v.field_71990_ca] = Block.field_71980_u.field_71990_ca;
        TConstructRegistry.interchangableBlockMapping[Block.field_71980_u.field_71990_ca] = Block.field_71979_v.field_71990_ca;
    }

    static {
        itemDirectory = new HashMap();
        itemstackDirectory = new HashMap();
        tools = new ArrayList(20);
        patternPartMapping = new HashMap();
        toolMaterials = new HashMap(40);
        toolMaterialStrings = new HashMap(40);
        bowMaterials = new HashMap(40);
        arrowMaterials = new HashMap(40);
        customMaterials = new ArrayList();
        activeModifiers = new ArrayList();
        drawbridgeState = new int[Block.field_71973_m.length];
        interchangableBlockMapping = new int[Block.field_71973_m.length];
        blockToItemMapping = new int[Item.field_77698_e.length];
        TConstructRegistry.initializeDrawbridgeState();
    }
}

