/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class RareTreeGen
extends WorldGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final int metaWood;
    public final int metaLeaves;
    public final boolean seekHeight;

    public RareTreeGen(boolean notify, int treeHeight, int treeRange, int woodMeta, int leavesMeta) {
        super(notify);
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.metaWood = woodMeta;
        this.metaLeaves = leavesMeta;
        this.seekHeight = !notify;
    }

    public boolean func_76484_a(World world, Random random, int xPos, int yPos, int zPos) {
        int height = random.nextInt(this.treeHeightRange) + this.minTreeHeight;
        boolean flag = true;
        if (this.seekHeight && (yPos = this.findGround(world, xPos, yPos, zPos)) == -1) {
            return false;
        }
        if (yPos >= 1 && yPos + height + 1 <= 256) {
            boolean isSoil;
            Block soil = Block.field_71973_m[world.func_72798_a(xPos, yPos - 1, zPos)];
            boolean bl = isSoil = soil != null && soil.canSustainPlant(world, xPos, yPos - 1, zPos, ForgeDirection.UP, (IPlantable)NContent.rareSapling);
            if (isSoil) {
                if (!this.checkClear(world, xPos, yPos, zPos, height)) {
                    return false;
                }
                soil.onPlantGrow(world, xPos, yPos - 1, zPos, xPos, yPos, zPos);
                this.placeCanopy(world, random, xPos, yPos, zPos, height);
                this.placeTrunk(world, xPos, yPos, zPos, height);
                return true;
            }
        }
        return false;
    }

    boolean checkClear(World world, int x, int y, int z, int treeHeight) {
        for (int yPos = 0; yPos < treeHeight + 1; ++yPos) {
            int range = 1;
            if (yPos == 0) {
                range = 0;
            } else if (yPos >= treeHeight - 1) {
                range = 2;
            }
            for (int xPos = range; xPos <= range; ++xPos) {
                for (int zPos = range; zPos <= range; ++zPos) {
                    int blockID = world.func_72798_a(x + xPos, y + yPos, z + zPos);
                    Block block = Block.field_71973_m[blockID];
                    if (block == null || blockID == NContent.rareSapling.blockID || block.isLeaves(world, x + xPos, y + yPos, z + zPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    int findGround(World world, int x, int y, int z) {
        int ret = -1;
        int height = y;
        do {
            int heightID;
            if ((heightID = world.func_72798_a(x, height, z)) != Block.field_71979_v.field_71990_ca && heightID != Block.field_71980_u.blockID || Block.field_71970_n[world.func_72798_a(x, height + 1, z)]) continue;
            ret = height + 1;
            break;
        } while (--height > PHNatura.seaLevel);
        return ret;
    }

    void placeCanopy(World world, Random random, int xPos, int yPos, int zPos, int height) {
        for (int y = yPos - 3 + height; y <= yPos + height; ++y) {
            int k1 = y - (yPos + height);
            int i2 = 1 - k1 / 2;
            for (int x = xPos - i2; x <= xPos + i2; ++x) {
                int k2 = x - xPos;
                for (int z = zPos - i2; z <= zPos + i2; ++z) {
                    Block block;
                    int i3 = z - zPos;
                    if (Math.abs(k2) == i2 && Math.abs(i3) == i2 && (random.nextInt(2) == 0 || k1 == 0) || (block = Block.field_71973_m[world.func_72798_a(x, y, z)]) != null && !block.canBeReplacedByLeaves(world, x, y, z)) continue;
                    this.func_76485_a(world, x, y, z, NContent.rareLeaves.blockID, this.metaLeaves);
                }
            }
        }
    }

    void placeTrunk(World world, int xPos, int yPos, int zPos, int height) {
        for (int localHeight = 0; localHeight < height; ++localHeight) {
            int blockID = world.func_72798_a(xPos, yPos + localHeight, zPos);
            Block block = Block.field_71973_m[blockID];
            if (blockID != 0 && block != null && !block.isLeaves(world, xPos, yPos + localHeight, zPos)) continue;
            this.func_76485_a(world, xPos, yPos + localHeight, zPos, NContent.rareTree.field_71990_ca, this.metaWood);
        }
    }
}

