/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.crops;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import mods.natura.Natura;
import mods.natura.client.CropRender;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class CropBlock
extends BlockCrops {
    public Icon[] icons;
    public String[] textureNames = new String[]{"barley_1", "barley_2", "barley_3", "barley_4", "cotton_1", "cotton_2", "cotton_3", "cotton_4", "cotton_5"};

    public CropBlock(int id) {
        super(id);
        this.setTickRandomly(true);
        float var3 = 0.5f;
        this.setBlockBounds(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, 0.25f, 0.5f + var3);
        this.setCreativeTab(null);
        this.setHardness(0.0f);
        this.setStepSound(soundGrassFootstep);
        this.disableStats();
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        float grow;
        int meta;
        this.checkFlowerChange(world, x, y, z);
        int light = world.func_72957_l(x, y, z);
        if (light >= 8 && (meta = world.func_72805_g(x, y, z)) != 3 && meta != 8 && random.nextInt((int)(60.0f / (grow = this.getGrowthRate(world, x, y, z, meta, light))) + 1) == 0) {
            world.func_72921_c(x, y, z, ++meta, 2);
        }
    }

    public void func_72272_c_(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta != 3 && meta != 8) {
            if (meta < 3) {
                int output = Natura.random.nextInt(3) + 1 + meta;
                if (output > 3) {
                    output = 3;
                }
                world.func_72921_c(x, y, z, output, 3);
            } else {
                int output = Natura.random.nextInt(4) + 1 + meta;
                if (output > 8) {
                    output = 8;
                }
                world.func_72921_c(x, y, z, output, 3);
            }
        }
    }

    protected float getGrowthRate(World world, int x, int y, int z, int meta, int light) {
        float growth = 0.25f * (float)(light - 7);
        Block soil = blocksList[world.func_72798_a(x, y - 1, z)];
        if (world.func_72937_j(x, y, z) || !this.requiresSun(meta)) {
            growth += 2.0f;
        }
        if (soil != null && soil.isFertile(world, x, y - 1, z)) {
            growth *= 2.0f;
        }
        return 1.0f + growth;
    }

    boolean requiresSun(int meta) {
        return true;
    }

    protected boolean func_72263_d_(int par1) {
        return par1 == Block.field_72050_aA.field_71990_ca;
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        int meta;
        if (!world.field_72995_K && (meta = world.func_72805_g(x, y, z)) == 8) {
            world.func_72832_d(x, y, z, this.blockID, 6, 3);
            EntityItem entityitem = new EntityItem(world, player.posX, player.posY - 1.0, player.posZ, new ItemStack(NContent.plantItem.field_77779_bT, 1, 3));
            world.func_72838_d((Entity)entityitem);
            entityitem.func_70100_b_(player);
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 8) {
            if (world.field_72995_K) {
                return true;
            }
            world.func_72832_d(x, y, z, this.blockID, 6, 3);
            EntityItem entityitem = new EntityItem(world, player.posX, player.posY - 1.0, player.posZ, new ItemStack(NContent.plantItem.field_77779_bT, 1, 3));
            world.func_72838_d((Entity)entityitem);
            entityitem.func_70100_b_(player);
            return true;
        }
        return false;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) > 3) {
            return 0.5f;
        }
        return this.blockHardness;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("natura:" + this.textureNames[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return this.icons[meta];
    }

    public int func_71857_b() {
        return CropRender.model;
    }

    public int func_71885_a(int meta, Random random, int fortune) {
        if (meta == 3 || meta == 8) {
            return this.getCropItem(meta);
        }
        return this.getSeedItem(meta);
    }

    protected int getCropItem(int meta) {
        return NContent.plantItem.field_77779_bT;
    }

    protected int getSeedItem(int meta) {
        return NContent.seeds.field_77779_bT;
    }

    public int damageDropped(int meta) {
        if (meta < 4) {
            return 0;
        }
        return 3;
    }

    public int seedDamageDropped(int meta) {
        if (meta < 4) {
            return 0;
        }
        return 1;
    }

    public void func_71914_a(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        super.func_71914_a(par1World, par2, par3, par4, par5, par6, 0);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (metadata == 3 || metadata == 8) {
            int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
            for (int i = 0; i < count; ++i) {
                int id = this.func_71885_a(metadata, world.field_73012_v, 0);
                if (id <= 0) continue;
                ret.add(new ItemStack(id, 1, this.damageDropped(metadata)));
            }
        }
        if (metadata >= 4) {
            ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            if (metadata >= 5 && world.field_73012_v.nextBoolean()) {
                ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            }
            if (metadata >= 7 && world.field_73012_v.nextBoolean()) {
                ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            }
        } else {
            ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            if (metadata >= 2 && world.field_73012_v.nextInt(3) == 0) {
                ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            }
            if (metadata >= 3 && world.field_73012_v.nextInt(4) == 0) {
                ret.add(new ItemStack(this.getSeedItem(metadata), 1, this.seedDamageDropped(metadata)));
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71922_a(World world, int x, int y, int z) {
        return this.getSeedItem(world.func_72805_g(x, y, z));
    }

    public int getDamageValue(World par1World, int par2, int par3, int par4) {
        return this.seedDamageDropped(par1World.func_72805_g(par2, par3, par4));
    }

    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 3 || meta == 8) {
            return world.func_72798_a(x, y - 1, z) != 0;
        }
        return super.canBlockStay(world, x, y, z);
    }

    public int getPlantMetadata(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 4) {
            return 0;
        }
        return 4;
    }
}

