/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TreeBlock
extends BlockLog {
    public Icon[] icons;
    public String[] textureNames = new String[]{"eucalyptus_bark", "sakura_bark", "ghostwood_bark", "hopseed_bark", "eucalyptus_heart", "sakura_heart", "ghostwood_heart", "hopseed_heart"};

    public TreeBlock(int id) {
        super(id);
        this.setHardness(1.5f);
        this.setResistance(5.0f);
        this.setStepSound(Block.field_71967_e);
        TreeBlock.setBurnProperties((int)this.blockID, (int)5, (int)20);
        this.setCreativeTab(NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int side, int metadata) {
        int tex = metadata % 4;
        int orientation = metadata / 4;
        switch (orientation) {
            case 0: {
                if (side != 0 && side != 1) break;
                return this.icons[tex + 4];
            }
            case 1: {
                if (side != 4 && side != 5) break;
                return this.icons[tex + 4];
            }
            case 2: {
                if (side != 2 && side != 3) break;
                return this.icons[tex + 4];
            }
        }
        return this.icons[tex];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("natura:" + this.textureNames[i]);
        }
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return this.blockID;
    }

    public int damageDropped(int meta) {
        return meta % 4;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return metadata % 4 != 2 ? blockFlammability[this.blockID] : 0;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        return metadata % 4 != 2 ? blockFireSpreadSpeed[this.blockID] : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 4; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }
}

