/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.client;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import mods.natura.blocks.trees.SaguaroBlock;
import mods.natura.client.NProxyClient;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;

public class SaguaroRenderer
implements ISimpleBlockRenderingHandler {
    public static int model = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == model) {
            NProxyClient.renderStandardInvBlock(renderer, block, metadata);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == model) {
            int meta = world.getBlockMetadata(x, y, z);
            if (meta == 0) {
                return this.renderCactus(renderer, world, x, y, z, (SaguaroBlock)block);
            }
            if (meta == 1 || meta == 2) {
                return this.renderSmall(renderer, world, x, y, z, block);
            }
            return this.renderFruit((SaguaroBlock)block, x, y, z, world, meta);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return model;
    }

    boolean renderCactus(RenderBlocks renderblocks, IBlockAccess iblockaccess, int x, int y, int z, SaguaroBlock cactus) {
        float offset;
        float botX = offset = 0.125f;
        float botY = 0.0f;
        float botZ = offset;
        float topX = 1.0f - offset;
        float topY = 1.0f - offset;
        float topZ = 1.0f - offset;
        int airBelow = iblockaccess.getBlockId(x, y - 1, z);
        int cactusAbove = iblockaccess.getBlockId(x, y + 1, z);
        if (airBelow == 0) {
            botY = offset;
        }
        if (cactusAbove == cactus.blockID) {
            topY = 1.0f;
        }
        renderblocks.setRenderBounds((double)botX, (double)botY, (double)botZ, (double)topX, (double)topY, (double)topZ);
        renderblocks.renderStandardBlock((Block)cactus, x, y, z);
        botY = offset;
        topY = 1.0f - offset;
        if (cactus.canConnectSuguaroTo(iblockaccess, x + 1, y, z) && (airBelow == 0 || iblockaccess.getBlockId(x + 1, y - 1, z) == 0)) {
            botX = 1.0f - offset;
            topX = 1.0f;
            renderblocks.setRenderBounds((double)botX, (double)botY, (double)botZ, (double)topX, (double)topY, (double)topZ);
            renderblocks.renderStandardBlock((Block)cactus, x, y, z);
        }
        if (cactus.canConnectSuguaroTo(iblockaccess, x - 1, y, z) && (airBelow == 0 || iblockaccess.getBlockId(x - 1, y - 1, z) == 0)) {
            botX = 0.0f;
            topX = offset;
            renderblocks.setRenderBounds((double)botX, (double)botY, (double)botZ, (double)topX, (double)topY, (double)topZ);
            renderblocks.renderStandardBlock((Block)cactus, x, y, z);
        }
        botX = offset;
        topX = 1.0f - offset;
        if (cactus.canConnectSuguaroTo(iblockaccess, x, y, z + 1) && (airBelow == 0 || iblockaccess.getBlockId(x, y - 1, z + 1) == 0)) {
            botZ = 1.0f - offset;
            topZ = 1.0f;
            renderblocks.setRenderBounds((double)botX, (double)botY, (double)botZ, (double)topX, (double)topY, (double)topZ);
            renderblocks.renderStandardBlock((Block)cactus, x, y, z);
        }
        if (cactus.canConnectSuguaroTo(iblockaccess, x, y, z - 1) && (airBelow == 0 || iblockaccess.getBlockId(x, y - 1, z - 1) == 0)) {
            botZ = 0.0f;
            topZ = offset;
            renderblocks.setRenderBounds((double)botX, (double)botY, (double)botZ, (double)topX, (double)topY, (double)topZ);
            renderblocks.renderStandardBlock((Block)cactus, x, y, z);
        }
        return true;
    }

    public boolean renderFruit(SaguaroBlock block, int x, int y, int z, IBlockAccess world, int meta) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(block.getMixedBrightnessForBlock(world, x, y, z));
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        int direction = BlockDirectional.getDirection((int)meta);
        int sizer = SaguaroBlock.func_72219_c(meta + 5);
        if (sizer > 4) {
            sizer = 0;
        }
        Icon icon = block.icons[3];
        int offsetX = 4 + sizer * 2;
        int offsetY = 5 + sizer * 2;
        double d0 = 16.0 - (double)offsetX;
        double d1 = 16.0;
        double d2 = 4.0;
        double d3 = 4.0 + (double)offsetY;
        double d4 = icon.getInterpolatedU(d0);
        double d5 = icon.getInterpolatedU(d1);
        double d6 = icon.getInterpolatedV(d2);
        double d7 = icon.getInterpolatedV(d3);
        double d8 = 0.0;
        double d9 = 0.0;
        switch (direction) {
            case 0: {
                d8 = 8.0 - (double)(offsetX / 2);
                d9 = 18.0 - (double)offsetX;
                break;
            }
            case 1: {
                d8 = -2.0;
                d9 = 8.0 - (double)(offsetX / 2);
                break;
            }
            case 2: {
                d8 = 8.0 - (double)(offsetX / 2);
                d9 = -2.0;
                break;
            }
            case 3: {
                d8 = 18.0 - (double)offsetX;
                d9 = 8.0 - (double)(offsetX / 2);
            }
        }
        double d10 = (double)x + d8 / 16.0;
        double d11 = (double)x + (d8 + (double)offsetX) / 16.0;
        double d12 = (double)y + (12.0 - (double)offsetY) / 16.0;
        double d13 = (double)y + 0.75;
        double d14 = (double)z + d9 / 16.0;
        double d15 = (double)z + (d9 + (double)offsetX) / 16.0;
        tessellator.addVertexWithUV(d10, d12, d14, d4, d7);
        tessellator.addVertexWithUV(d10, d12, d15, d5, d7);
        tessellator.addVertexWithUV(d10, d13, d15, d5, d6);
        tessellator.addVertexWithUV(d10, d13, d14, d4, d6);
        tessellator.addVertexWithUV(d11, d12, d15, d4, d7);
        tessellator.addVertexWithUV(d11, d12, d14, d5, d7);
        tessellator.addVertexWithUV(d11, d13, d14, d5, d6);
        tessellator.addVertexWithUV(d11, d13, d15, d4, d6);
        tessellator.addVertexWithUV(d11, d12, d14, d4, d7);
        tessellator.addVertexWithUV(d10, d12, d14, d5, d7);
        tessellator.addVertexWithUV(d10, d13, d14, d5, d6);
        tessellator.addVertexWithUV(d11, d13, d14, d4, d6);
        tessellator.addVertexWithUV(d10, d12, d15, d4, d7);
        tessellator.addVertexWithUV(d11, d12, d15, d5, d7);
        tessellator.addVertexWithUV(d11, d13, d15, d5, d6);
        tessellator.addVertexWithUV(d10, d13, d15, d4, d6);
        int i2 = offsetX;
        if (sizer >= 2) {
            i2 = offsetX - 1;
        }
        d4 = icon.getMinU();
        d5 = icon.getInterpolatedU((double)i2);
        d6 = icon.getMinV();
        d7 = icon.getInterpolatedV((double)i2);
        tessellator.addVertexWithUV(d10, d13, d15, d4, d7);
        tessellator.addVertexWithUV(d11, d13, d15, d5, d7);
        tessellator.addVertexWithUV(d11, d13, d14, d5, d6);
        tessellator.addVertexWithUV(d10, d13, d14, d4, d6);
        tessellator.addVertexWithUV(d10, d12, d14, d4, d6);
        tessellator.addVertexWithUV(d11, d12, d14, d5, d6);
        tessellator.addVertexWithUV(d11, d12, d15, d5, d7);
        tessellator.addVertexWithUV(d10, d12, d15, d4, d7);
        d4 = icon.getInterpolatedU(12.0);
        d5 = icon.getMaxU();
        d6 = icon.getMinV();
        d7 = icon.getInterpolatedV(4.0);
        d8 = 8.0;
        d9 = 0.0;
        switch (direction) {
            case 0: {
                d8 = 8.0;
                d9 = 12.0;
                double d16 = d4;
                d4 = d5;
                d5 = d16;
                break;
            }
            case 1: {
                d8 = 0.0;
                d9 = 8.0;
                break;
            }
            case 2: {
                d8 = 8.0;
                d9 = 0.0;
                break;
            }
            case 3: {
                d8 = 12.0;
                d9 = 8.0;
                double d16 = d4;
                d4 = d5;
                d5 = d16;
            }
        }
        d10 = (double)x + d8 / 16.0;
        d11 = (double)x + (d8 + 4.0) / 16.0;
        d12 = (double)y + 0.75;
        d13 = (double)y + 1.0;
        d14 = (double)z + d9 / 16.0;
        d15 = (double)z + (d9 + 4.0) / 16.0;
        return true;
    }

    boolean renderSmall(RenderBlocks renderer, IBlockAccess iblockaccess, int x, int y, int z, Block block) {
        renderer.setRenderBounds((double)0.325f, 0.0, (double)0.325f, (double)0.675f, 0.5, (double)0.675f);
        renderer.renderStandardBlock(block, x, y, z);
        return true;
    }
}

