/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import ic2.api.item.ICustomElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.util.PiercingEntityDamage;

public class AbilityHelper {
    public static Random random = new Random();
    public static boolean necroticUHS;

    public static boolean onBlockChanged(ItemStack stack, World world, int bID, int x, int y, int z, EntityLivingBase player, Random random) {
        if (!stack.hasTagCompound()) {
            return false;
        }
        int reinforced = 0;
        NBTTagCompound tags = stack.getTagCompound();
        if (tags.getCompoundTag("InfiTool").hasKey("Unbreaking")) {
            reinforced = tags.getCompoundTag("InfiTool").getInteger("Unbreaking");
        }
        if (random.nextInt(10) < 10 - reinforced) {
            AbilityHelper.damageTool(stack, 1, tags, player, false);
        }
        return true;
    }

    public static boolean onLeftClickEntity(ItemStack stack, EntityLivingBase player, Entity entity, ToolCore tool) {
        return AbilityHelper.onLeftClickEntity(stack, player, entity, tool, 0);
    }

    public static boolean onLeftClickEntity(ItemStack stack, EntityLivingBase player, Entity entity, ToolCore tool, int baseDamage) {
        if (entity.canAttackWithItem() && stack.hasTagCompound() && !entity.hitByEntity((Entity)player)) {
            NBTTagCompound tags = stack.getTagCompound();
            NBTTagCompound toolTags = stack.getTagCompound().getCompoundTag("InfiTool");
            int damage = toolTags.getInteger("Attack") + baseDamage;
            boolean broken = toolTags.getBoolean("Broken");
            int durability = tags.getCompoundTag("InfiTool").getInteger("Damage");
            float stonebound = tags.getCompoundTag("InfiTool").getFloat("Shoddy");
            float stoneboundDamage = (float)Math.log((float)durability / 72.0f + 1.0f) * -2.0f * stonebound;
            int earlyModDamage = 0;
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                earlyModDamage = mod.baseAttackDamage(earlyModDamage, damage, tool, tags, toolTags, stack, player, entity);
            }
            damage += earlyModDamage;
            if (player.isPotionActive(Potion.damageBoost)) {
                damage += 3 << player.getActivePotionEffect(Potion.damageBoost).getAmplifier();
            }
            if (player.isPotionActive(Potion.weakness)) {
                damage -= 2 << player.getActivePotionEffect(Potion.weakness).getAmplifier();
            }
            float knockback = 0.0f;
            float enchantDamage = 0.0f;
            if (entity instanceof EntityLivingBase) {
                enchantDamage = EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)entity));
                knockback += (float)EnchantmentHelper.getKnockbackModifier((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)entity));
            }
            if ((damage = (int)((float)damage + stoneboundDamage)) < 1) {
                damage = 1;
            }
            if (player.isSprinting()) {
                knockback += 1.0f;
                float lunge = tool.chargeAttack();
                if (lunge > 1.0f) {
                    knockback += lunge - 1.0f;
                    damage = (int)((float)damage * lunge);
                }
            }
            float modKnockback = 0.0f;
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                modKnockback = mod.knockback(modKnockback, knockback, tool, tags, toolTags, stack, player, entity);
            }
            knockback += modKnockback;
            int modDamage = 0;
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                modDamage = mod.attackDamage(modDamage, damage, tool, tags, toolTags, stack, player, entity);
            }
            if ((damage += modDamage) > 0 || enchantDamage > 0.0f) {
                boolean criticalHit = player.fallDistance > 0.0f && !player.onGround && !player.isOnLadder() && !player.isInWater() && !player.isPotionActive(Potion.blindness) && player.ridingEntity == null && entity instanceof EntityLivingBase;
                for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                    if (!mod.doesCriticalHit(tool, tags, toolTags, stack, player, entity)) continue;
                    criticalHit = true;
                }
                if (criticalHit) {
                    damage += random.nextInt(damage / 2 + 2);
                }
                damage = (int)((float)damage + enchantDamage);
                if (tool.getDamageModifier() != 1.0f) {
                    damage = (int)((float)damage * tool.getDamageModifier());
                }
                boolean var6 = false;
                int fireAspect = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)player);
                if (entity instanceof EntityLivingBase && fireAspect > 0 && !entity.isBurning()) {
                    var6 = true;
                    entity.setFire(1);
                }
                if (broken) {
                    damage = baseDamage > 0 ? baseDamage : 1;
                }
                boolean causedDamage = false;
                causedDamage = tool.pierceArmor() && !broken ? (player instanceof EntityPlayer ? entity.attackEntityFrom(AbilityHelper.causePlayerPiercingDamage((EntityPlayer)player), (float)damage) : entity.attackEntityFrom(AbilityHelper.causePiercingDamage(player), (float)damage)) : (player instanceof EntityPlayer ? entity.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)((EntityPlayer)player)), (float)damage) : entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)player), (float)damage));
                if (causedDamage) {
                    int drain;
                    int reinforced = 0;
                    if (toolTags.hasKey("Unbreaking")) {
                        reinforced = tags.getCompoundTag("InfiTool").getInteger("Unbreaking");
                    }
                    if (random.nextInt(10) < 10 - reinforced) {
                        AbilityHelper.damageTool(stack, 1, tags, player, false);
                    }
                    tool.onEntityDamaged(player.worldObj, player, entity);
                    if ((!necroticUHS || entity instanceof IMob && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).getHealth() <= 0.0f) && (drain = toolTags.getInteger("Necrotic") * 2) > 0) {
                        player.heal((float)random.nextInt(drain + 1));
                    }
                    if (knockback > 0.0f) {
                        entity.addVelocity((double)(-MathHelper.sin((float)(player.rotationYaw * (float)Math.PI / 180.0f)) * knockback * 0.5f), 0.1, (double)(MathHelper.cos((float)(player.rotationYaw * (float)Math.PI / 180.0f)) * knockback * 0.5f));
                        player.motionX *= 0.6;
                        player.motionZ *= 0.6;
                        player.setSprinting(false);
                    }
                    if (player instanceof EntityPlayer) {
                        if (criticalHit) {
                            ((EntityPlayer)player).onCriticalHit(entity);
                        }
                        if (enchantDamage > 0.0f) {
                            ((EntityPlayer)player).onEnchantmentCritical(entity);
                        }
                        if (damage >= 18) {
                            ((EntityPlayer)player).triggerAchievement((StatBase)AchievementList.overkill);
                        }
                    }
                    player.setLastAttacker(entity);
                    if (entity instanceof EntityLivingBase) {
                        EnchantmentThorns.func_92096_a((Entity)player, (EntityLivingBase)((EntityLivingBase)entity), (Random)random);
                    }
                }
                if (entity instanceof EntityLivingBase) {
                    if (entity instanceof EntityPlayer) {
                        stack.hitEntity((EntityLivingBase)entity, (EntityPlayer)player);
                        if (entity.isEntityAlive()) {
                            AbilityHelper.alertPlayerWolves((EntityPlayer)player, (EntityLivingBase)entity, true);
                        }
                        ((EntityPlayer)player).addStat(StatList.damageDealtStat, damage);
                    } else {
                        Item.itemsList[stack.itemID].hitEntity(stack, (EntityLivingBase)entity, player);
                    }
                    if ((fireAspect > 0 || toolTags.hasKey("Fiery") || toolTags.hasKey("Lava")) && causedDamage) {
                        fireAspect *= 4;
                        if (toolTags.hasKey("Fiery")) {
                            fireAspect += toolTags.getInteger("Fiery") / 5 + 1;
                        }
                        if (toolTags.getBoolean("Lava")) {
                            fireAspect += 3;
                        }
                        entity.setFire(fireAspect);
                    } else if (var6) {
                        entity.extinguish();
                    }
                }
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)player).addExhaustion(0.3f);
                }
                if (causedDamage) {
                    return true;
                }
            }
        }
        return false;
    }

    static void alertPlayerWolves(EntityPlayer player, EntityLivingBase living, boolean par2) {
        if (!(living instanceof EntityCreeper) && !(living instanceof EntityGhast)) {
            EntityWolf var3;
            if (living instanceof EntityWolf && (var3 = (EntityWolf)living).isTamed() && player.username.equals(var3.getOwnerName())) {
                return;
            }
            if (!(living instanceof EntityPlayer) || player.canAttackPlayer((EntityPlayer)living)) {
                List var6 = player.worldObj.getEntitiesWithinAABB(EntityWolf.class, AxisAlignedBB.getAABBPool().getAABB(player.posX, player.posY, player.posZ, player.posX + 1.0, player.posY + 1.0, player.posZ + 1.0).expand(16.0, 4.0, 16.0));
                for (EntityWolf var5 : var6) {
                    if (!var5.isTamed() || var5.getEntityToAttack() != null || !player.username.equals(var5.getOwnerName()) || par2 && var5.isSitting()) continue;
                    var5.setSitting(false);
                    var5.setTarget((Entity)living);
                }
            }
        }
    }

    public static void damageTool(ItemStack stack, int dam, EntityLivingBase entity, boolean ignoreCharge) {
        NBTTagCompound tags = stack.getTagCompound();
        AbilityHelper.damageTool(stack, dam, tags, entity, ignoreCharge);
    }

    public static void healTool(ItemStack stack, int dam, EntityLivingBase entity, boolean ignoreCharge) {
        NBTTagCompound tags = stack.getTagCompound();
        AbilityHelper.damageTool(stack, -dam, tags, entity, ignoreCharge);
    }

    public static void damageTool(ItemStack stack, int dam, NBTTagCompound tags, EntityLivingBase entity, boolean ignoreCharge) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).capabilities.isCreativeMode || tags == null) {
            return;
        }
        if (ignoreCharge || !AbilityHelper.damageElectricTool(stack, tags, (Entity)entity)) {
            boolean damagedTool = false;
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                if (!mod.damageTool(stack, dam, entity)) continue;
                damagedTool = true;
            }
            if (damagedTool) {
                return;
            }
            int damage = tags.getCompoundTag("InfiTool").getInteger("Damage");
            int damageTrue = damage + dam;
            int maxDamage = tags.getCompoundTag("InfiTool").getInteger("TotalDurability");
            if (damageTrue <= 0) {
                tags.getCompoundTag("InfiTool").setInteger("Damage", 0);
                stack.setItemDamage(0);
                tags.getCompoundTag("InfiTool").setBoolean("Broken", false);
            } else if (damageTrue > maxDamage) {
                AbilityHelper.breakTool(stack, tags, (Entity)entity);
                stack.setItemDamage(0);
            } else {
                tags.getCompoundTag("InfiTool").setInteger("Damage", damage + dam);
                int toolDamage = damage * 100 / maxDamage + 1;
                int stackDamage = stack.getItemDamage();
                if (toolDamage != stackDamage) {
                    stack.setItemDamage(damage * 100 / maxDamage + 1);
                }
            }
        }
    }

    public static boolean damageElectricTool(ItemStack stack, NBTTagCompound tags, Entity entity) {
        if (!tags.hasKey("charge")) {
            return false;
        }
        NBTTagCompound toolTag = stack.getTagCompound().getCompoundTag("InfiTool");
        int charge = tags.getInteger("charge");
        int durability = toolTag.getInteger("Damage");
        float shoddy = toolTag.getFloat("Shoddy");
        float mineSpeed = toolTag.getInteger("MiningSpeed");
        int heads = 1;
        if (toolTag.hasKey("MiningSpeed2")) {
            mineSpeed += (float)toolTag.getInteger("MiningSpeed2");
            ++heads;
        }
        if (toolTag.hasKey("MiningSpeedHandle")) {
            mineSpeed += (float)toolTag.getInteger("MiningSpeedHandle");
            ++heads;
        }
        if (toolTag.hasKey("MiningSpeedExtra")) {
            mineSpeed += (float)toolTag.getInteger("MiningSpeedExtra");
            ++heads;
        }
        float trueSpeed = mineSpeed / ((float)heads * 100.0f);
        float stonebound = toolTag.getFloat("Shoddy");
        float bonusLog = (float)Math.log((float)durability / 72.0f + 1.0f) * 2.0f * stonebound;
        trueSpeed += bonusLog;
        if ((float)charge < (trueSpeed *= 6.0f)) {
            if (charge > 0) {
                tags.setInteger("charge", 0);
            }
            return false;
        }
        charge = (int)((float)charge - trueSpeed);
        ToolCore tool = (ToolCore)stack.getItem();
        stack.setItemDamage(1 + (tool.getMaxCharge(stack) - charge) * (stack.getMaxDamage() - 1) / tool.getMaxCharge(stack));
        tags.setInteger("charge", charge);
        if (entity instanceof EntityPlayer) {
            AbilityHelper.chargeFromArmor(stack, (EntityPlayer)entity);
        }
        return true;
    }

    static void chargeFromArmor(ItemStack stack, EntityPlayer player) {
        boolean inContainer = false;
        for (int armorIter = 0; armorIter < 4; ++armorIter) {
            ItemStack armor = player.inventory.armorInventory[armorIter];
            if (armor == null || !(armor.getItem() instanceof IElectricItem)) continue;
            IElectricItem electricArmor = (IElectricItem)armor.getItem();
            ToolCore tool = (ToolCore)stack.getItem();
            if (!electricArmor.canProvideEnergy(stack) || electricArmor.getTier(stack) < ((IElectricItem)stack.getItem()).getTier(stack)) continue;
            int chargeAmount = tool.charge(stack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
            if ((chargeAmount = AbilityHelper.discharge(armor, chargeAmount, Integer.MAX_VALUE, true, false)) <= 0) continue;
            tool.charge(stack, chargeAmount, Integer.MAX_VALUE, true, false);
            inContainer = true;
        }
        if (inContainer) {
            player.openContainer.detectAndSendChanges();
        }
    }

    public static int discharge(ItemStack stack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IElectricItem ielectricitem = (IElectricItem)stack.getItem();
        if (ielectricitem instanceof ICustomElectricItem) {
            return ((ICustomElectricItem)ielectricitem).discharge(stack, amount, tier, ignoreTransferLimit, simulate);
        }
        if (amount >= 0 && stack.stackSize <= 1 && ielectricitem.getTier(stack) <= tier) {
            NBTTagCompound tags;
            int charge;
            if (amount > ielectricitem.getTransferLimit(stack) && !ignoreTransferLimit) {
                amount = ielectricitem.getTransferLimit(stack);
            }
            if (amount > (charge = (tags = stack.getTagCompound()).getInteger("charge"))) {
                amount = charge;
            }
            charge -= amount;
            if (!simulate) {
                tags.setInteger("charge", charge);
                int n = stack.itemID = charge > 0 ? ielectricitem.getChargedItemId(stack) : ielectricitem.getEmptyItemId(stack);
                if (stack.getItem() instanceof IElectricItem) {
                    ielectricitem = (IElectricItem)stack.getItem();
                    if (stack.getMaxDamage() > 2) {
                        if (stack.getItemDamage() + 1 < stack.getMaxDamage()) {
                            stack.setItemDamage(1 + (ielectricitem.getMaxCharge(stack) - charge) * (stack.getMaxDamage() - 2) / ielectricitem.getMaxCharge(stack));
                        }
                    } else {
                        stack.setItemDamage(0);
                    }
                } else {
                    stack.setItemDamage(0);
                }
            }
            return amount;
        }
        return 0;
    }

    public static void breakTool(ItemStack stack, NBTTagCompound tags, Entity entity) {
        tags.getCompoundTag("InfiTool").setBoolean("Broken", true);
        if (entity != null) {
            entity.worldObj.playSound(entity.posX, entity.posY, entity.posZ, "random.break", 1.0f, 1.0f, true);
        }
    }

    public static void repairTool(ItemStack stack, NBTTagCompound tags) {
        tags.getCompoundTag("InfiTool").setBoolean("Broken", false);
        tags.getCompoundTag("InfiTool").setInteger("Damage", 0);
    }

    public static DamageSource causePiercingDamage(EntityLivingBase mob) {
        return new PiercingEntityDamage("mob", (Entity)mob);
    }

    public static DamageSource causePlayerPiercingDamage(EntityPlayer player) {
        return new PiercingEntityDamage("player", (Entity)player);
    }

    public static void knockbackEntity(EntityLivingBase living, double boost) {
        living.motionX *= boost;
        living.motionZ *= boost;
    }

    public static boolean hoeGround(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, Random random) {
        if (!player.canPlayerEdit(x, y, z, side, stack)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            AbilityHelper.onBlockChanged(stack, world, 0, x, y, z, (EntityLivingBase)player, random);
            return true;
        }
        int bID = world.getBlockId(x, y, z);
        int bIDabove = world.getBlockId(x, y + 1, z);
        if ((side == 0 || bIDabove != 0 || bID != Block.grass.blockID) && bID != Block.dirt.blockID) {
            return false;
        }
        Block block = Block.tilledField;
        world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.stepSound.getStepSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
        if (world.isRemote) {
            return true;
        }
        world.setBlock(x, y, z, block.blockID);
        AbilityHelper.onBlockChanged(stack, world, 0, x, y, z, (EntityLivingBase)player, random);
        return true;
    }

    public static void spawnItemAtPlayer(EntityPlayer player, ItemStack stack) {
        EntityItem entityitem = new EntityItem(player.worldObj, player.posX + 0.5, player.posY + 0.5, player.posZ + 0.5, stack);
        player.worldObj.spawnEntityInWorld((Entity)entityitem);
        if (!(player instanceof FakePlayer)) {
            entityitem.onCollideWithPlayer(player);
        }
    }

    public static void forceAddToInv(EntityPlayer entityplayer, ItemStack itemstack, int i, boolean flag) {
        ItemStack itemstack1 = entityplayer.inventory.getStackInSlot(i);
        entityplayer.inventory.setInventorySlotContents(i, itemstack);
        if (itemstack1 != null) {
            AbilityHelper.addToInv(entityplayer, itemstack1, flag);
        }
    }

    public static boolean addToInv(EntityPlayer entityplayer, ItemStack itemstack, boolean flag) {
        return AbilityHelper.addToInv(entityplayer, itemstack, entityplayer.inventory.currentItem, flag);
    }

    public static boolean addToInv(EntityPlayer entityplayer, ItemStack itemstack, int i, boolean flag) {
        boolean flag1;
        ItemStack itemstack1 = entityplayer.inventory.getStackInSlot(i);
        if (itemstack1 == null) {
            entityplayer.inventory.setInventorySlotContents(i, itemstack);
            flag1 = true;
        } else {
            flag1 = entityplayer.inventory.addItemStackToInventory(itemstack);
        }
        if (flag && !flag1) {
            AbilityHelper.addItemStackToWorld(entityplayer.worldObj, (float)Math.floor(entityplayer.posX), (float)Math.floor(entityplayer.posY), (float)Math.floor(entityplayer.posZ), itemstack);
            return true;
        }
        return flag1;
    }

    public static EntityItem addItemStackToWorld(World world, float f, float f1, float f2, ItemStack itemstack) {
        return AbilityHelper.addItemStackToWorld(world, f, f1, f2, itemstack, false);
    }

    public static EntityItem addItemStackToWorld(World world, float f, float f1, float f2, ItemStack itemstack, boolean flag) {
        EntityItem entityitem;
        if (flag) {
            entityitem = new EntityItem(world, (double)f, (double)f1, (double)f2, itemstack);
        } else {
            float f3 = 0.7f;
            float f4 = random.nextFloat() * f3 + (1.0f - f3) * 0.5f;
            float f5 = 1.2f;
            float f6 = random.nextFloat() * f3 + (1.0f - f3) * 0.5f;
            entityitem = new EntityItem(world, (double)(f + f4), (double)(f1 + f5), (double)(f2 + f6), itemstack);
        }
        entityitem.delayBeforeCanPickup = 10;
        world.spawnEntityInWorld((Entity)entityitem);
        return entityitem;
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.prevRotationPitch + (player.rotationPitch - player.prevRotationPitch) * f;
        float f2 = player.prevRotationYaw + (player.rotationYaw - player.prevRotationYaw) * f;
        double d0 = player.prevPosX + (player.posX - player.prevPosX) * (double)f;
        double d1 = player.prevPosY + (player.posY - player.prevPosY) * (double)f + 1.62 - (double)player.yOffset;
        double d2 = player.prevPosZ + (player.posZ - player.prevPosZ) * (double)f;
        Vec3 vec3 = world.getWorldVec3Pool().getVecFromPool(d0, d1, d2);
        float f3 = MathHelper.cos((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.sin((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.cos((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.sin((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).theItemInWorldManager.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.addVector((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.rayTraceBlocks_do_do(vec3, vec31, par3, !par3);
    }
}

