/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.crafting.AlloyMix;

public class Smeltery {
    public static Smeltery instance = new Smeltery();
    private HashMap<List<Integer>, FluidStack> smeltingList = new HashMap();
    private HashMap<List<Integer>, Integer> temperatureList = new HashMap();
    private HashMap<List<Integer>, ItemStack> renderIndex = new HashMap();
    private ArrayList<AlloyMix> alloys = new ArrayList();

    public static void addMelting(ItemStack stack, int temperature, FluidStack output) {
        Smeltery.addMelting(stack, stack.itemID, stack.getItemDamage(), temperature, output);
    }

    public static void addMelting(Block block, int metadata, int temperature, FluidStack output) {
        Smeltery.addMelting(new ItemStack(block, 1, metadata), block.blockID, metadata, temperature, output);
    }

    public static void addMelting(ItemStack input, int blockID, int metadata, int temperature, FluidStack liquid) {
        Smeltery.instance.smeltingList.put(Arrays.asList(input.itemID, input.getItemDamage()), liquid);
        Smeltery.instance.temperatureList.put(Arrays.asList(input.itemID, input.getItemDamage()), temperature);
        Smeltery.instance.renderIndex.put(Arrays.asList(input.itemID, input.getItemDamage()), new ItemStack(blockID, input.stackSize, metadata));
    }

    public static void addAlloyMixing(FluidStack result, FluidStack ... mixers) {
        ArrayList<FluidStack> inputs = new ArrayList<FluidStack>();
        for (FluidStack liquid : mixers) {
            inputs.add(liquid);
        }
        Smeltery.instance.alloys.add(new AlloyMix(result, inputs));
    }

    public static Integer getLiquifyTemperature(ItemStack item) {
        if (item == null) {
            return 20;
        }
        Integer temp = Smeltery.instance.temperatureList.get(Arrays.asList(item.itemID, item.getItemDamage()));
        if (temp == null) {
            return 20;
        }
        return temp;
    }

    public static Integer getLiquifyTemperature(int blockID, int metadata) {
        return Smeltery.instance.temperatureList.get(Arrays.asList(blockID, metadata));
    }

    public static FluidStack getSmelteryResult(ItemStack item) {
        if (item == null) {
            return null;
        }
        FluidStack stack = Smeltery.instance.smeltingList.get(Arrays.asList(item.itemID, item.getItemDamage()));
        if (stack == null) {
            return null;
        }
        return stack.copy();
    }

    public static FluidStack getSmelteryResult(int blockID, int metadata) {
        FluidStack stack = Smeltery.instance.smeltingList.get(Arrays.asList(blockID, metadata));
        if (stack == null) {
            return null;
        }
        return stack.copy();
    }

    public static ItemStack getRenderIndex(ItemStack input) {
        return Smeltery.instance.renderIndex.get(Arrays.asList(input.itemID, input.getItemDamage()));
    }

    public static ArrayList mixMetals(ArrayList<FluidStack> moltenMetal) {
        ArrayList<FluidStack> liquids = new ArrayList<FluidStack>();
        for (AlloyMix alloy : Smeltery.instance.alloys) {
            FluidStack liquid = alloy.mix(moltenMetal);
            if (liquid == null) continue;
            liquids.add(liquid);
        }
        return liquids;
    }

    public static HashMap<List<Integer>, FluidStack> getSmeltingList() {
        return Smeltery.instance.smeltingList;
    }

    public static HashMap<List<Integer>, Integer> getTemperatureList() {
        return Smeltery.instance.temperatureList;
    }

    public static HashMap<List<Integer>, ItemStack> getRenderIndex() {
        return Smeltery.instance.renderIndex;
    }

    public static ArrayList<AlloyMix> getAlloyList() {
        return Smeltery.instance.alloys;
    }
}

