/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import mods.natura.worldgen.BerryBushGen;
import mods.natura.worldgen.FlowerGen;
import mods.natura.worldgen.NetherBerryBushGen;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class BaseCropWorldgen
implements IWorldGenerator {
    BerryBushGen raspgen = new BerryBushGen(0, PHNatura.seaLevel + PHNatura.raspSpawnRange);
    BerryBushGen bluegen = new BerryBushGen(1, PHNatura.seaLevel + PHNatura.blueSpawnRange);
    BerryBushGen blackgen = new BerryBushGen(2, PHNatura.seaLevel + PHNatura.blackSpawnRange);
    BerryBushGen malogen = new BerryBushGen(3, PHNatura.seaLevel + PHNatura.geoSpawnRange);
    NetherBerryBushGen blightgen = new NetherBerryBushGen((Block)NContent.netherBerryBush, 0);
    NetherBerryBushGen duskgen = new NetherBerryBushGen((Block)NContent.netherBerryBush, 1);
    NetherBerryBushGen skygen = new NetherBerryBushGen((Block)NContent.netherBerryBush, 2);
    NetherBerryBushGen stinggen = new NetherBerryBushGen((Block)NContent.netherBerryBush, 3);
    FlowerGen bluebells;
    FlowerGen lily;
    FlowerGen tulip;
    FlowerGen pansy;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int xChunk = chunkX * 16 + 8;
        int zChunk = chunkZ * 16 + 8;
        int xCh = chunkX * 16 + random.nextInt(16);
        int yCh = random.nextInt(128);
        int zCh = chunkZ * 16 + random.nextInt(16);
        BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(chunkX * 16, chunkZ * 16);
        if (PHNatura.generateBarley && random.nextInt(5) == 0 && this.goodClimate(biome, 0.11f, 1.0f, 0.11f, 2.0f)) {
            this.generateBarley(world, random, xCh, yCh + PHNatura.seaLevel, zCh);
            this.generateBarley(world, random, xCh, yCh + PHNatura.seaLevel, zCh);
        }
        if (PHNatura.generateCotton && random.nextInt(12) == 0 && this.goodClimate(biome, 0.11f, 1.0f, 0.11f, 2.0f)) {
            this.generateCotton(world, random, xCh, yCh + PHNatura.seaLevel, zCh);
            this.generateCotton(world, random, xCh, yCh + PHNatura.seaLevel, zCh);
        }
        if (PHNatura.generateBluebells && random.nextInt(12) == 0) {
            this.generateBluebells(world, random, xCh, yCh + PHNatura.seaLevel, zCh);
        }
        if (PHNatura.generateRaspberries && random.nextInt(PHNatura.raspSpawnRarity) == 0 && this.goodClimate(biome, 0.6f, 2.0f, 0.2f, 0.93f)) {
            xCh = xChunk + random.nextInt(16);
            yCh = random.nextInt(PHNatura.raspSpawnRange) + PHNatura.seaLevel;
            zCh = zChunk + random.nextInt(16);
            this.raspgen.generate(world, random, xCh, yCh, zCh);
        }
        if (PHNatura.generateBlueberries && random.nextInt(PHNatura.blueSpawnRarity) == 0 && this.goodClimate(biome, 0.3f, 0.81f, 0.3f, 0.8f)) {
            xCh = xChunk + random.nextInt(16);
            yCh = random.nextInt(PHNatura.blueSpawnRange) + PHNatura.seaLevel;
            zCh = zChunk + random.nextInt(16);
            this.bluegen.generate(world, random, xCh, yCh, zCh);
        }
        if (PHNatura.generateBlackberries && random.nextInt(PHNatura.blackSpawnRarity) == 0 && this.goodClimate(biome, 0.5f, 5.0f, 0.6f, 3.0f)) {
            xCh = xChunk + random.nextInt(16);
            yCh = random.nextInt(PHNatura.blackSpawnRange) + PHNatura.seaLevel;
            zCh = zChunk + random.nextInt(16);
            this.blackgen.generate(world, random, xCh, yCh, zCh);
        }
        if (PHNatura.generateBlackberries && random.nextInt(PHNatura.blackSpawnRarity / 3) == 0 && biome == BiomeGenBase.swampland) {
            xCh = xChunk + random.nextInt(16);
            yCh = random.nextInt(PHNatura.blackSpawnRange) + PHNatura.seaLevel;
            zCh = zChunk + random.nextInt(16);
            this.blackgen.generate(world, random, xCh, yCh, zCh);
        }
        if (PHNatura.generateMaloberries && random.nextInt(PHNatura.geoSpawnRarity) == 0 && this.goodClimate(biome, 0.0f, 0.3f, 0.0f, 5.0f)) {
            xCh = xChunk + random.nextInt(16);
            yCh = random.nextInt(PHNatura.geoSpawnRange) + PHNatura.seaLevel;
            zCh = zChunk + random.nextInt(16);
            this.malogen.generate(world, random, xCh, yCh, zCh);
        }
        if (world.provider.isHellWorld) {
            if (PHNatura.generateBlightberries && random.nextInt(PHNatura.blightSpawnRarity) == 0) {
                xCh = xChunk + random.nextInt(16);
                yCh = random.nextInt(PHNatura.blightSpawnRange) + 16;
                zCh = zChunk + random.nextInt(16);
                this.blightgen.generate(world, random, xCh, yCh, zCh);
            }
            if (PHNatura.generateDuskberries && random.nextInt(PHNatura.duskSpawnRarity) == 0) {
                xCh = xChunk + random.nextInt(16);
                yCh = random.nextInt(PHNatura.duskSpawnRange) + 16;
                zCh = zChunk + random.nextInt(16);
                this.duskgen.generate(world, random, xCh, yCh, zCh);
            }
            if (PHNatura.generateSkyberries && random.nextInt(PHNatura.skySpawnRarity) == 0) {
                xCh = xChunk + random.nextInt(16);
                yCh = random.nextInt(PHNatura.skySpawnRange) + 16;
                zCh = zChunk + random.nextInt(16);
                this.skygen.generate(world, random, xCh, yCh, zCh);
            }
            if (PHNatura.generateStingberries && random.nextInt(PHNatura.stingSpawnRarity) == 0) {
                xCh = xChunk + random.nextInt(16);
                yCh = random.nextInt(PHNatura.stingSpawnRange) + 16;
                zCh = zChunk + random.nextInt(16);
                this.stinggen.generate(world, random, xCh, yCh, zCh);
            }
        }
    }

    public boolean generateBarley(World world, Random random, int x, int y, int z) {
        for (int tries = 0; tries < 64; ++tries) {
            int k1;
            int j1;
            int i1 = x + random.nextInt(8) - random.nextInt(8);
            if (!world.isAirBlock(i1, j1 = y + random.nextInt(4) - random.nextInt(4), k1 = z + random.nextInt(8) - random.nextInt(8)) || !((BlockFlower)Block.blocksList[Block.plantYellow.blockID]).canBlockStay(world, i1, j1, k1)) continue;
            world.setBlock(i1, j1, k1, NContent.crops.blockID, 3, 2);
        }
        return true;
    }

    public boolean generateCotton(World world, Random random, int x, int y, int z) {
        for (int tries = 0; tries < 64; ++tries) {
            int k1;
            int j1;
            int i1 = x + random.nextInt(8) - random.nextInt(8);
            if (!world.isAirBlock(i1, j1 = y + random.nextInt(4) - random.nextInt(4), k1 = z + random.nextInt(8) - random.nextInt(8)) || !((BlockFlower)Block.blocksList[Block.plantYellow.blockID]).canBlockStay(world, i1, j1, k1)) continue;
            world.setBlock(i1, j1, k1, NContent.crops.blockID, 8, 2);
        }
        return true;
    }

    public boolean generateBluebells(World world, Random random, int x, int y, int z) {
        for (int tries = 0; tries < 40; ++tries) {
            int k1;
            int j1;
            int i1 = x + random.nextInt(8) - random.nextInt(8);
            if (!world.isAirBlock(i1, j1 = y + random.nextInt(8) - random.nextInt(8), k1 = z + random.nextInt(8) - random.nextInt(8)) || !((BlockFlower)Block.blocksList[Block.plantYellow.blockID]).canBlockStay(world, i1, j1, k1)) continue;
            world.setBlock(i1, j1, k1, NContent.bluebells.blockID, 0, 2);
        }
        return true;
    }

    public boolean goodClimate(BiomeGenBase biome, float minTemp, float maxTemp, float minRain, float maxRain) {
        float temp = biome.temperature;
        float rain = biome.rainfall;
        return minTemp <= temp && temp <= maxTemp && minRain <= rain && rain <= maxRain;
    }
}

