/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NLeaves
extends BlockLeaves {
    int[] adjacentTreeBlocks;
    public Icon[] fastIcons;
    public Icon[] fancyIcons;

    public NLeaves(int id) {
        super(id);
        this.setTickRandomly(true);
        this.setHardness(0.2f);
        this.setLightOpacity(1);
        this.setStepSound(Block.soundGrassFootstep);
        this.setUnlocalizedName("floraLeaves");
        this.setCreativeTab(CreativeTabs.tabDecorations);
        NLeaves.setBurnProperties((int)this.blockID, (int)30, (int)60);
        this.setCreativeTab(NaturaTab.tab);
    }

    public int getBlockColor() {
        double var1 = 0.5;
        double var3 = 1.0;
        return ColorizerFoliage.getFoliageColor((double)var1, (double)var3);
    }

    public int getRenderColor(int var1) {
        return ColorizerFoliage.getFoliageColorBasic();
    }

    public int colorMultiplier(IBlockAccess var1, int x, int y, int z) {
        int var6 = 0;
        int var7 = 0;
        int var8 = 0;
        for (int var9 = -1; var9 <= 1; ++var9) {
            for (int var10 = -1; var10 <= 1; ++var10) {
                int var11 = var1.getBiomeGenForCoords(x + var10, z + var9).getBiomeFoliageColor();
                var6 += (var11 & 0xFF0000) >> 16;
                var7 += (var11 & 0xFF00) >> 8;
                var8 += var11 & 0xFF;
            }
        }
        return (var6 / 9 & 0xFF) << 16 | (var7 / 9 & 0xFF) << 8 | var8 / 9 & 0xFF;
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        int meta;
        if (!world.isRemote && ((meta = world.getBlockMetadata(x, y, z)) & 4) == 0) {
            boolean nearbyTree = false;
            int range = 4;
            for (int posX = x - range; posX <= x + range; ++posX) {
                for (int posY = y - range; posY <= y + range; ++posY) {
                    for (int posZ = z - range; posZ <= z + range; ++posZ) {
                        Block block = Block.blocksList[world.getBlockId(posX, posY, posZ)];
                        if (block == null || !block.canSustainLeaves(world, posX, posY, posZ)) continue;
                        nearbyTree = true;
                    }
                }
            }
            if (!nearbyTree) {
                this.removeLeaves(world, x, y, z);
            }
        }
    }

    public void removeLeaves(World world, int x, int y, int z) {
        this.dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
        world.setBlock(x, y, z, 0, 0, 7);
    }

    public int quantityDropped(Random var1) {
        return var1.nextInt(20) == 0 ? 1 : 0;
    }

    public int idDropped(int var1, Random var2, int var3) {
        return NContent.floraSapling.blockID;
    }

    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int par5, float par6, int par7) {
        if (!par1World.isRemote) {
            ArrayList items = this.getBlockDropped(par1World, par2, par3, par4, par5, par7);
            for (ItemStack item : items) {
                if (!(par1World.rand.nextFloat() <= par6)) continue;
                this.dropBlockAsItem_do(par1World, par2, par3, par4, item);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int side, int metadata) {
        int meta = metadata % 4;
        if (metadata == 3) {
            meta = 0;
        }
        if (this.graphicsLevel) {
            return this.fancyIcons[meta];
        }
        return this.fastIcons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        String[] textureNames = new String[]{"redwood", "eucalyptus", "hopseed"};
        this.fastIcons = new Icon[textureNames.length];
        this.fancyIcons = new Icon[textureNames.length];
        for (int i = 0; i < this.fastIcons.length; ++i) {
            this.fastIcons[i] = iconRegister.registerIcon("natura:" + textureNames[i] + "_leaves_fast");
            this.fancyIcons[i] = iconRegister.registerIcon("natura:" + textureNames[i] + "_leaves_fancy");
        }
    }

    public boolean shouldSideBeRendered(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        return this.graphicsLevel ? super.shouldSideBeRendered(var1, var2, var3, var4, var5) : true;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
    }

    public int getDamageValue(World par1World, int par2, int par3, int par4) {
        return this.damageDropped(par1World.getBlockMetadata(par2, par3, par4)) % 3;
    }
}

