/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.crops;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.natura.common.NContent;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LargeGlowshroom
extends Block {
    private final String mushroomType;
    @SideOnly(value=Side.CLIENT)
    private Icon iconSkin;
    @SideOnly(value=Side.CLIENT)
    private Icon iconStem;
    @SideOnly(value=Side.CLIENT)
    private Icon iconInside;

    public LargeGlowshroom(int par1, Material par2Material, String type) {
        super(par1, par2Material);
        this.mushroomType = type;
        this.setStepSound(Block.soundWoodFootstep);
        this.setHardness(0.2f);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int side, int meta) {
        return meta == 10 && side > 1 ? this.iconStem : (meta >= 1 && meta <= 9 && side == 1 ? this.iconSkin : (meta >= 1 && meta <= 3 && side == 2 ? this.iconSkin : (meta >= 7 && meta <= 9 && side == 3 ? this.iconSkin : ((meta == 1 || meta == 4 || meta == 7) && side == 4 ? this.iconSkin : ((meta == 3 || meta == 6 || meta == 9) && side == 5 ? this.iconSkin : (meta == 14 ? this.iconSkin : (meta == 15 ? this.iconStem : this.iconInside)))))));
    }

    public int quantityDropped(Random par1Random) {
        int i = par1Random.nextInt(10) - 7;
        if (i < 0) {
            i = 0;
        }
        return i;
    }

    public int damageDropped(int meta) {
        if (this.blockID == NContent.glowshroomBlue.blockID) {
            return 2;
        }
        if (this.blockID == NContent.glowshroomPurple.blockID) {
            return 1;
        }
        if (this.blockID == NContent.glowshroomGreen.blockID) {
            return 0;
        }
        return 0;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        int blockID = iblockaccess.getBlockId(x, y, z);
        if (blockID == NContent.glowshroomBlue.blockID || blockID == NContent.glowshroomPurple.blockID) {
            return false;
        }
        return super.shouldSideBeRendered(iblockaccess, x, y, z, side);
    }

    public int idDropped(int par1, Random par2Random, int par3) {
        return NContent.glowshroom.blockID;
    }

    @SideOnly(value=Side.CLIENT)
    public int idPicked(World par1World, int par2, int par3, int par4) {
        return NContent.glowshroom.blockID;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconregister) {
        this.iconSkin = iconregister.registerIcon("natura:mushroom_skin_" + this.mushroomType);
        this.iconInside = iconregister.registerIcon("natura:mushroom_inside_" + this.mushroomType);
        this.iconStem = iconregister.registerIcon("natura:mushroom_stem_" + this.mushroomType);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        if (Block.blocksList[world.getBlockId(x, y + 1, z)] instanceof LargeGlowshroom) {
            return null;
        }
        return AxisAlignedBB.getBoundingBox((double)x, (double)((double)y + 0.9375), (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0));
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (entity.motionY < 0.0) {
            entity.motionY *= 0.25;
        }
        entity.fallDistance -= 0.25f;
        if (entity.motionY == 0.0) {
            entity.motionX *= 0.25;
            entity.motionZ *= 0.25;
        }
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            living.addPotionEffect(new PotionEffect(Potion.confusion.id, 100, 0));
        }
    }
}

