/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.INpc;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.logging.ILogAgent;
import net.minecraft.network.packet.Packet38EntityStatus;
import net.minecraft.network.packet.Packet54PlayNoteBlock;
import net.minecraft.network.packet.Packet60Explosion;
import net.minecraft.network.packet.Packet70GameEvent;
import net.minecraft.network.packet.Packet71Weather;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.ScoreboardSaveData;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.ReportedException;
import net.minecraft.util.Vec3;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.ServerBlockEventList;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.SpawnListEntry;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.feature.WorldGeneratorBonusChest;
import net.minecraft.world.storage.ISaveHandler;

public class WorldServer
extends World {
    private final MinecraftServer field_73061_a;
    private final EntityTracker field_73062_L;
    private final PlayerManager field_73063_M;
    private Set field_73064_N;
    private TreeSet field_73065_O;
    public ChunkProviderServer field_73059_b;
    public boolean field_73058_d;
    public boolean field_73068_P;
    private int field_80004_Q;
    private final Teleporter field_85177_Q;
    private final SpawnerAnimals field_135059_Q = new SpawnerAnimals();
    private ServerBlockEventList[] field_73067_Q = new ServerBlockEventList[]{new ServerBlockEventList(null), new ServerBlockEventList(null)};
    private int field_73070_R;
    public static final WeightedRandomChestContent[] field_73069_S = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Item.field_77669_D.field_77779_bT, 0, 1, 3, 10), new WeightedRandomChestContent(Block.field_71988_x.field_71990_ca, 0, 1, 3, 10), new WeightedRandomChestContent(Block.field_71951_J.field_71990_ca, 0, 1, 3, 10), new WeightedRandomChestContent(Item.field_77719_y.field_77779_bT, 0, 1, 1, 3), new WeightedRandomChestContent(Item.field_77712_u.field_77779_bT, 0, 1, 1, 5), new WeightedRandomChestContent(Item.field_77720_x.field_77779_bT, 0, 1, 1, 3), new WeightedRandomChestContent(Item.field_77713_t.field_77779_bT, 0, 1, 1, 5), new WeightedRandomChestContent(Item.field_77706_j.field_77779_bT, 0, 2, 3, 5), new WeightedRandomChestContent(Item.field_77684_U.field_77779_bT, 0, 2, 3, 3)};
    private List field_94579_S = new ArrayList();
    private IntHashMap field_73066_T;

    public WorldServer(MinecraftServer p_i1522_1_, ISaveHandler p_i1522_2_, String p_i1522_3_, int p_i1522_4_, WorldSettings p_i1522_5_, Profiler p_i1522_6_, ILogAgent p_i1522_7_) {
        super(p_i1522_2_, p_i1522_3_, p_i1522_5_, WorldProvider.func_76570_a(p_i1522_4_), p_i1522_6_, p_i1522_7_);
        this.field_73061_a = p_i1522_1_;
        this.field_73062_L = new EntityTracker(this);
        this.field_73063_M = new PlayerManager(this, p_i1522_1_.func_71203_ab().func_72395_o());
        if (this.field_73066_T == null) {
            this.field_73066_T = new IntHashMap();
        }
        if (this.field_73064_N == null) {
            this.field_73064_N = new HashSet();
        }
        if (this.field_73065_O == null) {
            this.field_73065_O = new TreeSet();
        }
        this.field_85177_Q = new Teleporter(this);
        this.field_96442_D = new ServerScoreboard(p_i1522_1_);
        ScoreboardSaveData scoreboardSaveData = (ScoreboardSaveData)this.field_72988_C.func_75742_a(ScoreboardSaveData.class, "scoreboard");
        if (scoreboardSaveData == null) {
            scoreboardSaveData = new ScoreboardSaveData();
            this.field_72988_C.func_75745_a("scoreboard", scoreboardSaveData);
        }
        scoreboardSaveData.func_96499_a(this.field_96442_D);
        ((ServerScoreboard)this.field_96442_D).func_96547_a(scoreboardSaveData);
    }

    @Override
    public void func_72835_b() {
        super.func_72835_b();
        if (this.func_72912_H().func_76093_s() && this.field_73013_u < 3) {
            this.field_73013_u = 3;
        }
        this.field_73011_w.field_76578_c.func_76938_b();
        if (this.func_73056_e()) {
            if (this.func_82736_K().func_82766_b("doDaylightCycle")) {
                long l = this.field_72986_A.func_76073_f() + 24000L;
                this.field_72986_A.func_76068_b(l - l % 24000L);
            }
            this.func_73053_d();
        }
        this.field_72984_F.func_76320_a("mobSpawner");
        if (this.func_82736_K().func_82766_b("doMobSpawning")) {
            this.field_135059_Q.func_77192_a(this, this.field_72985_G, this.field_72992_H, this.field_72986_A.func_82573_f() % 400L == 0L);
        }
        this.field_72984_F.func_76318_c("chunkSource");
        this.field_73020_y.func_73156_b();
        int n = this.func_72967_a(1.0f);
        if (n != this.field_73008_k) {
            this.field_73008_k = n;
        }
        this.field_72986_A.func_82572_b(this.field_72986_A.func_82573_f() + 1L);
        if (this.func_82736_K().func_82766_b("doDaylightCycle")) {
            this.field_72986_A.func_76068_b(this.field_72986_A.func_76073_f() + 1L);
        }
        this.field_72984_F.func_76318_c("tickPending");
        this.func_72955_a(false);
        this.field_72984_F.func_76318_c("tickTiles");
        this.func_72893_g();
        this.field_72984_F.func_76318_c("chunkMap");
        this.field_73063_M.func_72693_b();
        this.field_72984_F.func_76318_c("village");
        this.field_72982_D.func_75544_a();
        this.field_72983_E.func_75528_a();
        this.field_72984_F.func_76318_c("portalForcer");
        this.field_85177_Q.func_85189_a(this.func_82737_E());
        this.field_72984_F.func_76319_b();
        this.func_73055_Q();
    }

    public SpawnListEntry func_73057_a(EnumCreatureType p_73057_1_, int p_73057_2_, int p_73057_3_, int p_73057_4_) {
        List list = this.func_72863_F().func_73155_a(p_73057_1_, p_73057_2_, p_73057_3_, p_73057_4_);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (SpawnListEntry)WeightedRandom.func_76271_a(this.field_73012_v, list);
    }

    @Override
    public void func_72854_c() {
        this.field_73068_P = !this.field_73010_i.isEmpty();
        for (EntityPlayer entityPlayer : this.field_73010_i) {
            if (entityPlayer.func_70608_bn()) continue;
            this.field_73068_P = false;
            break;
        }
    }

    protected void func_73053_d() {
        this.field_73068_P = false;
        for (EntityPlayer entityPlayer : this.field_73010_i) {
            if (!entityPlayer.func_70608_bn()) continue;
            entityPlayer.func_70999_a(false, false, true);
        }
        this.func_73051_P();
    }

    private void func_73051_P() {
        this.field_72986_A.func_76080_g(0);
        this.field_72986_A.func_76084_b(false);
        this.field_72986_A.func_76090_f(0);
        this.field_72986_A.func_76069_a(false);
    }

    public boolean func_73056_e() {
        if (this.field_73068_P && !this.field_72995_K) {
            for (EntityPlayer entityPlayer : this.field_73010_i) {
                if (entityPlayer.func_71026_bH()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_72974_f() {
        if (this.field_72986_A.func_76075_d() <= 0) {
            this.field_72986_A.func_76056_b(64);
        }
        int n = this.field_72986_A.func_76079_c();
        int n2 = this.field_72986_A.func_76074_e();
        int n3 = 0;
        while (this.func_72922_b(n, n2) == 0) {
            n += this.field_73012_v.nextInt(8) - this.field_73012_v.nextInt(8);
            n2 += this.field_73012_v.nextInt(8) - this.field_73012_v.nextInt(8);
            if (++n3 != 10000) continue;
        }
        this.field_72986_A.func_76058_a(n);
        this.field_72986_A.func_76087_c(n2);
    }

    @Override
    protected void func_72893_g() {
        super.func_72893_g();
        int n = 0;
        int n2 = 0;
        for (ChunkCoordIntPair chunkCoordIntPair : this.field_72993_I) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = chunkCoordIntPair.field_77276_a * 16;
            int n9 = chunkCoordIntPair.field_77275_b * 16;
            this.field_72984_F.func_76320_a("getChunk");
            Chunk chunk = this.func_72964_e(chunkCoordIntPair.field_77276_a, chunkCoordIntPair.field_77275_b);
            this.func_72941_a(n8, n9, chunk);
            this.field_72984_F.func_76318_c("tickChunk");
            chunk.func_76586_k();
            this.field_72984_F.func_76318_c("thunder");
            if (this.field_73012_v.nextInt(100000) == 0 && this.func_72896_J() && this.func_72911_I()) {
                this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                n7 = this.field_73005_l >> 2;
                n6 = n8 + (n7 & 0xF);
                n5 = n9 + (n7 >> 8 & 0xF);
                n4 = this.func_72874_g(n6, n5);
                if (this.func_72951_B(n6, n4, n5)) {
                    this.func_72942_c(new EntityLightningBolt(this, n6, n4, n5));
                }
            }
            this.field_72984_F.func_76318_c("iceandsnow");
            if (this.field_73012_v.nextInt(16) == 0) {
                BiomeGenBase biomeGenBase;
                this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                n7 = this.field_73005_l >> 2;
                n6 = n7 & 0xF;
                n5 = n7 >> 8 & 0xF;
                n4 = this.func_72874_g(n6 + n8, n5 + n9);
                if (this.func_72850_v(n6 + n8, n4 - 1, n5 + n9)) {
                    this.func_94575_c(n6 + n8, n4 - 1, n5 + n9, Block.field_72036_aT.field_71990_ca);
                }
                if (this.func_72896_J() && this.func_72858_w(n6 + n8, n4, n5 + n9)) {
                    this.func_94575_c(n6 + n8, n4, n5 + n9, Block.field_72037_aS.field_71990_ca);
                }
                if (this.func_72896_J() && (biomeGenBase = this.func_72807_a(n6 + n8, n5 + n9)).func_76738_d() && (n3 = this.func_72798_a(n6 + n8, n4 - 1, n5 + n9)) != 0) {
                    Block.field_71973_m[n3].func_71892_f(this, n6 + n8, n4 - 1, n5 + n9);
                }
            }
            this.field_72984_F.func_76318_c("tickTiles");
            for (ExtendedBlockStorage extendedBlockStorage : chunk.func_76587_i()) {
                if (extendedBlockStorage == null || !extendedBlockStorage.func_76675_b()) continue;
                for (int i = 0; i < 3; ++i) {
                    this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                    n3 = this.field_73005_l >> 2;
                    int n10 = n3 & 0xF;
                    int n11 = n3 >> 8 & 0xF;
                    int n12 = n3 >> 16 & 0xF;
                    int n13 = extendedBlockStorage.func_76656_a(n10, n12, n11);
                    ++n2;
                    Block block = Block.field_71973_m[n13];
                    if (block == null || !block.func_71881_r()) continue;
                    ++n;
                    block.func_71847_b(this, n10 + n8, n12 + extendedBlockStorage.func_76662_d(), n11 + n9, this.field_73012_v);
                }
            }
            this.field_72984_F.func_76319_b();
        }
    }

    @Override
    public boolean func_94573_a(int p_94573_1_, int p_94573_2_, int p_94573_3_, int p_94573_4_) {
        NextTickListEntry nextTickListEntry = new NextTickListEntry(p_94573_1_, p_94573_2_, p_94573_3_, p_94573_4_);
        return this.field_94579_S.contains(nextTickListEntry);
    }

    @Override
    public void func_72836_a(int p_72836_1_, int p_72836_2_, int p_72836_3_, int p_72836_4_, int p_72836_5_) {
        this.func_82740_a(p_72836_1_, p_72836_2_, p_72836_3_, p_72836_4_, p_72836_5_, 0);
    }

    @Override
    public void func_82740_a(int p_82740_1_, int p_82740_2_, int p_82740_3_, int p_82740_4_, int p_82740_5_, int p_82740_6_) {
        NextTickListEntry nextTickListEntry = new NextTickListEntry(p_82740_1_, p_82740_2_, p_82740_3_, p_82740_4_);
        int n = 0;
        if (this.field_72999_e && p_82740_4_ > 0) {
            if (Block.field_71973_m[p_82740_4_].func_82506_l()) {
                int n2;
                n = 8;
                if (this.func_72904_c(nextTickListEntry.field_77183_a - n, nextTickListEntry.field_77181_b - n, nextTickListEntry.field_77182_c - n, nextTickListEntry.field_77183_a + n, nextTickListEntry.field_77181_b + n, nextTickListEntry.field_77182_c + n) && (n2 = this.func_72798_a(nextTickListEntry.field_77183_a, nextTickListEntry.field_77181_b, nextTickListEntry.field_77182_c)) == nextTickListEntry.field_77179_d && n2 > 0) {
                    Block.field_71973_m[n2].func_71847_b(this, nextTickListEntry.field_77183_a, nextTickListEntry.field_77181_b, nextTickListEntry.field_77182_c, this.field_73012_v);
                }
                return;
            }
            p_82740_5_ = 1;
        }
        if (this.func_72904_c(p_82740_1_ - n, p_82740_2_ - n, p_82740_3_ - n, p_82740_1_ + n, p_82740_2_ + n, p_82740_3_ + n)) {
            if (p_82740_4_ > 0) {
                nextTickListEntry.func_77176_a((long)p_82740_5_ + this.field_72986_A.func_82573_f());
                nextTickListEntry.func_82753_a(p_82740_6_);
            }
            if (!this.field_73064_N.contains(nextTickListEntry)) {
                this.field_73064_N.add(nextTickListEntry);
                this.field_73065_O.add(nextTickListEntry);
            }
        }
    }

    @Override
    public void func_72892_b(int p_72892_1_, int p_72892_2_, int p_72892_3_, int p_72892_4_, int p_72892_5_, int p_72892_6_) {
        NextTickListEntry nextTickListEntry = new NextTickListEntry(p_72892_1_, p_72892_2_, p_72892_3_, p_72892_4_);
        nextTickListEntry.func_82753_a(p_72892_6_);
        if (p_72892_4_ > 0) {
            nextTickListEntry.func_77176_a((long)p_72892_5_ + this.field_72986_A.func_82573_f());
        }
        if (!this.field_73064_N.contains(nextTickListEntry)) {
            this.field_73064_N.add(nextTickListEntry);
            this.field_73065_O.add(nextTickListEntry);
        }
    }

    @Override
    public void func_72939_s() {
        if (this.field_73010_i.isEmpty()) {
            if (this.field_80004_Q++ >= 1200) {
                return;
            }
        } else {
            this.func_82742_i();
        }
        super.func_72939_s();
    }

    public void func_82742_i() {
        this.field_80004_Q = 0;
    }

    @Override
    public boolean func_72955_a(boolean p_72955_1_) {
        NextTickListEntry nextTickListEntry;
        int n = this.field_73065_O.size();
        if (n != this.field_73064_N.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (n > 1000) {
            n = 1000;
        }
        this.field_72984_F.func_76320_a("cleaning");
        for (int i = 0; i < n; ++i) {
            nextTickListEntry = (NextTickListEntry)this.field_73065_O.first();
            if (!p_72955_1_ && nextTickListEntry.field_77180_e > this.field_72986_A.func_82573_f()) break;
            this.field_73065_O.remove(nextTickListEntry);
            this.field_73064_N.remove(nextTickListEntry);
            this.field_94579_S.add(nextTickListEntry);
        }
        this.field_72984_F.func_76319_b();
        this.field_72984_F.func_76320_a("ticking");
        Iterator iterator = this.field_94579_S.iterator();
        while (iterator.hasNext()) {
            nextTickListEntry = (NextTickListEntry)iterator.next();
            iterator.remove();
            int n2 = 0;
            if (this.func_72904_c(nextTickListEntry.field_77183_a - n2, nextTickListEntry.field_77181_b - n2, nextTickListEntry.field_77182_c - n2, nextTickListEntry.field_77183_a + n2, nextTickListEntry.field_77181_b + n2, nextTickListEntry.field_77182_c + n2)) {
                int n3 = this.func_72798_a(nextTickListEntry.field_77183_a, nextTickListEntry.field_77181_b, nextTickListEntry.field_77182_c);
                if (n3 <= 0 || !Block.func_94329_b(n3, nextTickListEntry.field_77179_d)) continue;
                try {
                    Block.field_71973_m[n3].func_71847_b(this, nextTickListEntry.field_77183_a, nextTickListEntry.field_77181_b, nextTickListEntry.field_77182_c, this.field_73012_v);
                    continue;
                }
                catch (Throwable throwable) {
                    int n4;
                    CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception while ticking a block");
                    CrashReportCategory crashReportCategory = crashReport.func_85058_a("Block being ticked");
                    try {
                        n4 = this.func_72805_g(nextTickListEntry.field_77183_a, nextTickListEntry.field_77181_b, nextTickListEntry.field_77182_c);
                    }
                    catch (Throwable throwable2) {
                        n4 = -1;
                    }
                    CrashReportCategory.func_85068_a(crashReportCategory, nextTickListEntry.field_77183_a, nextTickListEntry.field_77181_b, nextTickListEntry.field_77182_c, n3, n4);
                    throw new ReportedException(crashReport);
                }
            }
            this.func_72836_a(nextTickListEntry.field_77183_a, nextTickListEntry.field_77181_b, nextTickListEntry.field_77182_c, nextTickListEntry.field_77179_d, 0);
        }
        this.field_72984_F.func_76319_b();
        this.field_94579_S.clear();
        return !this.field_73065_O.isEmpty();
    }

    @Override
    public List func_72920_a(Chunk p_72920_1_, boolean p_72920_2_) {
        ArrayList<NextTickListEntry> arrayList = null;
        ChunkCoordIntPair chunkCoordIntPair = p_72920_1_.func_76632_l();
        int n = (chunkCoordIntPair.field_77276_a << 4) - 2;
        int n2 = n + 16 + 2;
        int n3 = (chunkCoordIntPair.field_77275_b << 4) - 2;
        int n4 = n3 + 16 + 2;
        for (int i = 0; i < 2; ++i) {
            Iterator iterator;
            if (i == 0) {
                iterator = this.field_73065_O.iterator();
            } else {
                iterator = this.field_94579_S.iterator();
                if (!this.field_94579_S.isEmpty()) {
                    System.out.println(this.field_94579_S.size());
                }
            }
            while (iterator.hasNext()) {
                NextTickListEntry nextTickListEntry = (NextTickListEntry)iterator.next();
                if (nextTickListEntry.field_77183_a < n || nextTickListEntry.field_77183_a >= n2 || nextTickListEntry.field_77182_c < n3 || nextTickListEntry.field_77182_c >= n4) continue;
                if (p_72920_2_) {
                    this.field_73064_N.remove(nextTickListEntry);
                    iterator.remove();
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<NextTickListEntry>();
                }
                arrayList.add(nextTickListEntry);
            }
        }
        return arrayList;
    }

    @Override
    public void func_72866_a(Entity p_72866_1_, boolean p_72866_2_) {
        if (!this.field_73061_a.func_71268_U() && (p_72866_1_ instanceof EntityAnimal || p_72866_1_ instanceof EntityWaterMob)) {
            p_72866_1_.func_70106_y();
        }
        if (!this.field_73061_a.func_71220_V() && p_72866_1_ instanceof INpc) {
            p_72866_1_.func_70106_y();
        }
        super.func_72866_a(p_72866_1_, p_72866_2_);
    }

    @Override
    protected IChunkProvider func_72970_h() {
        IChunkLoader iChunkLoader = this.field_73019_z.func_75763_a(this.field_73011_w);
        this.field_73059_b = new ChunkProviderServer(this, iChunkLoader, this.field_73011_w.func_76555_c());
        return this.field_73059_b;
    }

    public List func_73049_a(int p_73049_1_, int p_73049_2_, int p_73049_3_, int p_73049_4_, int p_73049_5_, int p_73049_6_) {
        ArrayList<TileEntity> arrayList = new ArrayList<TileEntity>();
        for (int i = 0; i < this.field_73009_h.size(); ++i) {
            TileEntity tileEntity = (TileEntity)this.field_73009_h.get(i);
            if (tileEntity.field_70329_l < p_73049_1_ || tileEntity.field_70330_m < p_73049_2_ || tileEntity.field_70327_n < p_73049_3_ || tileEntity.field_70329_l >= p_73049_4_ || tileEntity.field_70330_m >= p_73049_5_ || tileEntity.field_70327_n >= p_73049_6_) continue;
            arrayList.add(tileEntity);
        }
        return arrayList;
    }

    @Override
    public boolean func_72962_a(EntityPlayer p_72962_1_, int p_72962_2_, int p_72962_3_, int p_72962_4_) {
        return !this.field_73061_a.func_96290_a(this, p_72962_2_, p_72962_3_, p_72962_4_, p_72962_1_);
    }

    @Override
    protected void func_72963_a(WorldSettings p_72963_1_) {
        if (this.field_73066_T == null) {
            this.field_73066_T = new IntHashMap();
        }
        if (this.field_73064_N == null) {
            this.field_73064_N = new HashSet();
        }
        if (this.field_73065_O == null) {
            this.field_73065_O = new TreeSet();
        }
        this.func_73052_b(p_72963_1_);
        super.func_72963_a(p_72963_1_);
    }

    protected void func_73052_b(WorldSettings p_73052_1_) {
        if (!this.field_73011_w.func_76567_e()) {
            this.field_72986_A.func_76081_a(0, this.field_73011_w.func_76557_i(), 0);
            return;
        }
        this.field_72987_B = true;
        WorldChunkManager worldChunkManager = this.field_73011_w.field_76578_c;
        List list = worldChunkManager.func_76932_a();
        Random random = new Random(this.func_72905_C());
        ChunkPosition chunkPosition = worldChunkManager.func_76941_a(0, 0, 256, list, random);
        int n = 0;
        int n2 = this.field_73011_w.func_76557_i();
        int n3 = 0;
        if (chunkPosition != null) {
            n = chunkPosition.field_76930_a;
            n3 = chunkPosition.field_76929_c;
        } else {
            this.func_98180_V().func_98236_b("Unable to find spawn biome");
        }
        int n4 = 0;
        while (!this.field_73011_w.func_76566_a(n, n3)) {
            n += random.nextInt(64) - random.nextInt(64);
            n3 += random.nextInt(64) - random.nextInt(64);
            if (++n4 != 1000) continue;
        }
        this.field_72986_A.func_76081_a(n, n2, n3);
        this.field_72987_B = false;
        if (p_73052_1_.func_77167_c()) {
            this.func_73047_i();
        }
    }

    protected void func_73047_i() {
        int n;
        int n2;
        int n3;
        WorldGeneratorBonusChest worldGeneratorBonusChest = new WorldGeneratorBonusChest(field_73069_S, 10);
        for (int i = 0; i < 10 && !worldGeneratorBonusChest.func_76484_a(this, this.field_73012_v, n3 = this.field_72986_A.func_76079_c() + this.field_73012_v.nextInt(6) - this.field_73012_v.nextInt(6), n2 = this.func_72825_h(n3, n = this.field_72986_A.func_76074_e() + this.field_73012_v.nextInt(6) - this.field_73012_v.nextInt(6)) + 1, n); ++i) {
        }
    }

    public ChunkCoordinates func_73054_j() {
        return this.field_73011_w.func_76554_h();
    }

    public void func_73044_a(boolean p_73044_1_, IProgressUpdate p_73044_2_) throws MinecraftException {
        if (!this.field_73020_y.func_73157_c()) {
            return;
        }
        if (p_73044_2_ != null) {
            p_73044_2_.func_73720_a("Saving level");
        }
        this.func_73042_a();
        if (p_73044_2_ != null) {
            p_73044_2_.func_73719_c("Saving chunks");
        }
        this.field_73020_y.func_73151_a(p_73044_1_, p_73044_2_);
    }

    public void func_104140_m() {
        if (!this.field_73020_y.func_73157_c()) {
            return;
        }
        this.field_73020_y.func_104112_b();
    }

    protected void func_73042_a() throws MinecraftException {
        this.func_72906_B();
        this.field_73019_z.func_75755_a(this.field_72986_A, this.field_73061_a.func_71203_ab().func_72378_q());
        this.field_72988_C.func_75744_a();
    }

    @Override
    protected void func_72923_a(Entity p_72923_1_) {
        super.func_72923_a(p_72923_1_);
        this.field_73066_T.func_76038_a(p_72923_1_.field_70157_k, p_72923_1_);
        Entity[] entityArray = p_72923_1_.func_70021_al();
        if (entityArray != null) {
            for (int i = 0; i < entityArray.length; ++i) {
                this.field_73066_T.func_76038_a(entityArray[i].field_70157_k, entityArray[i]);
            }
        }
    }

    @Override
    public void func_72847_b(Entity p_72847_1_) {
        super.func_72847_b(p_72847_1_);
        this.field_73066_T.func_76049_d(p_72847_1_.field_70157_k);
        Entity[] entityArray = p_72847_1_.func_70021_al();
        if (entityArray != null) {
            for (int i = 0; i < entityArray.length; ++i) {
                this.field_73066_T.func_76049_d(entityArray[i].field_70157_k);
            }
        }
    }

    @Override
    public Entity func_73045_a(int p_73045_1_) {
        return (Entity)this.field_73066_T.func_76041_a(p_73045_1_);
    }

    @Override
    public boolean func_72942_c(Entity p_72942_1_) {
        if (super.func_72942_c(p_72942_1_)) {
            this.field_73061_a.func_71203_ab().func_72393_a(p_72942_1_.field_70165_t, p_72942_1_.field_70163_u, p_72942_1_.field_70161_v, 512.0, this.field_73011_w.field_76574_g, new Packet71Weather(p_72942_1_));
            return true;
        }
        return false;
    }

    @Override
    public void func_72960_a(Entity p_72960_1_, byte p_72960_2_) {
        Packet38EntityStatus packet38EntityStatus = new Packet38EntityStatus(p_72960_1_.field_70157_k, p_72960_2_);
        this.func_73039_n().func_72789_b(p_72960_1_, packet38EntityStatus);
    }

    @Override
    public Explosion func_72885_a(Entity p_72885_1_, double p_72885_2_, double p_72885_4_, double p_72885_6_, float p_72885_8_, boolean p_72885_9_, boolean p_72885_10_) {
        Explosion explosion = new Explosion(this, p_72885_1_, p_72885_2_, p_72885_4_, p_72885_6_, p_72885_8_);
        explosion.field_77286_a = p_72885_9_;
        explosion.field_82755_b = p_72885_10_;
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        if (!p_72885_10_) {
            explosion.field_77281_g.clear();
        }
        for (EntityPlayer entityPlayer : this.field_73010_i) {
            if (!(entityPlayer.func_70092_e(p_72885_2_, p_72885_4_, p_72885_6_) < 4096.0)) continue;
            ((EntityPlayerMP)entityPlayer).field_71135_a.func_72567_b(new Packet60Explosion(p_72885_2_, p_72885_4_, p_72885_6_, p_72885_8_, explosion.field_77281_g, (Vec3)explosion.func_77277_b().get(entityPlayer)));
        }
        return explosion;
    }

    @Override
    public void func_72965_b(int p_72965_1_, int p_72965_2_, int p_72965_3_, int p_72965_4_, int p_72965_5_, int p_72965_6_) {
        BlockEventData blockEventData = new BlockEventData(p_72965_1_, p_72965_2_, p_72965_3_, p_72965_4_, p_72965_5_, p_72965_6_);
        for (BlockEventData blockEventData2 : this.field_73067_Q[this.field_73070_R]) {
            if (!blockEventData2.equals(blockEventData)) continue;
            return;
        }
        this.field_73067_Q[this.field_73070_R].add(blockEventData);
    }

    private void func_73055_Q() {
        while (!this.field_73067_Q[this.field_73070_R].isEmpty()) {
            int n = this.field_73070_R;
            this.field_73070_R ^= 1;
            for (BlockEventData blockEventData : this.field_73067_Q[n]) {
                if (!this.func_73043_a(blockEventData)) continue;
                this.field_73061_a.func_71203_ab().func_72393_a(blockEventData.func_76919_a(), blockEventData.func_76921_b(), blockEventData.func_76920_c(), 64.0, this.field_73011_w.field_76574_g, new Packet54PlayNoteBlock(blockEventData.func_76919_a(), blockEventData.func_76921_b(), blockEventData.func_76920_c(), blockEventData.func_76916_f(), blockEventData.func_76918_d(), blockEventData.func_76917_e()));
            }
            this.field_73067_Q[n].clear();
        }
    }

    private boolean func_73043_a(BlockEventData p_73043_1_) {
        int n = this.func_72798_a(p_73043_1_.func_76919_a(), p_73043_1_.func_76921_b(), p_73043_1_.func_76920_c());
        if (n == p_73043_1_.func_76916_f()) {
            return Block.field_71973_m[n].func_71883_b(this, p_73043_1_.func_76919_a(), p_73043_1_.func_76921_b(), p_73043_1_.func_76920_c(), p_73043_1_.func_76918_d(), p_73043_1_.func_76917_e());
        }
        return false;
    }

    public void func_73041_k() {
        this.field_73019_z.func_75759_a();
    }

    @Override
    protected void func_72979_l() {
        boolean bl = this.func_72896_J();
        super.func_72979_l();
        if (bl != this.func_72896_J()) {
            if (bl) {
                this.field_73061_a.func_71203_ab().func_72384_a(new Packet70GameEvent(2, 0));
            } else {
                this.field_73061_a.func_71203_ab().func_72384_a(new Packet70GameEvent(1, 0));
            }
        }
    }

    public MinecraftServer func_73046_m() {
        return this.field_73061_a;
    }

    public EntityTracker func_73039_n() {
        return this.field_73062_L;
    }

    public PlayerManager func_73040_p() {
        return this.field_73063_M;
    }

    public Teleporter func_85176_s() {
        return this.field_85177_Q;
    }
}

