/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.base.Charsets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemInWorldManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.NetServerHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet16BlockItemSwitch;
import net.minecraft.network.packet.Packet1Login;
import net.minecraft.network.packet.Packet201PlayerInfo;
import net.minecraft.network.packet.Packet202PlayerAbilities;
import net.minecraft.network.packet.Packet209SetPlayerTeam;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.network.packet.Packet3Chat;
import net.minecraft.network.packet.Packet41EntityEffect;
import net.minecraft.network.packet.Packet43Experience;
import net.minecraft.network.packet.Packet4UpdateTime;
import net.minecraft.network.packet.Packet6SpawnPosition;
import net.minecraft.network.packet.Packet70GameEvent;
import net.minecraft.network.packet.Packet9Respawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.BanEntry;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.server.management.PlayerPositionComparator;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.demo.DemoWorldManager;
import net.minecraft.world.storage.IPlayerFileData;

public abstract class ServerConfigurationManager {
    private static final SimpleDateFormat field_72403_e = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer field_72400_f;
    public final List field_72404_b = new ArrayList();
    private final BanList field_72401_g = new BanList(new File("banned-players.txt"));
    private final BanList field_72413_h = new BanList(new File("banned-ips.txt"));
    private Set field_72414_i = new HashSet();
    private Set field_72411_j = new HashSet();
    private IPlayerFileData field_72412_k;
    private boolean field_72409_l;
    protected int field_72405_c;
    protected int field_72402_d;
    private EnumGameType field_72410_m;
    private boolean field_72407_n;
    private int field_72408_o;

    public ServerConfigurationManager(MinecraftServer p_i1500_1_) {
        this.field_72400_f = p_i1500_1_;
        this.field_72401_g.func_73708_a(false);
        this.field_72413_h.func_73708_a(false);
        this.field_72405_c = 8;
    }

    public void func_72355_a(INetworkManager p_72355_1_, EntityPlayerMP p_72355_2_) {
        NBTTagCompound nBTTagCompound = this.func_72380_a(p_72355_2_);
        p_72355_2_.func_70029_a(this.field_72400_f.func_71218_a(p_72355_2_.field_71093_bK));
        p_72355_2_.field_71134_c.func_73080_a((WorldServer)p_72355_2_.field_70170_p);
        String string = "local";
        if (p_72355_1_.func_74430_c() != null) {
            string = p_72355_1_.func_74430_c().toString();
        }
        this.field_72400_f.func_98033_al().func_98233_a(p_72355_2_.func_70005_c_() + "[" + string + "] logged in with entity id " + p_72355_2_.field_70157_k + " at (" + p_72355_2_.field_70165_t + ", " + p_72355_2_.field_70163_u + ", " + p_72355_2_.field_70161_v + ")");
        WorldServer worldServer = this.field_72400_f.func_71218_a(p_72355_2_.field_71093_bK);
        ChunkCoordinates chunkCoordinates = worldServer.func_72861_E();
        this.func_72381_a(p_72355_2_, null, worldServer);
        NetServerHandler netServerHandler = new NetServerHandler(this.field_72400_f, p_72355_1_, p_72355_2_);
        netServerHandler.func_72567_b(new Packet1Login(p_72355_2_.field_70157_k, worldServer.func_72912_H().func_76067_t(), p_72355_2_.field_71134_c.func_73081_b(), worldServer.func_72912_H().func_76093_s(), worldServer.field_73011_w.field_76574_g, worldServer.field_73013_u, worldServer.func_72800_K(), this.func_72352_l()));
        netServerHandler.func_72567_b(new Packet250CustomPayload("MC|Brand", this.func_72365_p().getServerModName().getBytes(Charsets.UTF_8)));
        netServerHandler.func_72567_b(new Packet6SpawnPosition(chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b, chunkCoordinates.field_71573_c));
        netServerHandler.func_72567_b(new Packet202PlayerAbilities(p_72355_2_.field_71075_bZ));
        netServerHandler.func_72567_b(new Packet16BlockItemSwitch(p_72355_2_.field_71071_by.field_70461_c));
        this.func_96456_a((ServerScoreboard)worldServer.func_96441_U(), p_72355_2_);
        this.func_72354_b(p_72355_2_, worldServer);
        this.func_92062_k(ChatMessageComponent.func_111082_b("multiplayer.player.joined", p_72355_2_.func_96090_ax()).func_111059_a(EnumChatFormatting.YELLOW));
        this.func_72377_c(p_72355_2_);
        netServerHandler.func_72569_a(p_72355_2_.field_70165_t, p_72355_2_.field_70163_u, p_72355_2_.field_70161_v, p_72355_2_.field_70177_z, p_72355_2_.field_70125_A);
        this.field_72400_f.func_71212_ac().func_71745_a(netServerHandler);
        netServerHandler.func_72567_b(new Packet4UpdateTime(worldServer.func_82737_E(), worldServer.func_72820_D(), worldServer.func_82736_K().func_82766_b("doDaylightCycle")));
        if (this.field_72400_f.func_71202_P().length() > 0) {
            p_72355_2_.func_71115_a(this.field_72400_f.func_71202_P(), this.field_72400_f.func_71227_R());
        }
        Object object = p_72355_2_.func_70651_bq().iterator();
        while (object.hasNext()) {
            PotionEffect potionEffect = (PotionEffect)object.next();
            netServerHandler.func_72567_b(new Packet41EntityEffect(p_72355_2_.field_70157_k, potionEffect));
        }
        p_72355_2_.func_71116_b();
        if (nBTTagCompound != null && nBTTagCompound.func_74764_b("Riding") && (object = EntityList.func_75615_a(nBTTagCompound.func_74775_l("Riding"), worldServer)) != null) {
            ((Entity)object).field_98038_p = true;
            worldServer.func_72838_d((Entity)object);
            p_72355_2_.func_70078_a((Entity)object);
            ((Entity)object).field_98038_p = false;
        }
    }

    protected void func_96456_a(ServerScoreboard p_96456_1_, EntityPlayerMP p_96456_2_) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object : p_96456_1_.func_96525_g()) {
            p_96456_2_.field_71135_a.func_72567_b(new Packet209SetPlayerTeam((ScorePlayerTeam)object, 0));
        }
        for (int i = 0; i < 3; ++i) {
            Object object;
            object = p_96456_1_.func_96539_a(i);
            if (object == null || hashSet.contains(object)) continue;
            List list = p_96456_1_.func_96550_d((ScoreObjective)object);
            for (Packet packet : list) {
                p_96456_2_.field_71135_a.func_72567_b(packet);
            }
            hashSet.add(object);
        }
    }

    public void func_72364_a(WorldServer[] p_72364_1_) {
        this.field_72412_k = p_72364_1_[0].func_72860_G().func_75756_e();
    }

    public void func_72375_a(EntityPlayerMP p_72375_1_, WorldServer p_72375_2_) {
        WorldServer worldServer = p_72375_1_.func_71121_q();
        if (p_72375_2_ != null) {
            p_72375_2_.func_73040_p().func_72695_c(p_72375_1_);
        }
        worldServer.func_73040_p().func_72683_a(p_72375_1_);
        worldServer.field_73059_b.func_73158_c((int)p_72375_1_.field_70165_t >> 4, (int)p_72375_1_.field_70161_v >> 4);
    }

    public int func_72372_a() {
        return PlayerManager.func_72686_a(this.func_72395_o());
    }

    public NBTTagCompound func_72380_a(EntityPlayerMP p_72380_1_) {
        NBTTagCompound nBTTagCompound;
        NBTTagCompound nBTTagCompound2 = this.field_72400_f.field_71305_c[0].func_72912_H().func_76072_h();
        if (p_72380_1_.func_70005_c_().equals(this.field_72400_f.func_71214_G()) && nBTTagCompound2 != null) {
            p_72380_1_.func_70020_e(nBTTagCompound2);
            nBTTagCompound = nBTTagCompound2;
            System.out.println("loading single player");
        } else {
            nBTTagCompound = this.field_72412_k.func_75752_b(p_72380_1_);
        }
        return nBTTagCompound;
    }

    protected void func_72391_b(EntityPlayerMP p_72391_1_) {
        this.field_72412_k.func_75753_a(p_72391_1_);
    }

    public void func_72377_c(EntityPlayerMP p_72377_1_) {
        this.func_72384_a(new Packet201PlayerInfo(p_72377_1_.func_70005_c_(), true, 1000));
        this.field_72404_b.add(p_72377_1_);
        WorldServer worldServer = this.field_72400_f.func_71218_a(p_72377_1_.field_71093_bK);
        worldServer.func_72838_d(p_72377_1_);
        this.func_72375_a(p_72377_1_, null);
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)this.field_72404_b.get(i);
            p_72377_1_.field_71135_a.func_72567_b(new Packet201PlayerInfo(entityPlayerMP.func_70005_c_(), true, entityPlayerMP.field_71138_i));
        }
    }

    public void func_72358_d(EntityPlayerMP p_72358_1_) {
        p_72358_1_.func_71121_q().func_73040_p().func_72685_d(p_72358_1_);
    }

    public void func_72367_e(EntityPlayerMP p_72367_1_) {
        this.func_72391_b(p_72367_1_);
        WorldServer worldServer = p_72367_1_.func_71121_q();
        if (p_72367_1_.field_70154_o != null) {
            worldServer.func_72973_f(p_72367_1_.field_70154_o);
            System.out.println("removing player mount");
        }
        worldServer.func_72900_e(p_72367_1_);
        worldServer.func_73040_p().func_72695_c(p_72367_1_);
        this.field_72404_b.remove(p_72367_1_);
        this.func_72384_a(new Packet201PlayerInfo(p_72367_1_.func_70005_c_(), false, 9999));
    }

    public String func_72399_a(SocketAddress p_72399_1_, String p_72399_2_) {
        if (this.field_72401_g.func_73704_a(p_72399_2_)) {
            BanEntry banEntry = (BanEntry)this.field_72401_g.func_73712_c().get(p_72399_2_);
            String string = "You are banned from this server!\nReason: " + banEntry.func_73686_f();
            if (banEntry.func_73680_d() != null) {
                string = string + "\nYour ban will be removed on " + field_72403_e.format(banEntry.func_73680_d());
            }
            return string;
        }
        if (!this.func_72370_d(p_72399_2_)) {
            return "You are not white-listed on this server!";
        }
        String string = p_72399_1_.toString();
        string = string.substring(string.indexOf("/") + 1);
        if (this.field_72413_h.func_73704_a(string = string.substring(0, string.indexOf(":")))) {
            BanEntry banEntry = (BanEntry)this.field_72413_h.func_73712_c().get(string);
            String string2 = "Your IP address is banned from this server!\nReason: " + banEntry.func_73686_f();
            if (banEntry.func_73680_d() != null) {
                string2 = string2 + "\nYour ban will be removed on " + field_72403_e.format(banEntry.func_73680_d());
            }
            return string2;
        }
        if (this.field_72404_b.size() >= this.field_72405_c) {
            return "The server is full!";
        }
        return null;
    }

    public EntityPlayerMP func_72366_a(String p_72366_1_) {
        ArrayList<EntityPlayerMP> arrayList = new ArrayList<EntityPlayerMP>();
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)this.field_72404_b.get(i);
            if (!entityPlayerMP.func_70005_c_().equalsIgnoreCase(p_72366_1_)) continue;
            arrayList.add(entityPlayerMP);
        }
        for (EntityPlayerMP entityPlayerMP : arrayList) {
            entityPlayerMP.field_71135_a.func_72565_c("You logged in from another location");
        }
        ItemInWorldManager itemInWorldManager = this.field_72400_f.func_71242_L() ? new DemoWorldManager(this.field_72400_f.func_71218_a(0)) : new ItemInWorldManager(this.field_72400_f.func_71218_a(0));
        return new EntityPlayerMP(this.field_72400_f, this.field_72400_f.func_71218_a(0), p_72366_1_, itemInWorldManager);
    }

    public EntityPlayerMP func_72368_a(EntityPlayerMP p_72368_1_, int p_72368_2_, boolean p_72368_3_) {
        ChunkCoordinates chunkCoordinates;
        p_72368_1_.func_71121_q().func_73039_n().func_72787_a(p_72368_1_);
        p_72368_1_.func_71121_q().func_73039_n().func_72790_b(p_72368_1_);
        p_72368_1_.func_71121_q().func_73040_p().func_72695_c(p_72368_1_);
        this.field_72404_b.remove(p_72368_1_);
        this.field_72400_f.func_71218_a(p_72368_1_.field_71093_bK).func_72973_f(p_72368_1_);
        ChunkCoordinates chunkCoordinates2 = p_72368_1_.func_70997_bJ();
        boolean bl = p_72368_1_.func_82245_bX();
        p_72368_1_.field_71093_bK = p_72368_2_;
        ItemInWorldManager itemInWorldManager = this.field_72400_f.func_71242_L() ? new DemoWorldManager(this.field_72400_f.func_71218_a(p_72368_1_.field_71093_bK)) : new ItemInWorldManager(this.field_72400_f.func_71218_a(p_72368_1_.field_71093_bK));
        EntityPlayerMP entityPlayerMP = new EntityPlayerMP(this.field_72400_f, this.field_72400_f.func_71218_a(p_72368_1_.field_71093_bK), p_72368_1_.func_70005_c_(), itemInWorldManager);
        entityPlayerMP.field_71135_a = p_72368_1_.field_71135_a;
        entityPlayerMP.func_71049_a(p_72368_1_, p_72368_3_);
        entityPlayerMP.field_70157_k = p_72368_1_.field_70157_k;
        WorldServer worldServer = this.field_72400_f.func_71218_a(p_72368_1_.field_71093_bK);
        this.func_72381_a(entityPlayerMP, p_72368_1_, worldServer);
        if (chunkCoordinates2 != null) {
            chunkCoordinates = EntityPlayer.func_71056_a(this.field_72400_f.func_71218_a(p_72368_1_.field_71093_bK), chunkCoordinates2, bl);
            if (chunkCoordinates != null) {
                entityPlayerMP.func_70012_b((float)chunkCoordinates.field_71574_a + 0.5f, (float)chunkCoordinates.field_71572_b + 0.1f, (float)chunkCoordinates.field_71573_c + 0.5f, 0.0f, 0.0f);
                entityPlayerMP.func_71063_a(chunkCoordinates2, bl);
            } else {
                entityPlayerMP.field_71135_a.func_72567_b(new Packet70GameEvent(0, 0));
            }
        }
        worldServer.field_73059_b.func_73158_c((int)entityPlayerMP.field_70165_t >> 4, (int)entityPlayerMP.field_70161_v >> 4);
        while (!worldServer.func_72945_a(entityPlayerMP, entityPlayerMP.field_70121_D).isEmpty()) {
            entityPlayerMP.func_70107_b(entityPlayerMP.field_70165_t, entityPlayerMP.field_70163_u + 1.0, entityPlayerMP.field_70161_v);
        }
        entityPlayerMP.field_71135_a.func_72567_b(new Packet9Respawn(entityPlayerMP.field_71093_bK, (byte)entityPlayerMP.field_70170_p.field_73013_u, entityPlayerMP.field_70170_p.func_72912_H().func_76067_t(), entityPlayerMP.field_70170_p.func_72800_K(), entityPlayerMP.field_71134_c.func_73081_b()));
        chunkCoordinates = worldServer.func_72861_E();
        entityPlayerMP.field_71135_a.func_72569_a(entityPlayerMP.field_70165_t, entityPlayerMP.field_70163_u, entityPlayerMP.field_70161_v, entityPlayerMP.field_70177_z, entityPlayerMP.field_70125_A);
        entityPlayerMP.field_71135_a.func_72567_b(new Packet6SpawnPosition(chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b, chunkCoordinates.field_71573_c));
        entityPlayerMP.field_71135_a.func_72567_b(new Packet43Experience(entityPlayerMP.field_71106_cc, entityPlayerMP.field_71067_cb, entityPlayerMP.field_71068_ca));
        this.func_72354_b(entityPlayerMP, worldServer);
        worldServer.func_73040_p().func_72683_a(entityPlayerMP);
        worldServer.func_72838_d(entityPlayerMP);
        this.field_72404_b.add(entityPlayerMP);
        entityPlayerMP.func_71116_b();
        entityPlayerMP.func_70606_j(entityPlayerMP.func_110143_aJ());
        return entityPlayerMP;
    }

    public void func_72356_a(EntityPlayerMP p_72356_1_, int p_72356_2_) {
        int n = p_72356_1_.field_71093_bK;
        WorldServer worldServer = this.field_72400_f.func_71218_a(p_72356_1_.field_71093_bK);
        p_72356_1_.field_71093_bK = p_72356_2_;
        WorldServer worldServer2 = this.field_72400_f.func_71218_a(p_72356_1_.field_71093_bK);
        p_72356_1_.field_71135_a.func_72567_b(new Packet9Respawn(p_72356_1_.field_71093_bK, (byte)p_72356_1_.field_70170_p.field_73013_u, worldServer2.func_72912_H().func_76067_t(), worldServer2.func_72800_K(), p_72356_1_.field_71134_c.func_73081_b()));
        worldServer.func_72973_f(p_72356_1_);
        p_72356_1_.field_70128_L = false;
        this.func_82448_a(p_72356_1_, n, worldServer, worldServer2);
        this.func_72375_a(p_72356_1_, worldServer);
        p_72356_1_.field_71135_a.func_72569_a(p_72356_1_.field_70165_t, p_72356_1_.field_70163_u, p_72356_1_.field_70161_v, p_72356_1_.field_70177_z, p_72356_1_.field_70125_A);
        p_72356_1_.field_71134_c.func_73080_a(worldServer2);
        this.func_72354_b(p_72356_1_, worldServer2);
        this.func_72385_f(p_72356_1_);
        for (PotionEffect potionEffect : p_72356_1_.func_70651_bq()) {
            p_72356_1_.field_71135_a.func_72567_b(new Packet41EntityEffect(p_72356_1_.field_70157_k, potionEffect));
        }
    }

    public void func_82448_a(Entity p_82448_1_, int p_82448_2_, WorldServer p_82448_3_, WorldServer p_82448_4_) {
        double d = p_82448_1_.field_70165_t;
        double d2 = p_82448_1_.field_70161_v;
        double d3 = 8.0;
        double d4 = p_82448_1_.field_70165_t;
        double d5 = p_82448_1_.field_70163_u;
        double d6 = p_82448_1_.field_70161_v;
        float f = p_82448_1_.field_70177_z;
        p_82448_3_.field_72984_F.func_76320_a("moving");
        if (p_82448_1_.field_71093_bK == -1) {
            p_82448_1_.func_70012_b(d /= d3, p_82448_1_.field_70163_u, d2 /= d3, p_82448_1_.field_70177_z, p_82448_1_.field_70125_A);
            if (p_82448_1_.func_70089_S()) {
                p_82448_3_.func_72866_a(p_82448_1_, false);
            }
        } else if (p_82448_1_.field_71093_bK == 0) {
            p_82448_1_.func_70012_b(d *= d3, p_82448_1_.field_70163_u, d2 *= d3, p_82448_1_.field_70177_z, p_82448_1_.field_70125_A);
            if (p_82448_1_.func_70089_S()) {
                p_82448_3_.func_72866_a(p_82448_1_, false);
            }
        } else {
            ChunkCoordinates chunkCoordinates = p_82448_2_ == 1 ? p_82448_4_.func_72861_E() : p_82448_4_.func_73054_j();
            d = chunkCoordinates.field_71574_a;
            p_82448_1_.field_70163_u = chunkCoordinates.field_71572_b;
            d2 = chunkCoordinates.field_71573_c;
            p_82448_1_.func_70012_b(d, p_82448_1_.field_70163_u, d2, 90.0f, 0.0f);
            if (p_82448_1_.func_70089_S()) {
                p_82448_3_.func_72866_a(p_82448_1_, false);
            }
        }
        p_82448_3_.field_72984_F.func_76319_b();
        if (p_82448_2_ != 1) {
            p_82448_3_.field_72984_F.func_76320_a("placing");
            d = MathHelper.func_76125_a((int)d, -29999872, 29999872);
            d2 = MathHelper.func_76125_a((int)d2, -29999872, 29999872);
            if (p_82448_1_.func_70089_S()) {
                p_82448_4_.func_72838_d(p_82448_1_);
                p_82448_1_.func_70012_b(d, p_82448_1_.field_70163_u, d2, p_82448_1_.field_70177_z, p_82448_1_.field_70125_A);
                p_82448_4_.func_72866_a(p_82448_1_, false);
                p_82448_4_.func_85176_s().func_77185_a(p_82448_1_, d4, d5, d6, f);
            }
            p_82448_3_.field_72984_F.func_76319_b();
        }
        p_82448_1_.func_70029_a(p_82448_4_);
    }

    public void func_72374_b() {
        if (++this.field_72408_o > 600) {
            this.field_72408_o = 0;
        }
        if (this.field_72408_o < this.field_72404_b.size()) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)this.field_72404_b.get(this.field_72408_o);
            this.func_72384_a(new Packet201PlayerInfo(entityPlayerMP.func_70005_c_(), true, entityPlayerMP.field_71138_i));
        }
    }

    public void func_72384_a(Packet p_72384_1_) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            ((EntityPlayerMP)this.field_72404_b.get((int)i)).field_71135_a.func_72567_b(p_72384_1_);
        }
    }

    public void func_72396_a(Packet p_72396_1_, int p_72396_2_) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)this.field_72404_b.get(i);
            if (entityPlayerMP.field_71093_bK != p_72396_2_) continue;
            entityPlayerMP.field_71135_a.func_72567_b(p_72396_1_);
        }
    }

    public String func_72398_c() {
        String string = "";
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + ((EntityPlayerMP)this.field_72404_b.get(i)).func_70005_c_();
        }
        return string;
    }

    public String[] func_72369_d() {
        String[] stringArray = new String[this.field_72404_b.size()];
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            stringArray[i] = ((EntityPlayerMP)this.field_72404_b.get(i)).func_70005_c_();
        }
        return stringArray;
    }

    public BanList func_72390_e() {
        return this.field_72401_g;
    }

    public BanList func_72363_f() {
        return this.field_72413_h;
    }

    public void func_72386_b(String p_72386_1_) {
        this.field_72414_i.add(p_72386_1_.toLowerCase());
    }

    public void func_72360_c(String p_72360_1_) {
        this.field_72414_i.remove(p_72360_1_.toLowerCase());
    }

    public boolean func_72370_d(String p_72370_1_) {
        p_72370_1_ = p_72370_1_.trim().toLowerCase();
        return !this.field_72409_l || this.field_72414_i.contains(p_72370_1_) || this.field_72411_j.contains(p_72370_1_);
    }

    public boolean func_72353_e(String p_72353_1_) {
        return this.field_72414_i.contains(p_72353_1_.trim().toLowerCase()) || this.field_72400_f.func_71264_H() && this.field_72400_f.field_71305_c[0].func_72912_H().func_76086_u() && this.field_72400_f.func_71214_G().equalsIgnoreCase(p_72353_1_) || this.field_72407_n;
    }

    public EntityPlayerMP func_72361_f(String p_72361_1_) {
        for (EntityPlayerMP entityPlayerMP : this.field_72404_b) {
            if (!entityPlayerMP.func_70005_c_().equalsIgnoreCase(p_72361_1_)) continue;
            return entityPlayerMP;
        }
        return null;
    }

    public List func_82449_a(ChunkCoordinates p_82449_1_, int p_82449_2_, int p_82449_3_, int p_82449_4_, int p_82449_5_, int p_82449_6_, int p_82449_7_, Map p_82449_8_, String p_82449_9_, String p_82449_10_, World p_82449_11_) {
        if (this.field_72404_b.isEmpty()) {
            return null;
        }
        List<EntityPlayerMP> list = new ArrayList();
        boolean bl = p_82449_4_ < 0;
        boolean bl2 = p_82449_9_ != null && p_82449_9_.startsWith("!");
        boolean bl3 = p_82449_10_ != null && p_82449_10_.startsWith("!");
        int n = p_82449_2_ * p_82449_2_;
        int n2 = p_82449_3_ * p_82449_3_;
        p_82449_4_ = MathHelper.func_76130_a(p_82449_4_);
        if (bl2) {
            p_82449_9_ = p_82449_9_.substring(1);
        }
        if (bl3) {
            p_82449_10_ = p_82449_10_.substring(1);
        }
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)this.field_72404_b.get(i);
            if (p_82449_11_ != null && entityPlayerMP.field_70170_p != p_82449_11_ || p_82449_9_ != null && bl2 == p_82449_9_.equalsIgnoreCase(entityPlayerMP.func_70023_ak())) continue;
            if (p_82449_10_ != null) {
                String string;
                Team team = entityPlayerMP.func_96124_cp();
                String string2 = string = team == null ? "" : team.func_96661_b();
                if (bl3 == p_82449_10_.equalsIgnoreCase(string)) continue;
            }
            if (p_82449_1_ != null && (p_82449_2_ > 0 || p_82449_3_ > 0)) {
                float f = p_82449_1_.func_82371_e(entityPlayerMP.func_82114_b());
                if (p_82449_2_ > 0 && f < (float)n || p_82449_3_ > 0 && f > (float)n2) continue;
            }
            if (!this.func_96457_a(entityPlayerMP, p_82449_8_) || p_82449_5_ != EnumGameType.NOT_SET.func_77148_a() && p_82449_5_ != entityPlayerMP.field_71134_c.func_73081_b().func_77148_a() || p_82449_6_ > 0 && entityPlayerMP.field_71068_ca < p_82449_6_ || entityPlayerMP.field_71068_ca > p_82449_7_) continue;
            list.add(entityPlayerMP);
        }
        if (p_82449_1_ != null) {
            Collections.sort(list, new PlayerPositionComparator(p_82449_1_));
        }
        if (bl) {
            Collections.reverse(list);
        }
        if (p_82449_4_ > 0) {
            list = list.subList(0, Math.min(p_82449_4_, list.size()));
        }
        return list;
    }

    private boolean func_96457_a(EntityPlayer p_96457_1_, Map p_96457_2_) {
        if (p_96457_2_ == null || p_96457_2_.size() == 0) {
            return true;
        }
        for (Map.Entry entry : p_96457_2_.entrySet()) {
            Scoreboard scoreboard;
            ScoreObjective scoreObjective;
            String string = (String)entry.getKey();
            boolean bl = false;
            if (string.endsWith("_min") && string.length() > 4) {
                bl = true;
                string = string.substring(0, string.length() - 4);
            }
            if ((scoreObjective = (scoreboard = p_96457_1_.func_96123_co()).func_96518_b(string)) == null) {
                return false;
            }
            Score score = p_96457_1_.func_96123_co().func_96529_a(p_96457_1_.func_70023_ak(), scoreObjective);
            int n = score.func_96652_c();
            if (n < (Integer)entry.getValue() && bl) {
                return false;
            }
            if (n <= (Integer)entry.getValue() || bl) continue;
            return false;
        }
        return true;
    }

    public void func_72393_a(double p_72393_1_, double p_72393_3_, double p_72393_5_, double p_72393_7_, int p_72393_9_, Packet p_72393_10_) {
        this.func_72397_a(null, p_72393_1_, p_72393_3_, p_72393_5_, p_72393_7_, p_72393_9_, p_72393_10_);
    }

    public void func_72397_a(EntityPlayer p_72397_1_, double p_72397_2_, double p_72397_4_, double p_72397_6_, double p_72397_8_, int p_72397_10_, Packet p_72397_11_) {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            double d;
            double d2;
            double d3;
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)this.field_72404_b.get(i);
            if (entityPlayerMP == p_72397_1_ || entityPlayerMP.field_71093_bK != p_72397_10_ || !((d3 = p_72397_2_ - entityPlayerMP.field_70165_t) * d3 + (d2 = p_72397_4_ - entityPlayerMP.field_70163_u) * d2 + (d = p_72397_6_ - entityPlayerMP.field_70161_v) * d < p_72397_8_ * p_72397_8_)) continue;
            entityPlayerMP.field_71135_a.func_72567_b(p_72397_11_);
        }
    }

    public void func_72389_g() {
        for (int i = 0; i < this.field_72404_b.size(); ++i) {
            this.func_72391_b((EntityPlayerMP)this.field_72404_b.get(i));
        }
    }

    public void func_72359_h(String p_72359_1_) {
        this.field_72411_j.add(p_72359_1_);
    }

    public void func_72379_i(String p_72379_1_) {
        this.field_72411_j.remove(p_72379_1_);
    }

    public Set func_72388_h() {
        return this.field_72411_j;
    }

    public Set func_72376_i() {
        return this.field_72414_i;
    }

    public void func_72362_j() {
    }

    public void func_72354_b(EntityPlayerMP p_72354_1_, WorldServer p_72354_2_) {
        p_72354_1_.field_71135_a.func_72567_b(new Packet4UpdateTime(p_72354_2_.func_82737_E(), p_72354_2_.func_72820_D(), p_72354_2_.func_82736_K().func_82766_b("doDaylightCycle")));
        if (p_72354_2_.func_72896_J()) {
            p_72354_1_.field_71135_a.func_72567_b(new Packet70GameEvent(1, 0));
        }
    }

    public void func_72385_f(EntityPlayerMP p_72385_1_) {
        p_72385_1_.func_71120_a(p_72385_1_.field_71069_bz);
        p_72385_1_.func_71118_n();
        p_72385_1_.field_71135_a.func_72567_b(new Packet16BlockItemSwitch(p_72385_1_.field_71071_by.field_70461_c));
    }

    public int func_72394_k() {
        return this.field_72404_b.size();
    }

    public int func_72352_l() {
        return this.field_72405_c;
    }

    public String[] func_72373_m() {
        return this.field_72400_f.field_71305_c[0].func_72860_G().func_75756_e().func_75754_f();
    }

    public boolean func_72383_n() {
        return this.field_72409_l;
    }

    public void func_72371_a(boolean p_72371_1_) {
        this.field_72409_l = p_72371_1_;
    }

    public List func_72382_j(String p_72382_1_) {
        ArrayList<EntityPlayerMP> arrayList = new ArrayList<EntityPlayerMP>();
        for (EntityPlayerMP entityPlayerMP : this.field_72404_b) {
            if (!entityPlayerMP.func_71114_r().equals(p_72382_1_)) continue;
            arrayList.add(entityPlayerMP);
        }
        return arrayList;
    }

    public int func_72395_o() {
        return this.field_72402_d;
    }

    public MinecraftServer func_72365_p() {
        return this.field_72400_f;
    }

    public NBTTagCompound func_72378_q() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72357_a(EnumGameType p_72357_1_) {
        this.field_72410_m = p_72357_1_;
    }

    private void func_72381_a(EntityPlayerMP p_72381_1_, EntityPlayerMP p_72381_2_, World p_72381_3_) {
        if (p_72381_2_ != null) {
            p_72381_1_.field_71134_c.func_73076_a(p_72381_2_.field_71134_c.func_73081_b());
        } else if (this.field_72410_m != null) {
            p_72381_1_.field_71134_c.func_73076_a(this.field_72410_m);
        }
        p_72381_1_.field_71134_c.func_73077_b(p_72381_3_.func_72912_H().func_76077_q());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_72387_b(boolean p_72387_1_) {
        this.field_72407_n = p_72387_1_;
    }

    public void func_72392_r() {
        while (!this.field_72404_b.isEmpty()) {
            ((EntityPlayerMP)this.field_72404_b.get((int)0)).field_71135_a.func_72565_c("Server closed");
        }
    }

    public void func_110459_a(ChatMessageComponent p_110459_1_, boolean p_110459_2_) {
        this.field_72400_f.func_70006_a(p_110459_1_);
        this.func_72384_a(new Packet3Chat(p_110459_1_, p_110459_2_));
    }

    public void func_92062_k(ChatMessageComponent p_92062_1_) {
        this.func_110459_a(p_92062_1_, true);
    }
}

