/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.data.BaseMetadataSectionSerializer;
import net.minecraft.client.resources.data.LanguageMetadataSection;

@SideOnly(value=Side.CLIENT)
public class LanguageMetadataSectionSerializer
extends BaseMetadataSectionSerializer {
    public LanguageMetadataSection func_135020_a(JsonElement p_135020_1_, Type p_135020_2_, JsonDeserializationContext p_135020_3_) {
        JsonObject jsonObject = p_135020_1_.getAsJsonObject();
        HashSet hashSet = Sets.newHashSet();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String string = (String)entry.getKey();
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (!jsonElement.isJsonObject()) {
                throw new JsonParseException("Invalid language->'" + string + "': expected object, was " + jsonElement);
            }
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            String string2 = this.func_110486_a(jsonObject2.get("region"), "region", "", 0, Integer.MAX_VALUE);
            String string3 = this.func_110486_a(jsonObject2.get("name"), "name", "", 0, Integer.MAX_VALUE);
            boolean bl = this.func_110484_a(jsonObject2.get("bidirectional"), "bidirectional", false);
            if (string2.isEmpty()) {
                throw new JsonParseException("Invalid language->'" + string + "'->region: empty value");
            }
            if (string3.isEmpty()) {
                throw new JsonParseException("Invalid language->'" + string + "'->name: empty value");
            }
            if (hashSet.add(new Language(string, string2, string3, bl))) continue;
            throw new JsonParseException("Duplicate language->'" + string + "' defined");
        }
        return new LanguageMetadataSection(hashSet);
    }

    @Override
    public String func_110483_a() {
        return "language";
    }

    public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) {
        return this.func_135020_a(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
    }
}

