/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.BaseMetadataSectionSerializer;

@SideOnly(value=Side.CLIENT)
public class AnimationMetadataSectionSerializer
extends BaseMetadataSectionSerializer
implements JsonSerializer {
    public AnimationMetadataSection func_110493_a(JsonElement p_110493_1_, Type p_110493_2_, JsonDeserializationContext p_110493_3_) {
        int n;
        ArrayList arrayList = Lists.newArrayList();
        JsonObject jsonObject = (JsonObject)p_110493_1_;
        int n2 = this.func_110485_a(jsonObject.get("frametime"), "frametime", 1, 1, Integer.MAX_VALUE);
        if (jsonObject.has("frames")) {
            try {
                JsonArray jsonArray = jsonObject.getAsJsonArray("frames");
                for (n = 0; n < jsonArray.size(); ++n) {
                    JsonElement jsonElement = jsonArray.get(n);
                    AnimationFrame animationFrame = this.func_110492_a(n, jsonElement);
                    if (animationFrame == null) continue;
                    arrayList.add(animationFrame);
                }
            }
            catch (ClassCastException classCastException) {
                throw new JsonParseException("Invalid animation->frames: expected array, was " + jsonObject.get("frames"), (Throwable)classCastException);
            }
        }
        int n3 = this.func_110485_a(jsonObject.get("width"), "width", -1, 1, Integer.MAX_VALUE);
        n = this.func_110485_a(jsonObject.get("height"), "height", -1, 1, Integer.MAX_VALUE);
        return new AnimationMetadataSection(arrayList, n3, n, n2);
    }

    private AnimationFrame func_110492_a(int p_110492_1_, JsonElement p_110492_2_) {
        if (p_110492_2_.isJsonPrimitive()) {
            try {
                return new AnimationFrame(p_110492_2_.getAsInt());
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonParseException("Invalid animation->frames->" + p_110492_1_ + ": expected number, was " + p_110492_2_, (Throwable)numberFormatException);
            }
        }
        if (p_110492_2_.isJsonObject()) {
            JsonObject jsonObject = p_110492_2_.getAsJsonObject();
            int n = this.func_110485_a(jsonObject.get("time"), "frames->" + p_110492_1_ + "->time", -1, 1, Integer.MAX_VALUE);
            int n2 = this.func_110485_a(jsonObject.get("index"), "frames->" + p_110492_1_ + "->index", null, 0, Integer.MAX_VALUE);
            return new AnimationFrame(n2, n);
        }
        return null;
    }

    public JsonElement func_110491_a(AnimationMetadataSection p_110491_1_, Type p_110491_2_, JsonSerializationContext p_110491_3_) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("frametime", (Number)p_110491_1_.func_110469_d());
        if (p_110491_1_.func_110474_b() != -1) {
            jsonObject.addProperty("width", (Number)p_110491_1_.func_110474_b());
        }
        if (p_110491_1_.func_110471_a() != -1) {
            jsonObject.addProperty("height", (Number)p_110491_1_.func_110471_a());
        }
        if (p_110491_1_.func_110473_c() > 0) {
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < p_110491_1_.func_110473_c(); ++i) {
                if (p_110491_1_.func_110470_b(i)) {
                    JsonObject jsonObject2 = new JsonObject();
                    jsonObject2.addProperty("index", (Number)p_110491_1_.func_110468_c(i));
                    jsonObject2.addProperty("time", (Number)p_110491_1_.func_110472_a(i));
                    jsonArray.add((JsonElement)jsonObject2);
                    continue;
                }
                jsonArray.add((JsonElement)new JsonPrimitive((Number)p_110491_1_.func_110468_c(i)));
            }
            jsonObject.add("frames", (JsonElement)jsonArray);
        }
        return jsonObject;
    }

    @Override
    public String func_110483_a() {
        return "animation";
    }

    public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) {
        return this.func_110493_a(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
    }

    public /* synthetic */ JsonElement serialize(Object p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
        return this.func_110491_a((AnimationMetadataSection)p_serialize_1_, p_serialize_2_, p_serialize_3_);
    }
}

