/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.scoreboard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScoreObjectiveCriteria;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.EnumChatFormatting;

public class ServerCommandScoreboard
extends CommandBase {
    @Override
    public String func_71517_b() {
        return "scoreboard";
    }

    @Override
    public int func_82362_a() {
        return 2;
    }

    @Override
    public String func_71518_a(ICommandSender p_71518_1_) {
        return "commands.scoreboard.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void func_71515_b(ICommandSender p_71515_1_, String[] p_71515_2_) {
        if (p_71515_2_.length < 1) throw new WrongUsageException("commands.scoreboard.usage", new Object[0]);
        if (p_71515_2_[0].equalsIgnoreCase("objectives")) {
            if (p_71515_2_.length == 1) {
                throw new WrongUsageException("commands.scoreboard.objectives.usage", new Object[0]);
            }
            if (p_71515_2_[1].equalsIgnoreCase("list")) {
                this.func_96336_d(p_71515_1_);
                return;
            } else if (p_71515_2_[1].equalsIgnoreCase("add")) {
                if (p_71515_2_.length < 4) throw new WrongUsageException("commands.scoreboard.objectives.add.usage", new Object[0]);
                this.func_96350_b(p_71515_1_, p_71515_2_, 2);
                return;
            } else if (p_71515_2_[1].equalsIgnoreCase("remove")) {
                if (p_71515_2_.length != 3) throw new WrongUsageException("commands.scoreboard.objectives.remove.usage", new Object[0]);
                this.func_96337_e(p_71515_1_, p_71515_2_[2]);
                return;
            } else {
                if (!p_71515_2_[1].equalsIgnoreCase("setdisplay")) throw new WrongUsageException("commands.scoreboard.objectives.usage", new Object[0]);
                if (p_71515_2_.length != 3 && p_71515_2_.length != 4) throw new WrongUsageException("commands.scoreboard.objectives.setdisplay.usage", new Object[0]);
                this.func_96347_j(p_71515_1_, p_71515_2_, 2);
            }
            return;
        }
        if (p_71515_2_[0].equalsIgnoreCase("players")) {
            if (p_71515_2_.length == 1) {
                throw new WrongUsageException("commands.scoreboard.players.usage", new Object[0]);
            }
            if (p_71515_2_[1].equalsIgnoreCase("list")) {
                if (p_71515_2_.length > 3) throw new WrongUsageException("commands.scoreboard.players.list.usage", new Object[0]);
                this.func_96341_k(p_71515_1_, p_71515_2_, 2);
                return;
            } else if (p_71515_2_[1].equalsIgnoreCase("add")) {
                if (p_71515_2_.length != 5) throw new WrongUsageException("commands.scoreboard.players.add.usage", new Object[0]);
                this.func_96339_l(p_71515_1_, p_71515_2_, 2);
                return;
            } else if (p_71515_2_[1].equalsIgnoreCase("remove")) {
                if (p_71515_2_.length != 5) throw new WrongUsageException("commands.scoreboard.players.remove.usage", new Object[0]);
                this.func_96339_l(p_71515_1_, p_71515_2_, 2);
                return;
            } else if (p_71515_2_[1].equalsIgnoreCase("set")) {
                if (p_71515_2_.length != 5) throw new WrongUsageException("commands.scoreboard.players.set.usage", new Object[0]);
                this.func_96339_l(p_71515_1_, p_71515_2_, 2);
                return;
            } else {
                if (!p_71515_2_[1].equalsIgnoreCase("reset")) throw new WrongUsageException("commands.scoreboard.players.usage", new Object[0]);
                if (p_71515_2_.length != 3) throw new WrongUsageException("commands.scoreboard.players.reset.usage", new Object[0]);
                this.func_96351_m(p_71515_1_, p_71515_2_, 2);
            }
            return;
        }
        if (!p_71515_2_[0].equalsIgnoreCase("teams")) throw new WrongUsageException("commands.scoreboard.usage", new Object[0]);
        if (p_71515_2_.length == 1) {
            throw new WrongUsageException("commands.scoreboard.teams.usage", new Object[0]);
        }
        if (p_71515_2_[1].equalsIgnoreCase("list")) {
            if (p_71515_2_.length > 3) throw new WrongUsageException("commands.scoreboard.teams.list.usage", new Object[0]);
            this.func_96344_f(p_71515_1_, p_71515_2_, 2);
            return;
        } else if (p_71515_2_[1].equalsIgnoreCase("add")) {
            if (p_71515_2_.length < 3) throw new WrongUsageException("commands.scoreboard.teams.add.usage", new Object[0]);
            this.func_96340_c(p_71515_1_, p_71515_2_, 2);
            return;
        } else if (p_71515_2_[1].equalsIgnoreCase("remove")) {
            if (p_71515_2_.length != 3) throw new WrongUsageException("commands.scoreboard.teams.remove.usage", new Object[0]);
            this.func_96343_e(p_71515_1_, p_71515_2_, 2);
            return;
        } else if (p_71515_2_[1].equalsIgnoreCase("empty")) {
            if (p_71515_2_.length != 3) throw new WrongUsageException("commands.scoreboard.teams.empty.usage", new Object[0]);
            this.func_96346_i(p_71515_1_, p_71515_2_, 2);
            return;
        } else if (p_71515_2_[1].equalsIgnoreCase("join")) {
            if (p_71515_2_.length < 4 && (p_71515_2_.length != 3 || !(p_71515_1_ instanceof EntityPlayer))) throw new WrongUsageException("commands.scoreboard.teams.join.usage", new Object[0]);
            this.func_96342_g(p_71515_1_, p_71515_2_, 2);
            return;
        } else if (p_71515_2_[1].equalsIgnoreCase("leave")) {
            if (p_71515_2_.length < 3 && !(p_71515_1_ instanceof EntityPlayer)) throw new WrongUsageException("commands.scoreboard.teams.leave.usage", new Object[0]);
            this.func_96349_h(p_71515_1_, p_71515_2_, 2);
            return;
        } else {
            if (!p_71515_2_[1].equalsIgnoreCase("option")) throw new WrongUsageException("commands.scoreboard.teams.usage", new Object[0]);
            if (p_71515_2_.length != 4 && p_71515_2_.length != 5) throw new WrongUsageException("commands.scoreboard.teams.option.usage", new Object[0]);
            this.func_96348_d(p_71515_1_, p_71515_2_, 2);
        }
    }

    protected Scoreboard func_96334_d() {
        return MinecraftServer.func_71276_C().func_71218_a(0).func_96441_U();
    }

    protected ScoreObjective func_96345_a(String p_96345_1_, boolean p_96345_2_) {
        Scoreboard scoreboard = this.func_96334_d();
        ScoreObjective scoreObjective = scoreboard.func_96518_b(p_96345_1_);
        if (scoreObjective == null) {
            throw new CommandException("commands.scoreboard.objectiveNotFound", p_96345_1_);
        }
        if (p_96345_2_ && scoreObjective.func_96680_c().func_96637_b()) {
            throw new CommandException("commands.scoreboard.objectiveReadOnly", p_96345_1_);
        }
        return scoreObjective;
    }

    protected ScorePlayerTeam func_96338_a(String p_96338_1_) {
        Scoreboard scoreboard = this.func_96334_d();
        ScorePlayerTeam scorePlayerTeam = scoreboard.func_96508_e(p_96338_1_);
        if (scorePlayerTeam == null) {
            throw new CommandException("commands.scoreboard.teamNotFound", p_96338_1_);
        }
        return scorePlayerTeam;
    }

    protected void func_96350_b(ICommandSender p_96350_1_, String[] p_96350_2_, int p_96350_3_) {
        String string = p_96350_2_[p_96350_3_++];
        String string2 = p_96350_2_[p_96350_3_++];
        Scoreboard scoreboard = this.func_96334_d();
        ScoreObjectiveCriteria scoreObjectiveCriteria = (ScoreObjectiveCriteria)ScoreObjectiveCriteria.field_96643_a.get(string2);
        if (scoreObjectiveCriteria == null) {
            Object[] objectArray = ScoreObjectiveCriteria.field_96643_a.keySet().toArray(new String[0]);
            throw new WrongUsageException("commands.scoreboard.objectives.add.wrongType", ServerCommandScoreboard.func_71527_a(objectArray));
        }
        if (scoreboard.func_96518_b(string) != null) {
            throw new CommandException("commands.scoreboard.objectives.add.alreadyExists", string);
        }
        if (string.length() > 16) {
            throw new SyntaxErrorException("commands.scoreboard.objectives.add.tooLong", string, 16);
        }
        if (string.length() == 0) {
            throw new WrongUsageException("commands.scoreboard.objectives.add.usage", new Object[0]);
        }
        if (p_96350_2_.length > p_96350_3_) {
            String string3 = ServerCommandScoreboard.func_82360_a(p_96350_1_, p_96350_2_, p_96350_3_);
            if (string3.length() > 32) {
                throw new SyntaxErrorException("commands.scoreboard.objectives.add.displayTooLong", string3, 32);
            }
            if (string3.length() > 0) {
                scoreboard.func_96535_a(string, scoreObjectiveCriteria).func_96681_a(string3);
            } else {
                scoreboard.func_96535_a(string, scoreObjectiveCriteria);
            }
        } else {
            scoreboard.func_96535_a(string, scoreObjectiveCriteria);
        }
        ServerCommandScoreboard.func_71522_a(p_96350_1_, "commands.scoreboard.objectives.add.success", string);
    }

    protected void func_96340_c(ICommandSender p_96340_1_, String[] p_96340_2_, int p_96340_3_) {
        String string = p_96340_2_[p_96340_3_++];
        Scoreboard scoreboard = this.func_96334_d();
        if (scoreboard.func_96508_e(string) != null) {
            throw new CommandException("commands.scoreboard.teams.add.alreadyExists", string);
        }
        if (string.length() > 16) {
            throw new SyntaxErrorException("commands.scoreboard.teams.add.tooLong", string, 16);
        }
        if (string.length() == 0) {
            throw new WrongUsageException("commands.scoreboard.teams.add.usage", new Object[0]);
        }
        if (p_96340_2_.length > p_96340_3_) {
            String string2 = ServerCommandScoreboard.func_82360_a(p_96340_1_, p_96340_2_, p_96340_3_);
            if (string2.length() > 32) {
                throw new SyntaxErrorException("commands.scoreboard.teams.add.displayTooLong", string2, 32);
            }
            if (string2.length() > 0) {
                scoreboard.func_96527_f(string).func_96664_a(string2);
            } else {
                scoreboard.func_96527_f(string);
            }
        } else {
            scoreboard.func_96527_f(string);
        }
        ServerCommandScoreboard.func_71522_a(p_96340_1_, "commands.scoreboard.teams.add.success", string);
    }

    protected void func_96348_d(ICommandSender p_96348_1_, String[] p_96348_2_, int p_96348_3_) {
        String string;
        ScorePlayerTeam scorePlayerTeam = this.func_96338_a(p_96348_2_[p_96348_3_++]);
        if (!((string = p_96348_2_[p_96348_3_++].toLowerCase()).equalsIgnoreCase("color") || string.equalsIgnoreCase("friendlyfire") || string.equalsIgnoreCase("seeFriendlyInvisibles"))) {
            throw new WrongUsageException("commands.scoreboard.teams.option.usage", new Object[0]);
        }
        if (p_96348_2_.length == 4) {
            if (string.equalsIgnoreCase("color")) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", string, ServerCommandScoreboard.func_96333_a(EnumChatFormatting.func_96296_a(true, false)));
            }
            if (string.equalsIgnoreCase("friendlyfire") || string.equalsIgnoreCase("seeFriendlyInvisibles")) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", string, ServerCommandScoreboard.func_96333_a(Arrays.asList("true", "false")));
            }
            throw new WrongUsageException("commands.scoreboard.teams.option.usage", new Object[0]);
        }
        String string2 = p_96348_2_[p_96348_3_++];
        if (string.equalsIgnoreCase("color")) {
            EnumChatFormatting enumChatFormatting = EnumChatFormatting.func_96300_b(string2);
            if (string2 == null) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", string, ServerCommandScoreboard.func_96333_a(EnumChatFormatting.func_96296_a(true, false)));
            }
            scorePlayerTeam.func_96666_b(enumChatFormatting.toString());
            scorePlayerTeam.func_96662_c(EnumChatFormatting.RESET.toString());
        } else if (string.equalsIgnoreCase("friendlyfire")) {
            if (!string2.equalsIgnoreCase("true") && !string2.equalsIgnoreCase("false")) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", string, ServerCommandScoreboard.func_96333_a(Arrays.asList("true", "false")));
            }
            scorePlayerTeam.func_96660_a(string2.equalsIgnoreCase("true"));
        } else if (string.equalsIgnoreCase("seeFriendlyInvisibles")) {
            if (!string2.equalsIgnoreCase("true") && !string2.equalsIgnoreCase("false")) {
                throw new WrongUsageException("commands.scoreboard.teams.option.noValue", string, ServerCommandScoreboard.func_96333_a(Arrays.asList("true", "false")));
            }
            scorePlayerTeam.func_98300_b(string2.equalsIgnoreCase("true"));
        }
        ServerCommandScoreboard.func_71522_a(p_96348_1_, "commands.scoreboard.teams.option.success", string, scorePlayerTeam.func_96661_b(), string2);
    }

    protected void func_96343_e(ICommandSender p_96343_1_, String[] p_96343_2_, int p_96343_3_) {
        Scoreboard scoreboard = this.func_96334_d();
        ScorePlayerTeam scorePlayerTeam = this.func_96338_a(p_96343_2_[p_96343_3_++]);
        scoreboard.func_96511_d(scorePlayerTeam);
        ServerCommandScoreboard.func_71522_a(p_96343_1_, "commands.scoreboard.teams.remove.success", scorePlayerTeam.func_96661_b());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void func_96344_f(ICommandSender p_96344_1_, String[] p_96344_2_, int p_96344_3_) {
        Scoreboard scoreboard = this.func_96334_d();
        if (p_96344_2_.length > p_96344_3_) {
            ScorePlayerTeam scorePlayerTeam;
            Collection collection;
            if ((collection = (scorePlayerTeam = this.func_96338_a(p_96344_2_[p_96344_3_++])).func_96670_d()).size() <= 0) throw new CommandException("commands.scoreboard.teams.list.player.empty", scorePlayerTeam.func_96661_b());
            p_96344_1_.func_70006_a(ChatMessageComponent.func_111082_b("commands.scoreboard.teams.list.player.count", collection.size(), scorePlayerTeam.func_96661_b()).func_111059_a(EnumChatFormatting.DARK_GREEN));
            p_96344_1_.func_70006_a(ChatMessageComponent.func_111066_d(ServerCommandScoreboard.func_71527_a(collection.toArray())));
            return;
        } else {
            Collection collection = scoreboard.func_96525_g();
            if (collection.size() <= 0) throw new CommandException("commands.scoreboard.teams.list.empty", new Object[0]);
            p_96344_1_.func_70006_a(ChatMessageComponent.func_111082_b("commands.scoreboard.teams.list.count", collection.size()).func_111059_a(EnumChatFormatting.DARK_GREEN));
            for (ScorePlayerTeam scorePlayerTeam : collection) {
                p_96344_1_.func_70006_a(ChatMessageComponent.func_111082_b("commands.scoreboard.teams.list.entry", scorePlayerTeam.func_96661_b(), scorePlayerTeam.func_96669_c(), scorePlayerTeam.func_96670_d().size()));
            }
        }
    }

    protected void func_96342_g(ICommandSender p_96342_1_, String[] p_96342_2_, int p_96342_3_) {
        Scoreboard scoreboard = this.func_96334_d();
        ScorePlayerTeam scorePlayerTeam = scoreboard.func_96508_e(p_96342_2_[p_96342_3_++]);
        HashSet<String> hashSet = new HashSet<String>();
        if (p_96342_1_ instanceof EntityPlayer && p_96342_3_ == p_96342_2_.length) {
            String string = ServerCommandScoreboard.func_71521_c(p_96342_1_).func_70023_ak();
            scoreboard.func_96521_a(string, scorePlayerTeam);
            hashSet.add(string);
        } else {
            while (p_96342_3_ < p_96342_2_.length) {
                String string = ServerCommandScoreboard.func_96332_d(p_96342_1_, p_96342_2_[p_96342_3_++]);
                scoreboard.func_96521_a(string, scorePlayerTeam);
                hashSet.add(string);
            }
        }
        if (!hashSet.isEmpty()) {
            ServerCommandScoreboard.func_71522_a(p_96342_1_, "commands.scoreboard.teams.join.success", hashSet.size(), scorePlayerTeam.func_96661_b(), ServerCommandScoreboard.func_71527_a(hashSet.toArray(new String[0])));
        }
    }

    protected void func_96349_h(ICommandSender p_96349_1_, String[] p_96349_2_, int p_96349_3_) {
        Scoreboard scoreboard = this.func_96334_d();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        if (p_96349_1_ instanceof EntityPlayer && p_96349_3_ == p_96349_2_.length) {
            String string = ServerCommandScoreboard.func_71521_c(p_96349_1_).func_70023_ak();
            if (scoreboard.func_96524_g(string)) {
                hashSet.add(string);
            } else {
                hashSet2.add(string);
            }
        } else {
            while (p_96349_3_ < p_96349_2_.length) {
                String string;
                if (scoreboard.func_96524_g(string = ServerCommandScoreboard.func_96332_d(p_96349_1_, p_96349_2_[p_96349_3_++]))) {
                    hashSet.add(string);
                    continue;
                }
                hashSet2.add(string);
            }
        }
        if (!hashSet.isEmpty()) {
            ServerCommandScoreboard.func_71522_a(p_96349_1_, "commands.scoreboard.teams.leave.success", hashSet.size(), ServerCommandScoreboard.func_71527_a(hashSet.toArray(new String[0])));
        }
        if (!hashSet2.isEmpty()) {
            throw new CommandException("commands.scoreboard.teams.leave.failure", hashSet2.size(), ServerCommandScoreboard.func_71527_a(hashSet2.toArray(new String[0])));
        }
    }

    protected void func_96346_i(ICommandSender p_96346_1_, String[] p_96346_2_, int p_96346_3_) {
        ScorePlayerTeam scorePlayerTeam;
        ArrayList arrayList;
        Scoreboard scoreboard = this.func_96334_d();
        if ((arrayList = new ArrayList((scorePlayerTeam = this.func_96338_a(p_96346_2_[p_96346_3_++])).func_96670_d())).isEmpty()) {
            throw new CommandException("commands.scoreboard.teams.empty.alreadyEmpty", scorePlayerTeam.func_96661_b());
        }
        for (String string : arrayList) {
            scoreboard.func_96512_b(string, scorePlayerTeam);
        }
        ServerCommandScoreboard.func_71522_a(p_96346_1_, "commands.scoreboard.teams.empty.success", arrayList.size(), scorePlayerTeam.func_96661_b());
    }

    protected void func_96337_e(ICommandSender p_96337_1_, String p_96337_2_) {
        Scoreboard scoreboard = this.func_96334_d();
        ScoreObjective scoreObjective = this.func_96345_a(p_96337_2_, false);
        scoreboard.func_96519_k(scoreObjective);
        ServerCommandScoreboard.func_71522_a(p_96337_1_, "commands.scoreboard.objectives.remove.success", p_96337_2_);
    }

    protected void func_96336_d(ICommandSender p_96336_1_) {
        Scoreboard scoreboard = this.func_96334_d();
        Collection collection = scoreboard.func_96514_c();
        if (collection.size() > 0) {
            p_96336_1_.func_70006_a(ChatMessageComponent.func_111082_b("commands.scoreboard.objectives.list.count", collection.size()).func_111059_a(EnumChatFormatting.DARK_GREEN));
            for (ScoreObjective scoreObjective : collection) {
                p_96336_1_.func_70006_a(ChatMessageComponent.func_111082_b("commands.scoreboard.objectives.list.entry", scoreObjective.func_96679_b(), scoreObjective.func_96678_d(), scoreObjective.func_96680_c().func_96636_a()));
            }
        } else {
            throw new CommandException("commands.scoreboard.objectives.list.empty", new Object[0]);
        }
    }

    protected void func_96347_j(ICommandSender p_96347_1_, String[] p_96347_2_, int p_96347_3_) {
        Scoreboard scoreboard = this.func_96334_d();
        String string = p_96347_2_[p_96347_3_++];
        int n = Scoreboard.func_96537_j(string);
        ScoreObjective scoreObjective = null;
        if (p_96347_2_.length == 4) {
            scoreObjective = this.func_96345_a(p_96347_2_[p_96347_3_++], false);
        }
        if (n < 0) {
            throw new CommandException("commands.scoreboard.objectives.setdisplay.invalidSlot", string);
        }
        scoreboard.func_96530_a(n, scoreObjective);
        if (scoreObjective != null) {
            ServerCommandScoreboard.func_71522_a(p_96347_1_, "commands.scoreboard.objectives.setdisplay.successSet", Scoreboard.func_96517_b(n), scoreObjective.func_96679_b());
        } else {
            ServerCommandScoreboard.func_71522_a(p_96347_1_, "commands.scoreboard.objectives.setdisplay.successCleared", Scoreboard.func_96517_b(n));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void func_96341_k(ICommandSender p_96341_1_, String[] p_96341_2_, int p_96341_3_) {
        Scoreboard scoreboard = this.func_96334_d();
        if (p_96341_2_.length > p_96341_3_) {
            String string;
            Map map;
            if ((map = scoreboard.func_96510_d(string = ServerCommandScoreboard.func_96332_d(p_96341_1_, p_96341_2_[p_96341_3_++]))).size() <= 0) throw new CommandException("commands.scoreboard.players.list.player.empty", string);
            p_96341_1_.func_70006_a(ChatMessageComponent.func_111082_b("commands.scoreboard.players.list.player.count", map.size(), string).func_111059_a(EnumChatFormatting.DARK_GREEN));
            for (Score score : map.values()) {
                p_96341_1_.func_70006_a(ChatMessageComponent.func_111082_b("commands.scoreboard.players.list.player.entry", score.func_96652_c(), score.func_96645_d().func_96678_d(), score.func_96645_d().func_96679_b()));
            }
            return;
        } else {
            Collection collection = scoreboard.func_96526_d();
            if (collection.size() <= 0) throw new CommandException("commands.scoreboard.players.list.empty", new Object[0]);
            p_96341_1_.func_70006_a(ChatMessageComponent.func_111082_b("commands.scoreboard.players.list.count", collection.size()).func_111059_a(EnumChatFormatting.DARK_GREEN));
            p_96341_1_.func_70006_a(ChatMessageComponent.func_111066_d(ServerCommandScoreboard.func_71527_a(collection.toArray())));
        }
    }

    protected void func_96339_l(ICommandSender p_96339_1_, String[] p_96339_2_, int p_96339_3_) {
        String string = p_96339_2_[p_96339_3_ - 1];
        String string2 = ServerCommandScoreboard.func_96332_d(p_96339_1_, p_96339_2_[p_96339_3_++]);
        ScoreObjective scoreObjective = this.func_96345_a(p_96339_2_[p_96339_3_++], true);
        int n = string.equalsIgnoreCase("set") ? ServerCommandScoreboard.func_71526_a(p_96339_1_, p_96339_2_[p_96339_3_++]) : ServerCommandScoreboard.func_71528_a(p_96339_1_, p_96339_2_[p_96339_3_++], 1);
        Scoreboard scoreboard = this.func_96334_d();
        Score score = scoreboard.func_96529_a(string2, scoreObjective);
        if (string.equalsIgnoreCase("set")) {
            score.func_96647_c(n);
        } else if (string.equalsIgnoreCase("add")) {
            score.func_96649_a(n);
        } else {
            score.func_96646_b(n);
        }
        ServerCommandScoreboard.func_71522_a(p_96339_1_, "commands.scoreboard.players.set.success", scoreObjective.func_96679_b(), string2, score.func_96652_c());
    }

    protected void func_96351_m(ICommandSender p_96351_1_, String[] p_96351_2_, int p_96351_3_) {
        Scoreboard scoreboard = this.func_96334_d();
        String string = ServerCommandScoreboard.func_96332_d(p_96351_1_, p_96351_2_[p_96351_3_++]);
        scoreboard.func_96515_c(string);
        ServerCommandScoreboard.func_71522_a(p_96351_1_, "commands.scoreboard.players.reset.success", string);
    }

    @Override
    public List func_71516_a(ICommandSender p_71516_1_, String[] p_71516_2_) {
        if (p_71516_2_.length == 1) {
            return ServerCommandScoreboard.func_71530_a(p_71516_2_, "objectives", "players", "teams");
        }
        if (p_71516_2_[0].equalsIgnoreCase("objectives")) {
            if (p_71516_2_.length == 2) {
                return ServerCommandScoreboard.func_71530_a(p_71516_2_, "list", "add", "remove", "setdisplay");
            }
            if (p_71516_2_[1].equalsIgnoreCase("add")) {
                if (p_71516_2_.length == 4) {
                    return ServerCommandScoreboard.func_71531_a(p_71516_2_, ScoreObjectiveCriteria.field_96643_a.keySet());
                }
            } else if (p_71516_2_[1].equalsIgnoreCase("remove")) {
                if (p_71516_2_.length == 3) {
                    return ServerCommandScoreboard.func_71531_a(p_71516_2_, this.func_96335_a(false));
                }
            } else if (p_71516_2_[1].equalsIgnoreCase("setdisplay")) {
                if (p_71516_2_.length == 3) {
                    return ServerCommandScoreboard.func_71530_a(p_71516_2_, "list", "sidebar", "belowName");
                }
                if (p_71516_2_.length == 4) {
                    return ServerCommandScoreboard.func_71531_a(p_71516_2_, this.func_96335_a(false));
                }
            }
        } else if (p_71516_2_[0].equalsIgnoreCase("players")) {
            if (p_71516_2_.length == 2) {
                return ServerCommandScoreboard.func_71530_a(p_71516_2_, "set", "add", "remove", "reset", "list");
            }
            if (p_71516_2_[1].equalsIgnoreCase("set") || p_71516_2_[1].equalsIgnoreCase("add") || p_71516_2_[1].equalsIgnoreCase("remove")) {
                if (p_71516_2_.length == 3) {
                    return ServerCommandScoreboard.func_71530_a(p_71516_2_, MinecraftServer.func_71276_C().func_71213_z());
                }
                if (p_71516_2_.length == 4) {
                    return ServerCommandScoreboard.func_71531_a(p_71516_2_, this.func_96335_a(true));
                }
            } else if ((p_71516_2_[1].equalsIgnoreCase("reset") || p_71516_2_[1].equalsIgnoreCase("list")) && p_71516_2_.length == 3) {
                return ServerCommandScoreboard.func_71531_a(p_71516_2_, this.func_96334_d().func_96526_d());
            }
        } else if (p_71516_2_[0].equalsIgnoreCase("teams")) {
            if (p_71516_2_.length == 2) {
                return ServerCommandScoreboard.func_71530_a(p_71516_2_, "add", "remove", "join", "leave", "empty", "list", "option");
            }
            if (p_71516_2_[1].equalsIgnoreCase("join")) {
                if (p_71516_2_.length == 3) {
                    return ServerCommandScoreboard.func_71531_a(p_71516_2_, this.func_96334_d().func_96531_f());
                }
                if (p_71516_2_.length >= 4) {
                    return ServerCommandScoreboard.func_71530_a(p_71516_2_, MinecraftServer.func_71276_C().func_71213_z());
                }
            } else {
                if (p_71516_2_[1].equalsIgnoreCase("leave")) {
                    return ServerCommandScoreboard.func_71530_a(p_71516_2_, MinecraftServer.func_71276_C().func_71213_z());
                }
                if (p_71516_2_[1].equalsIgnoreCase("empty") || p_71516_2_[1].equalsIgnoreCase("list") || p_71516_2_[1].equalsIgnoreCase("remove")) {
                    if (p_71516_2_.length == 3) {
                        return ServerCommandScoreboard.func_71531_a(p_71516_2_, this.func_96334_d().func_96531_f());
                    }
                } else if (p_71516_2_[1].equalsIgnoreCase("option")) {
                    if (p_71516_2_.length == 3) {
                        return ServerCommandScoreboard.func_71531_a(p_71516_2_, this.func_96334_d().func_96531_f());
                    }
                    if (p_71516_2_.length == 4) {
                        return ServerCommandScoreboard.func_71530_a(p_71516_2_, "color", "friendlyfire", "seeFriendlyInvisibles");
                    }
                    if (p_71516_2_.length == 5) {
                        if (p_71516_2_[3].equalsIgnoreCase("color")) {
                            return ServerCommandScoreboard.func_71531_a(p_71516_2_, EnumChatFormatting.func_96296_a(true, false));
                        }
                        if (p_71516_2_[3].equalsIgnoreCase("friendlyfire") || p_71516_2_[3].equalsIgnoreCase("seeFriendlyInvisibles")) {
                            return ServerCommandScoreboard.func_71530_a(p_71516_2_, "true", "false");
                        }
                    }
                }
            }
        }
        return null;
    }

    protected List func_96335_a(boolean p_96335_1_) {
        Collection collection = this.func_96334_d().func_96514_c();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ScoreObjective scoreObjective : collection) {
            if (p_96335_1_ && scoreObjective.func_96680_c().func_96637_b()) continue;
            arrayList.add(scoreObjective.func_96679_b());
        }
        return arrayList;
    }

    @Override
    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        if (p_82358_1_[0].equalsIgnoreCase("players")) {
            return p_82358_2_ == 2;
        }
        if (p_82358_1_[0].equalsIgnoreCase("teams")) {
            return p_82358_2_ == 2 || p_82358_2_ == 3;
        }
        return false;
    }
}

