/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.text.Bidi;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.client.resources.ResourceManagerReloadListener;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FontRenderer
implements ResourceManagerReloadListener {
    private static final ResourceLocation[] field_111274_c = new ResourceLocation[256];
    private int[] field_78286_d = new int[256];
    public int field_78288_b = 9;
    public Random field_78289_c = new Random();
    private byte[] field_78287_e = new byte[65536];
    private int[] field_78285_g = new int[32];
    private final ResourceLocation field_111273_g;
    private final TextureManager field_78298_i;
    private float field_78295_j;
    private float field_78296_k;
    private boolean field_78293_l;
    private boolean field_78294_m;
    private float field_78291_n;
    private float field_78292_o;
    private float field_78306_p;
    private float field_78305_q;
    private int field_78304_r;
    private boolean field_78303_s;
    private boolean field_78302_t;
    private boolean field_78301_u;
    private boolean field_78300_v;
    private boolean field_78299_w;

    public FontRenderer(GameSettings p_i1035_1_, ResourceLocation p_i1035_2_, TextureManager p_i1035_3_, boolean p_i1035_4_) {
        this.field_111273_g = p_i1035_2_;
        this.field_78298_i = p_i1035_3_;
        this.field_78293_l = p_i1035_4_;
        p_i1035_3_.func_110577_a(this.field_111273_g);
        for (int i = 0; i < 32; ++i) {
            int n = (i >> 3 & 1) * 85;
            int n2 = (i >> 2 & 1) * 170 + n;
            int n3 = (i >> 1 & 1) * 170 + n;
            int n4 = (i >> 0 & 1) * 170 + n;
            if (i == 6) {
                n2 += 85;
            }
            if (p_i1035_1_.field_74337_g) {
                int n5 = (n2 * 30 + n3 * 59 + n4 * 11) / 100;
                int n6 = (n2 * 30 + n3 * 70) / 100;
                int n7 = (n2 * 30 + n4 * 70) / 100;
                n2 = n5;
                n3 = n6;
                n4 = n7;
            }
            if (i >= 16) {
                n2 /= 4;
                n3 /= 4;
                n4 /= 4;
            }
            this.field_78285_g[i] = (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
        }
        this.func_98306_d();
    }

    @Override
    public void func_110549_a(ResourceManager p_110549_1_) {
        this.func_111272_d();
    }

    private void func_111272_d() {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(this.field_111273_g).func_110527_b());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        bufferedImage.getRGB(0, 0, n, n2, nArray, 0, n);
        int n3 = n2 / 16;
        int n4 = n / 16;
        int n5 = 1;
        float f = 8.0f / (float)n4;
        for (int i = 0; i < 256; ++i) {
            int n6;
            int n7 = i % 16;
            int n8 = i / 16;
            if (i == 32) {
                this.field_78286_d[i] = 3 + n5;
            }
            for (n6 = n4 - 1; n6 >= 0; --n6) {
                int n9 = n7 * n4 + n6;
                boolean bl = true;
                for (int j = 0; j < n3 && bl; ++j) {
                    int n10 = (n8 * n4 + j) * n;
                    if ((nArray[n9 + n10] >> 24 & 0xFF) == 0) continue;
                    bl = false;
                }
                if (!bl) break;
            }
            this.field_78286_d[i] = (int)(0.5 + (double)((float)(++n6) * f)) + n5;
        }
    }

    private void func_98306_d() {
        try {
            InputStream inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("font/glyph_sizes.bin")).func_110527_b();
            inputStream.read(this.field_78287_e);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private float func_78278_a(int p_78278_1_, char p_78278_2_, boolean p_78278_3_) {
        if (p_78278_2_ == ' ') {
            return 4.0f;
        }
        if (p_78278_1_ > 0 && !this.field_78293_l) {
            return this.func_78266_a(p_78278_1_ + 32, p_78278_3_);
        }
        return this.func_78277_a(p_78278_2_, p_78278_3_);
    }

    private float func_78266_a(int p_78266_1_, boolean p_78266_2_) {
        float f = p_78266_1_ % 16 * 8;
        float f2 = p_78266_1_ / 16 * 8;
        float f3 = p_78266_2_ ? 1.0f : 0.0f;
        this.field_78298_i.func_110577_a(this.field_111273_g);
        float f4 = (float)this.field_78286_d[p_78266_1_] - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)(f2 / 128.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f3), (float)this.field_78296_k, (float)0.0f);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)((f2 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.field_78295_j - f3), (float)(this.field_78296_k + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f + f4 - 1.0f) / 128.0f), (float)(f2 / 128.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f4 - 1.0f + f3), (float)this.field_78296_k, (float)0.0f);
        GL11.glTexCoord2f((float)((f + f4 - 1.0f) / 128.0f), (float)((f2 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f4 - 1.0f - f3), (float)(this.field_78296_k + 7.99f), (float)0.0f);
        GL11.glEnd();
        return this.field_78286_d[p_78266_1_];
    }

    private ResourceLocation func_111271_a(int p_111271_1_) {
        if (field_111274_c[p_111271_1_] == null) {
            FontRenderer.field_111274_c[p_111271_1_] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", p_111271_1_));
        }
        return field_111274_c[p_111271_1_];
    }

    private void func_78257_a(int p_78257_1_) {
        this.field_78298_i.func_110577_a(this.func_111271_a(p_78257_1_));
    }

    private float func_78277_a(char p_78277_1_, boolean p_78277_2_) {
        if (this.field_78287_e[p_78277_1_] == 0) {
            return 0.0f;
        }
        int n = p_78277_1_ / 256;
        this.func_78257_a(n);
        int n2 = this.field_78287_e[p_78277_1_] >>> 4;
        int n3 = this.field_78287_e[p_78277_1_] & 0xF;
        float f = n2;
        float f2 = n3 + 1;
        float f3 = (float)(p_78277_1_ % 16 * 16) + f;
        float f4 = (p_78277_1_ & 0xFF) / 16 * 16;
        float f5 = f2 - f - 0.02f;
        float f6 = p_78277_2_ ? 1.0f : 0.0f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f3 / 256.0f), (float)(f4 / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f6), (float)this.field_78296_k, (float)0.0f);
        GL11.glTexCoord2f((float)(f3 / 256.0f), (float)((f4 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j - f6), (float)(this.field_78296_k + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f3 + f5) / 256.0f), (float)(f4 / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f5 / 2.0f + f6), (float)this.field_78296_k, (float)0.0f);
        GL11.glTexCoord2f((float)((f3 + f5) / 256.0f), (float)((f4 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.field_78295_j + f5 / 2.0f - f6), (float)(this.field_78296_k + 7.99f), (float)0.0f);
        GL11.glEnd();
        return (f2 - f) / 2.0f + 1.0f;
    }

    public int func_78261_a(String p_78261_1_, int p_78261_2_, int p_78261_3_, int p_78261_4_) {
        return this.func_85187_a(p_78261_1_, p_78261_2_, p_78261_3_, p_78261_4_, true);
    }

    public int func_78276_b(String p_78276_1_, int p_78276_2_, int p_78276_3_, int p_78276_4_) {
        return this.func_85187_a(p_78276_1_, p_78276_2_, p_78276_3_, p_78276_4_, false);
    }

    public int func_85187_a(String p_85187_1_, int p_85187_2_, int p_85187_3_, int p_85187_4_, boolean p_85187_5_) {
        int n;
        this.func_78265_b();
        if (this.field_78294_m) {
            p_85187_1_ = this.func_78283_c(p_85187_1_);
        }
        if (p_85187_5_) {
            n = this.func_78258_a(p_85187_1_, p_85187_2_ + 1, p_85187_3_ + 1, p_85187_4_, true);
            n = Math.max(n, this.func_78258_a(p_85187_1_, p_85187_2_, p_85187_3_, p_85187_4_, false));
        } else {
            n = this.func_78258_a(p_85187_1_, p_85187_2_, p_85187_3_, p_85187_4_, false);
        }
        return n;
    }

    private String func_78283_c(String p_78283_1_) {
        int n;
        int n2;
        if (p_78283_1_ == null || !Bidi.requiresBidi(p_78283_1_.toCharArray(), 0, p_78283_1_.length())) {
            return p_78283_1_;
        }
        Bidi bidi = new Bidi(p_78283_1_, -2);
        byte[] byArray = new byte[bidi.getRunCount()];
        Object[] objectArray = new String[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            int n3 = bidi.getRunStart(i);
            n2 = bidi.getRunLimit(i);
            n = bidi.getRunLevel(i);
            String string = p_78283_1_.substring(n3, n2);
            byArray[i] = (byte)n;
            objectArray[i] = string;
        }
        String[] stringArray = (String[])objectArray.clone();
        Bidi.reorderVisually(byArray, 0, objectArray, 0, byArray.length);
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            int n4;
            n = byArray[n2];
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                if (!stringArray[n4].equals(objectArray[n2])) continue;
                n = byArray[n4];
                break;
            }
            if ((n & 1) == 0) {
                stringBuilder.append((String)objectArray[n2]);
                continue;
            }
            for (n4 = ((String)objectArray[n2]).length() - 1; n4 >= 0; --n4) {
                char c = ((String)objectArray[n2]).charAt(n4);
                if (c == '(') {
                    c = ')';
                } else if (c == ')') {
                    c = '(';
                }
                stringBuilder.append(c);
            }
        }
        return stringBuilder.toString();
    }

    private void func_78265_b() {
        this.field_78303_s = false;
        this.field_78302_t = false;
        this.field_78301_u = false;
        this.field_78300_v = false;
        this.field_78299_w = false;
    }

    private void func_78255_a(String p_78255_1_, boolean p_78255_2_) {
        for (int i = 0; i < p_78255_1_.length(); ++i) {
            Tessellator tessellator;
            boolean bl;
            int n;
            int n2;
            char c = p_78255_1_.charAt(i);
            if (c == '\u00a7' && i + 1 < p_78255_1_.length()) {
                n2 = "0123456789abcdefklmnor".indexOf(p_78255_1_.toLowerCase().charAt(i + 1));
                if (n2 < 16) {
                    this.field_78303_s = false;
                    this.field_78302_t = false;
                    this.field_78299_w = false;
                    this.field_78300_v = false;
                    this.field_78301_u = false;
                    if (n2 < 0 || n2 > 15) {
                        n2 = 15;
                    }
                    if (p_78255_2_) {
                        n2 += 16;
                    }
                    this.field_78304_r = n = this.field_78285_g[n2];
                    GL11.glColor4f((float)((float)(n >> 16) / 255.0f), (float)((float)(n >> 8 & 0xFF) / 255.0f), (float)((float)(n & 0xFF) / 255.0f), (float)this.field_78305_q);
                } else if (n2 == 16) {
                    this.field_78303_s = true;
                } else if (n2 == 17) {
                    this.field_78302_t = true;
                } else if (n2 == 18) {
                    this.field_78299_w = true;
                } else if (n2 == 19) {
                    this.field_78300_v = true;
                } else if (n2 == 20) {
                    this.field_78301_u = true;
                } else if (n2 == 21) {
                    this.field_78303_s = false;
                    this.field_78302_t = false;
                    this.field_78299_w = false;
                    this.field_78300_v = false;
                    this.field_78301_u = false;
                    GL11.glColor4f((float)this.field_78291_n, (float)this.field_78292_o, (float)this.field_78306_p, (float)this.field_78305_q);
                }
                ++i;
                continue;
            }
            n2 = ChatAllowedCharacters.field_71568_a.indexOf(c);
            if (this.field_78303_s && n2 > 0) {
                while (this.field_78286_d[n2 + 32] != this.field_78286_d[(n = this.field_78289_c.nextInt(ChatAllowedCharacters.field_71568_a.length())) + 32]) {
                }
                n2 = n;
            }
            float f = this.field_78293_l ? 0.5f : 1.0f;
            boolean bl2 = bl = (n2 <= 0 || this.field_78293_l) && p_78255_2_;
            if (bl) {
                this.field_78295_j -= f;
                this.field_78296_k -= f;
            }
            float f2 = this.func_78278_a(n2, c, this.field_78301_u);
            if (bl) {
                this.field_78295_j += f;
                this.field_78296_k += f;
            }
            if (this.field_78302_t) {
                this.field_78295_j += f;
                if (bl) {
                    this.field_78295_j -= f;
                    this.field_78296_k -= f;
                }
                this.func_78278_a(n2, c, this.field_78301_u);
                this.field_78295_j -= f;
                if (bl) {
                    this.field_78295_j += f;
                    this.field_78296_k += f;
                }
                f2 += 1.0f;
            }
            if (this.field_78299_w) {
                tessellator = Tessellator.field_78398_a;
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                tessellator.func_78377_a(this.field_78295_j, this.field_78296_k + (float)(this.field_78288_b / 2), 0.0);
                tessellator.func_78377_a(this.field_78295_j + f2, this.field_78296_k + (float)(this.field_78288_b / 2), 0.0);
                tessellator.func_78377_a(this.field_78295_j + f2, this.field_78296_k + (float)(this.field_78288_b / 2) - 1.0f, 0.0);
                tessellator.func_78377_a(this.field_78295_j, this.field_78296_k + (float)(this.field_78288_b / 2) - 1.0f, 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
            if (this.field_78300_v) {
                tessellator = Tessellator.field_78398_a;
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                int n3 = this.field_78300_v ? -1 : 0;
                tessellator.func_78377_a(this.field_78295_j + (float)n3, this.field_78296_k + (float)this.field_78288_b, 0.0);
                tessellator.func_78377_a(this.field_78295_j + f2, this.field_78296_k + (float)this.field_78288_b, 0.0);
                tessellator.func_78377_a(this.field_78295_j + f2, this.field_78296_k + (float)this.field_78288_b - 1.0f, 0.0);
                tessellator.func_78377_a(this.field_78295_j + (float)n3, this.field_78296_k + (float)this.field_78288_b - 1.0f, 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
            this.field_78295_j += (float)((int)f2);
        }
    }

    private int func_78274_b(String p_78274_1_, int p_78274_2_, int p_78274_3_, int p_78274_4_, int p_78274_5_, boolean p_78274_6_) {
        if (this.field_78294_m) {
            p_78274_1_ = this.func_78283_c(p_78274_1_);
            int n = this.func_78256_a(p_78274_1_);
            p_78274_2_ = p_78274_2_ + p_78274_4_ - n;
        }
        return this.func_78258_a(p_78274_1_, p_78274_2_, p_78274_3_, p_78274_5_, p_78274_6_);
    }

    private int func_78258_a(String p_78258_1_, int p_78258_2_, int p_78258_3_, int p_78258_4_, boolean p_78258_5_) {
        if (p_78258_1_ == null) {
            return 0;
        }
        if ((p_78258_4_ & 0xFC000000) == 0) {
            p_78258_4_ |= 0xFF000000;
        }
        if (p_78258_5_) {
            p_78258_4_ = (p_78258_4_ & 0xFCFCFC) >> 2 | p_78258_4_ & 0xFF000000;
        }
        this.field_78291_n = (float)(p_78258_4_ >> 16 & 0xFF) / 255.0f;
        this.field_78292_o = (float)(p_78258_4_ >> 8 & 0xFF) / 255.0f;
        this.field_78306_p = (float)(p_78258_4_ & 0xFF) / 255.0f;
        this.field_78305_q = (float)(p_78258_4_ >> 24 & 0xFF) / 255.0f;
        GL11.glColor4f((float)this.field_78291_n, (float)this.field_78292_o, (float)this.field_78306_p, (float)this.field_78305_q);
        this.field_78295_j = p_78258_2_;
        this.field_78296_k = p_78258_3_;
        this.func_78255_a(p_78258_1_, p_78258_5_);
        return (int)this.field_78295_j;
    }

    public int func_78256_a(String p_78256_1_) {
        if (p_78256_1_ == null) {
            return 0;
        }
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < p_78256_1_.length(); ++i) {
            char c = p_78256_1_.charAt(i);
            int n2 = this.func_78263_a(c);
            if (n2 < 0 && i < p_78256_1_.length() - 1) {
                if ((c = p_78256_1_.charAt(++i)) == 'l' || c == 'L') {
                    bl = true;
                } else if (c == 'r' || c == 'R') {
                    bl = false;
                }
                n2 = 0;
            }
            n += n2;
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public int func_78263_a(char p_78263_1_) {
        if (p_78263_1_ == '\u00a7') {
            return -1;
        }
        if (p_78263_1_ == ' ') {
            return 4;
        }
        int n = ChatAllowedCharacters.field_71568_a.indexOf(p_78263_1_);
        if (n >= 0 && !this.field_78293_l) {
            return this.field_78286_d[n + 32];
        }
        if (this.field_78287_e[p_78263_1_] != 0) {
            int n2 = this.field_78287_e[p_78263_1_] >>> 4;
            int n3 = this.field_78287_e[p_78263_1_] & 0xF;
            if (n3 > 7) {
                n3 = 15;
                n2 = 0;
            }
            return (++n3 - n2) / 2 + 1;
        }
        return 0;
    }

    public String func_78269_a(String p_78269_1_, int p_78269_2_) {
        return this.func_78262_a(p_78269_1_, p_78269_2_, false);
    }

    public String func_78262_a(String p_78262_1_, int p_78262_2_, boolean p_78262_3_) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = p_78262_3_ ? p_78262_1_.length() - 1 : 0;
        int n3 = p_78262_3_ ? -1 : 1;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = n2; i >= 0 && i < p_78262_1_.length() && n < p_78262_2_; i += n3) {
            char c = p_78262_1_.charAt(i);
            int n4 = this.func_78263_a(c);
            if (bl) {
                bl = false;
                if (c == 'l' || c == 'L') {
                    bl2 = true;
                } else if (c == 'r' || c == 'R') {
                    bl2 = false;
                }
            } else if (n4 < 0) {
                bl = true;
            } else {
                n += n4;
                if (bl2) {
                    ++n;
                }
            }
            if (n > p_78262_2_) break;
            if (p_78262_3_) {
                stringBuilder.insert(0, c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private String func_78273_d(String p_78273_1_) {
        while (p_78273_1_ != null && p_78273_1_.endsWith("\n")) {
            p_78273_1_ = p_78273_1_.substring(0, p_78273_1_.length() - 1);
        }
        return p_78273_1_;
    }

    public void func_78279_b(String p_78279_1_, int p_78279_2_, int p_78279_3_, int p_78279_4_, int p_78279_5_) {
        this.func_78265_b();
        this.field_78304_r = p_78279_5_;
        p_78279_1_ = this.func_78273_d(p_78279_1_);
        this.func_78268_b(p_78279_1_, p_78279_2_, p_78279_3_, p_78279_4_, false);
    }

    private void func_78268_b(String p_78268_1_, int p_78268_2_, int p_78268_3_, int p_78268_4_, boolean p_78268_5_) {
        List list = this.func_78271_c(p_78268_1_, p_78268_4_);
        for (String string : list) {
            this.func_78274_b(string, p_78268_2_, p_78268_3_, p_78268_4_, this.field_78304_r, p_78268_5_);
            p_78268_3_ += this.field_78288_b;
        }
    }

    public int func_78267_b(String p_78267_1_, int p_78267_2_) {
        return this.field_78288_b * this.func_78271_c(p_78267_1_, p_78267_2_).size();
    }

    public void func_78264_a(boolean p_78264_1_) {
        this.field_78293_l = p_78264_1_;
    }

    public boolean func_82883_a() {
        return this.field_78293_l;
    }

    public void func_78275_b(boolean p_78275_1_) {
        this.field_78294_m = p_78275_1_;
    }

    public List func_78271_c(String p_78271_1_, int p_78271_2_) {
        return Arrays.asList(this.func_78280_d(p_78271_1_, p_78271_2_).split("\n"));
    }

    String func_78280_d(String p_78280_1_, int p_78280_2_) {
        int n = this.func_78259_e(p_78280_1_, p_78280_2_);
        if (p_78280_1_.length() <= n) {
            return p_78280_1_;
        }
        String string = p_78280_1_.substring(0, n);
        char c = p_78280_1_.charAt(n);
        boolean bl = c == ' ' || c == '\n';
        String string2 = FontRenderer.func_78282_e(string) + p_78280_1_.substring(n + (bl ? 1 : 0));
        return string + "\n" + this.func_78280_d(string2, p_78280_2_);
    }

    private int func_78259_e(String p_78259_1_, int p_78259_2_) {
        int n;
        int n2 = p_78259_1_.length();
        int n3 = 0;
        int n4 = -1;
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            char c = p_78259_1_.charAt(n);
            switch (c) {
                case '\u00a7': {
                    char c2;
                    if (n >= n2 - 1) break;
                    if ((c2 = p_78259_1_.charAt(++n)) == 'l' || c2 == 'L') {
                        bl = true;
                        break;
                    }
                    if (c2 != 'r' && c2 != 'R' && !FontRenderer.func_78272_b(c2)) break;
                    bl = false;
                    break;
                }
                case '\n': {
                    --n;
                    break;
                }
                case ' ': {
                    n4 = n;
                }
                default: {
                    n3 += this.func_78263_a(c);
                    if (!bl) break;
                    ++n3;
                }
            }
            if (c == '\n') {
                n4 = ++n;
                break;
            }
            if (n3 > p_78259_2_) break;
        }
        if (n != n2 && n4 != -1 && n4 < n) {
            return n4;
        }
        return n;
    }

    private static boolean func_78272_b(char p_78272_0_) {
        return p_78272_0_ >= '0' && p_78272_0_ <= '9' || p_78272_0_ >= 'a' && p_78272_0_ <= 'f' || p_78272_0_ >= 'A' && p_78272_0_ <= 'F';
    }

    private static boolean func_78270_c(char p_78270_0_) {
        return p_78270_0_ >= 'k' && p_78270_0_ <= 'o' || p_78270_0_ >= 'K' && p_78270_0_ <= 'O' || p_78270_0_ == 'r' || p_78270_0_ == 'R';
    }

    private static String func_78282_e(String p_78282_0_) {
        String string = "";
        int n = -1;
        int n2 = p_78282_0_.length();
        while ((n = p_78282_0_.indexOf(167, n + 1)) != -1) {
            if (n >= n2 - 1) continue;
            char c = p_78282_0_.charAt(n + 1);
            if (FontRenderer.func_78272_b(c)) {
                string = "\u00a7" + c;
                continue;
            }
            if (!FontRenderer.func_78270_c(c)) continue;
            string = string + "\u00a7" + c;
        }
        return string;
    }

    public boolean func_78260_a() {
        return this.field_78294_m;
    }
}

