/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class Chunk {
    public static boolean field_76640_a;
    private ExtendedBlockStorage[] field_76652_q = new ExtendedBlockStorage[16];
    private byte[] field_76651_r = new byte[256];
    public int[] field_76638_b = new int[256];
    public boolean[] field_76639_c = new boolean[256];
    public boolean field_76636_d;
    public World field_76637_e;
    public int[] field_76634_f;
    public final int field_76635_g;
    public final int field_76647_h;
    private boolean field_76650_s;
    public Map field_76648_i = new HashMap();
    public List[] field_76645_j = new List[16];
    public boolean field_76646_k;
    public boolean field_76643_l;
    public boolean field_76644_m;
    public long field_76641_n;
    public boolean field_76642_o;
    public int field_82912_p;
    public long field_111204_q;
    private int field_76649_t = 4096;

    public Chunk(World p_i1995_1_, int p_i1995_2_, int p_i1995_3_) {
        this.field_76637_e = p_i1995_1_;
        this.field_76635_g = p_i1995_2_;
        this.field_76647_h = p_i1995_3_;
        this.field_76634_f = new int[256];
        for (int i = 0; i < this.field_76645_j.length; ++i) {
            this.field_76645_j[i] = new ArrayList();
        }
        Arrays.fill(this.field_76638_b, -999);
        Arrays.fill(this.field_76651_r, (byte)-1);
    }

    public Chunk(World p_i1996_1_, byte[] p_i1996_2_, int p_i1996_3_, int p_i1996_4_) {
        this(p_i1996_1_, p_i1996_3_, p_i1996_4_);
        int n = p_i1996_2_.length / 256;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < n; ++k) {
                    byte by = p_i1996_2_[i << 11 | j << 7 | k];
                    if (by == 0) continue;
                    int n2 = k >> 4;
                    if (this.field_76652_q[n2] == null) {
                        this.field_76652_q[n2] = new ExtendedBlockStorage(n2 << 4, !p_i1996_1_.field_73011_w.field_76576_e);
                    }
                    this.field_76652_q[n2].func_76655_a(i, k & 0xF, j, by);
                }
            }
        }
    }

    public boolean func_76600_a(int p_76600_1_, int p_76600_2_) {
        return p_76600_1_ == this.field_76635_g && p_76600_2_ == this.field_76647_h;
    }

    public int func_76611_b(int p_76611_1_, int p_76611_2_) {
        return this.field_76634_f[p_76611_2_ << 4 | p_76611_1_];
    }

    public int func_76625_h() {
        for (int i = this.field_76652_q.length - 1; i >= 0; --i) {
            if (this.field_76652_q[i] == null) continue;
            return this.field_76652_q[i].func_76662_d();
        }
        return 0;
    }

    public ExtendedBlockStorage[] func_76587_i() {
        return this.field_76652_q;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_76590_a() {
        int n = this.func_76625_h();
        for (int i = 0; i < 16; ++i) {
            block1: for (int j = 0; j < 16; ++j) {
                this.field_76638_b[i + (j << 4)] = -999;
                for (int k = n + 16 - 1; k > 0; --k) {
                    int n2 = this.func_76610_a(i, k - 1, j);
                    if (Block.field_71971_o[n2] == 0) continue;
                    this.field_76634_f[j << 4 | i] = k;
                    continue block1;
                }
            }
        }
        this.field_76643_l = true;
    }

    public void func_76603_b() {
        int n;
        int n2;
        int n3 = this.func_76625_h();
        this.field_82912_p = Integer.MAX_VALUE;
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                int n4;
                this.field_76638_b[n2 + (n << 4)] = -999;
                for (n4 = n3 + 16 - 1; n4 > 0; --n4) {
                    if (this.func_76596_b(n2, n4 - 1, n) == 0) continue;
                    this.field_76634_f[n << 4 | n2] = n4;
                    if (n4 >= this.field_82912_p) break;
                    this.field_82912_p = n4;
                    break;
                }
                if (this.field_76637_e.field_73011_w.field_76576_e) continue;
                n4 = 15;
                int n5 = n3 + 16 - 1;
                do {
                    ExtendedBlockStorage extendedBlockStorage;
                    if ((n4 -= this.func_76596_b(n2, n5, n)) <= 0 || (extendedBlockStorage = this.field_76652_q[n5 >> 4]) == null) continue;
                    extendedBlockStorage.func_76657_c(n2, n5 & 0xF, n, n4);
                    this.field_76637_e.func_72902_n((this.field_76635_g << 4) + n2, n5, (this.field_76647_h << 4) + n);
                } while (--n5 > 0 && n4 > 0);
            }
        }
        this.field_76643_l = true;
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < 16; ++n) {
                this.func_76595_e(n2, n);
            }
        }
    }

    private void func_76595_e(int p_76595_1_, int p_76595_2_) {
        this.field_76639_c[p_76595_1_ + p_76595_2_ * 16] = true;
        this.field_76650_s = true;
    }

    private void func_76593_q() {
        this.field_76637_e.field_72984_F.func_76320_a("recheckGaps");
        if (this.field_76637_e.func_72873_a(this.field_76635_g * 16 + 8, 0, this.field_76647_h * 16 + 8, 16)) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (!this.field_76639_c[i + j * 16]) continue;
                    this.field_76639_c[i + j * 16] = false;
                    int n = this.func_76611_b(i, j);
                    int n2 = this.field_76635_g * 16 + i;
                    int n3 = this.field_76647_h * 16 + j;
                    int n4 = this.field_76637_e.func_82734_g(n2 - 1, n3);
                    int n5 = this.field_76637_e.func_82734_g(n2 + 1, n3);
                    int n6 = this.field_76637_e.func_82734_g(n2, n3 - 1);
                    int n7 = this.field_76637_e.func_82734_g(n2, n3 + 1);
                    if (n5 < n4) {
                        n4 = n5;
                    }
                    if (n6 < n4) {
                        n4 = n6;
                    }
                    if (n7 < n4) {
                        n4 = n7;
                    }
                    this.func_76599_g(n2, n3, n4);
                    this.func_76599_g(n2 - 1, n3, n);
                    this.func_76599_g(n2 + 1, n3, n);
                    this.func_76599_g(n2, n3 - 1, n);
                    this.func_76599_g(n2, n3 + 1, n);
                }
            }
            this.field_76650_s = false;
        }
        this.field_76637_e.field_72984_F.func_76319_b();
    }

    private void func_76599_g(int p_76599_1_, int p_76599_2_, int p_76599_3_) {
        int n = this.field_76637_e.func_72976_f(p_76599_1_, p_76599_2_);
        if (n > p_76599_3_) {
            this.func_76609_d(p_76599_1_, p_76599_2_, p_76599_3_, n + 1);
        } else if (n < p_76599_3_) {
            this.func_76609_d(p_76599_1_, p_76599_2_, n, p_76599_3_ + 1);
        }
    }

    private void func_76609_d(int p_76609_1_, int p_76609_2_, int p_76609_3_, int p_76609_4_) {
        if (p_76609_4_ > p_76609_3_ && this.field_76637_e.func_72873_a(p_76609_1_, 0, p_76609_2_, 16)) {
            for (int i = p_76609_3_; i < p_76609_4_; ++i) {
                this.field_76637_e.func_72936_c(EnumSkyBlock.Sky, p_76609_1_, i, p_76609_2_);
            }
            this.field_76643_l = true;
        }
    }

    private void func_76615_h(int p_76615_1_, int p_76615_2_, int p_76615_3_) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = n4 = this.field_76634_f[p_76615_3_ << 4 | p_76615_1_] & 0xFF;
        if (p_76615_2_ > n4) {
            n5 = p_76615_2_;
        }
        while (n5 > 0 && this.func_76596_b(p_76615_1_, n5 - 1, p_76615_3_) == 0) {
            --n5;
        }
        if (n5 == n4) {
            return;
        }
        this.field_76637_e.func_72975_g(p_76615_1_ + this.field_76635_g * 16, p_76615_3_ + this.field_76647_h * 16, n5, n4);
        this.field_76634_f[p_76615_3_ << 4 | p_76615_1_] = n5;
        int n6 = this.field_76635_g * 16 + p_76615_1_;
        int n7 = this.field_76647_h * 16 + p_76615_3_;
        if (!this.field_76637_e.field_73011_w.field_76576_e) {
            ExtendedBlockStorage extendedBlockStorage;
            if (n5 < n4) {
                for (n3 = n5; n3 < n4; ++n3) {
                    extendedBlockStorage = this.field_76652_q[n3 >> 4];
                    if (extendedBlockStorage == null) continue;
                    extendedBlockStorage.func_76657_c(p_76615_1_, n3 & 0xF, p_76615_3_, 15);
                    this.field_76637_e.func_72902_n((this.field_76635_g << 4) + p_76615_1_, n3, (this.field_76647_h << 4) + p_76615_3_);
                }
            } else {
                for (n3 = n4; n3 < n5; ++n3) {
                    extendedBlockStorage = this.field_76652_q[n3 >> 4];
                    if (extendedBlockStorage == null) continue;
                    extendedBlockStorage.func_76657_c(p_76615_1_, n3 & 0xF, p_76615_3_, 0);
                    this.field_76637_e.func_72902_n((this.field_76635_g << 4) + p_76615_1_, n3, (this.field_76647_h << 4) + p_76615_3_);
                }
            }
            n3 = 15;
            while (n5 > 0 && n3 > 0) {
                ExtendedBlockStorage extendedBlockStorage2;
                int n8;
                if ((n8 = this.func_76596_b(p_76615_1_, --n5, p_76615_3_)) == 0) {
                    n8 = 1;
                }
                if ((n3 -= n8) < 0) {
                    n3 = 0;
                }
                if ((extendedBlockStorage2 = this.field_76652_q[n5 >> 4]) == null) continue;
                extendedBlockStorage2.func_76657_c(p_76615_1_, n5 & 0xF, p_76615_3_, n3);
            }
        }
        if ((n2 = (n3 = this.field_76634_f[p_76615_3_ << 4 | p_76615_1_])) < (n = n4)) {
            int n9 = n;
            n = n2;
            n2 = n9;
        }
        if (n3 < this.field_82912_p) {
            this.field_82912_p = n3;
        }
        if (!this.field_76637_e.field_73011_w.field_76576_e) {
            this.func_76609_d(n6 - 1, n7, n, n2);
            this.func_76609_d(n6 + 1, n7, n, n2);
            this.func_76609_d(n6, n7 - 1, n, n2);
            this.func_76609_d(n6, n7 + 1, n, n2);
            this.func_76609_d(n6, n7, n, n2);
        }
        this.field_76643_l = true;
    }

    public int func_76596_b(int p_76596_1_, int p_76596_2_, int p_76596_3_) {
        return Block.field_71971_o[this.func_76610_a(p_76596_1_, p_76596_2_, p_76596_3_)];
    }

    public int func_76610_a(int p_76610_1_, int p_76610_2_, int p_76610_3_) {
        if (p_76610_2_ >> 4 >= this.field_76652_q.length) {
            return 0;
        }
        ExtendedBlockStorage extendedBlockStorage = this.field_76652_q[p_76610_2_ >> 4];
        if (extendedBlockStorage != null) {
            return extendedBlockStorage.func_76656_a(p_76610_1_, p_76610_2_ & 0xF, p_76610_3_);
        }
        return 0;
    }

    public int func_76628_c(int p_76628_1_, int p_76628_2_, int p_76628_3_) {
        if (p_76628_2_ >> 4 >= this.field_76652_q.length) {
            return 0;
        }
        ExtendedBlockStorage extendedBlockStorage = this.field_76652_q[p_76628_2_ >> 4];
        if (extendedBlockStorage != null) {
            return extendedBlockStorage.func_76665_b(p_76628_1_, p_76628_2_ & 0xF, p_76628_3_);
        }
        return 0;
    }

    public boolean func_76592_a(int p_76592_1_, int p_76592_2_, int p_76592_3_, int p_76592_4_, int p_76592_5_) {
        TileEntity tileEntity;
        int n = p_76592_3_ << 4 | p_76592_1_;
        if (p_76592_2_ >= this.field_76638_b[n] - 1) {
            this.field_76638_b[n] = -999;
        }
        int n2 = this.field_76634_f[n];
        int n3 = this.func_76610_a(p_76592_1_, p_76592_2_, p_76592_3_);
        int n4 = this.func_76628_c(p_76592_1_, p_76592_2_, p_76592_3_);
        if (n3 == p_76592_4_ && n4 == p_76592_5_) {
            return false;
        }
        ExtendedBlockStorage extendedBlockStorage = this.field_76652_q[p_76592_2_ >> 4];
        boolean bl = false;
        if (extendedBlockStorage == null) {
            if (p_76592_4_ == 0) {
                return false;
            }
            ExtendedBlockStorage extendedBlockStorage2 = new ExtendedBlockStorage(p_76592_2_ >> 4 << 4, !this.field_76637_e.field_73011_w.field_76576_e);
            this.field_76652_q[p_76592_2_ >> 4] = extendedBlockStorage2;
            extendedBlockStorage = extendedBlockStorage2;
            bl = p_76592_2_ >= n2;
        }
        int n5 = this.field_76635_g * 16 + p_76592_1_;
        int n6 = this.field_76647_h * 16 + p_76592_3_;
        if (n3 != 0 && !this.field_76637_e.field_72995_K) {
            Block.field_71973_m[n3].func_71927_h(this.field_76637_e, n5, p_76592_2_, n6, n4);
        }
        extendedBlockStorage.func_76655_a(p_76592_1_, p_76592_2_ & 0xF, p_76592_3_, p_76592_4_);
        if (n3 != 0) {
            if (!this.field_76637_e.field_72995_K) {
                Block.field_71973_m[n3].func_71852_a(this.field_76637_e, n5, p_76592_2_, n6, n3, n4);
            } else if (Block.field_71973_m[n3] instanceof ITileEntityProvider && n3 != p_76592_4_) {
                this.field_76637_e.func_72932_q(n5, p_76592_2_, n6);
            }
        }
        if (extendedBlockStorage.func_76656_a(p_76592_1_, p_76592_2_ & 0xF, p_76592_3_) != p_76592_4_) {
            return false;
        }
        extendedBlockStorage.func_76654_b(p_76592_1_, p_76592_2_ & 0xF, p_76592_3_, p_76592_5_);
        if (bl) {
            this.func_76603_b();
        } else {
            if (Block.field_71971_o[p_76592_4_ & 0xFFF] > 0) {
                if (p_76592_2_ >= n2) {
                    this.func_76615_h(p_76592_1_, p_76592_2_ + 1, p_76592_3_);
                }
            } else if (p_76592_2_ == n2 - 1) {
                this.func_76615_h(p_76592_1_, p_76592_2_, p_76592_3_);
            }
            this.func_76595_e(p_76592_1_, p_76592_3_);
        }
        if (p_76592_4_ != 0) {
            if (!this.field_76637_e.field_72995_K) {
                Block.field_71973_m[p_76592_4_].func_71861_g(this.field_76637_e, n5, p_76592_2_, n6);
            }
            if (Block.field_71973_m[p_76592_4_] instanceof ITileEntityProvider) {
                TileEntity tileEntity2 = this.func_76597_e(p_76592_1_, p_76592_2_, p_76592_3_);
                if (tileEntity2 == null) {
                    tileEntity2 = ((ITileEntityProvider)((Object)Block.field_71973_m[p_76592_4_])).func_72274_a(this.field_76637_e);
                    this.field_76637_e.func_72837_a(n5, p_76592_2_, n6, tileEntity2);
                }
                if (tileEntity2 != null) {
                    tileEntity2.func_70321_h();
                }
            }
        } else if (n3 > 0 && Block.field_71973_m[n3] instanceof ITileEntityProvider && (tileEntity = this.func_76597_e(p_76592_1_, p_76592_2_, p_76592_3_)) != null) {
            tileEntity.func_70321_h();
        }
        this.field_76643_l = true;
        return true;
    }

    public boolean func_76589_b(int p_76589_1_, int p_76589_2_, int p_76589_3_, int p_76589_4_) {
        TileEntity tileEntity;
        ExtendedBlockStorage extendedBlockStorage = this.field_76652_q[p_76589_2_ >> 4];
        if (extendedBlockStorage == null) {
            return false;
        }
        int n = extendedBlockStorage.func_76665_b(p_76589_1_, p_76589_2_ & 0xF, p_76589_3_);
        if (n == p_76589_4_) {
            return false;
        }
        this.field_76643_l = true;
        extendedBlockStorage.func_76654_b(p_76589_1_, p_76589_2_ & 0xF, p_76589_3_, p_76589_4_);
        int n2 = extendedBlockStorage.func_76656_a(p_76589_1_, p_76589_2_ & 0xF, p_76589_3_);
        if (n2 > 0 && Block.field_71973_m[n2] instanceof ITileEntityProvider && (tileEntity = this.func_76597_e(p_76589_1_, p_76589_2_, p_76589_3_)) != null) {
            tileEntity.func_70321_h();
            tileEntity.field_70325_p = p_76589_4_;
        }
        return true;
    }

    public int func_76614_a(EnumSkyBlock p_76614_1_, int p_76614_2_, int p_76614_3_, int p_76614_4_) {
        ExtendedBlockStorage extendedBlockStorage = this.field_76652_q[p_76614_3_ >> 4];
        if (extendedBlockStorage == null) {
            if (this.func_76619_d(p_76614_2_, p_76614_3_, p_76614_4_)) {
                return p_76614_1_.field_77198_c;
            }
            return 0;
        }
        if (p_76614_1_ == EnumSkyBlock.Sky) {
            if (this.field_76637_e.field_73011_w.field_76576_e) {
                return 0;
            }
            return extendedBlockStorage.func_76670_c(p_76614_2_, p_76614_3_ & 0xF, p_76614_4_);
        }
        if (p_76614_1_ == EnumSkyBlock.Block) {
            return extendedBlockStorage.func_76674_d(p_76614_2_, p_76614_3_ & 0xF, p_76614_4_);
        }
        return p_76614_1_.field_77198_c;
    }

    public void func_76633_a(EnumSkyBlock p_76633_1_, int p_76633_2_, int p_76633_3_, int p_76633_4_, int p_76633_5_) {
        ExtendedBlockStorage extendedBlockStorage = this.field_76652_q[p_76633_3_ >> 4];
        if (extendedBlockStorage == null) {
            ExtendedBlockStorage extendedBlockStorage2 = new ExtendedBlockStorage(p_76633_3_ >> 4 << 4, !this.field_76637_e.field_73011_w.field_76576_e);
            this.field_76652_q[p_76633_3_ >> 4] = extendedBlockStorage2;
            extendedBlockStorage = extendedBlockStorage2;
            this.func_76603_b();
        }
        this.field_76643_l = true;
        if (p_76633_1_ == EnumSkyBlock.Sky) {
            if (!this.field_76637_e.field_73011_w.field_76576_e) {
                extendedBlockStorage.func_76657_c(p_76633_2_, p_76633_3_ & 0xF, p_76633_4_, p_76633_5_);
            }
        } else if (p_76633_1_ == EnumSkyBlock.Block) {
            extendedBlockStorage.func_76677_d(p_76633_2_, p_76633_3_ & 0xF, p_76633_4_, p_76633_5_);
        }
    }

    public int func_76629_c(int p_76629_1_, int p_76629_2_, int p_76629_3_, int p_76629_4_) {
        int n;
        int n2;
        ExtendedBlockStorage extendedBlockStorage = this.field_76652_q[p_76629_2_ >> 4];
        if (extendedBlockStorage == null) {
            if (!this.field_76637_e.field_73011_w.field_76576_e && p_76629_4_ < EnumSkyBlock.Sky.field_77198_c) {
                return EnumSkyBlock.Sky.field_77198_c - p_76629_4_;
            }
            return 0;
        }
        int n3 = n2 = this.field_76637_e.field_73011_w.field_76576_e ? 0 : extendedBlockStorage.func_76670_c(p_76629_1_, p_76629_2_ & 0xF, p_76629_3_);
        if (n2 > 0) {
            field_76640_a = true;
        }
        if ((n = extendedBlockStorage.func_76674_d(p_76629_1_, p_76629_2_ & 0xF, p_76629_3_)) > (n2 -= p_76629_4_)) {
            n2 = n;
        }
        return n2;
    }

    public void func_76612_a(Entity p_76612_1_) {
        int n;
        this.field_76644_m = true;
        int n2 = MathHelper.func_76128_c(p_76612_1_.field_70165_t / 16.0);
        int n3 = MathHelper.func_76128_c(p_76612_1_.field_70161_v / 16.0);
        if (n2 != this.field_76635_g || n3 != this.field_76647_h) {
            this.field_76637_e.func_98180_V().func_98232_c("Wrong location! " + p_76612_1_);
            Thread.dumpStack();
        }
        if ((n = MathHelper.func_76128_c(p_76612_1_.field_70163_u / 16.0)) < 0) {
            n = 0;
        }
        if (n >= this.field_76645_j.length) {
            n = this.field_76645_j.length - 1;
        }
        p_76612_1_.field_70175_ag = true;
        p_76612_1_.field_70176_ah = this.field_76635_g;
        p_76612_1_.field_70162_ai = n;
        p_76612_1_.field_70164_aj = this.field_76647_h;
        this.field_76645_j[n].add(p_76612_1_);
    }

    public void func_76622_b(Entity p_76622_1_) {
        this.func_76608_a(p_76622_1_, p_76622_1_.field_70162_ai);
    }

    public void func_76608_a(Entity p_76608_1_, int p_76608_2_) {
        if (p_76608_2_ < 0) {
            p_76608_2_ = 0;
        }
        if (p_76608_2_ >= this.field_76645_j.length) {
            p_76608_2_ = this.field_76645_j.length - 1;
        }
        this.field_76645_j[p_76608_2_].remove(p_76608_1_);
    }

    public boolean func_76619_d(int p_76619_1_, int p_76619_2_, int p_76619_3_) {
        return p_76619_2_ >= this.field_76634_f[p_76619_3_ << 4 | p_76619_1_];
    }

    public TileEntity func_76597_e(int p_76597_1_, int p_76597_2_, int p_76597_3_) {
        ChunkPosition chunkPosition = new ChunkPosition(p_76597_1_, p_76597_2_, p_76597_3_);
        TileEntity tileEntity = (TileEntity)this.field_76648_i.get(chunkPosition);
        if (tileEntity == null) {
            int n = this.func_76610_a(p_76597_1_, p_76597_2_, p_76597_3_);
            if (n <= 0 || !Block.field_71973_m[n].func_71887_s()) {
                return null;
            }
            if (tileEntity == null) {
                tileEntity = ((ITileEntityProvider)((Object)Block.field_71973_m[n])).func_72274_a(this.field_76637_e);
                this.field_76637_e.func_72837_a(this.field_76635_g * 16 + p_76597_1_, p_76597_2_, this.field_76647_h * 16 + p_76597_3_, tileEntity);
            }
            tileEntity = (TileEntity)this.field_76648_i.get(chunkPosition);
        }
        if (tileEntity != null && tileEntity.func_70320_p()) {
            this.field_76648_i.remove(chunkPosition);
            return null;
        }
        return tileEntity;
    }

    public void func_76620_a(TileEntity p_76620_1_) {
        int n = p_76620_1_.field_70329_l - this.field_76635_g * 16;
        int n2 = p_76620_1_.field_70330_m;
        int n3 = p_76620_1_.field_70327_n - this.field_76647_h * 16;
        this.func_76604_a(n, n2, n3, p_76620_1_);
        if (this.field_76636_d) {
            this.field_76637_e.field_73009_h.add(p_76620_1_);
        }
    }

    public void func_76604_a(int p_76604_1_, int p_76604_2_, int p_76604_3_, TileEntity p_76604_4_) {
        ChunkPosition chunkPosition = new ChunkPosition(p_76604_1_, p_76604_2_, p_76604_3_);
        p_76604_4_.func_70308_a(this.field_76637_e);
        p_76604_4_.field_70329_l = this.field_76635_g * 16 + p_76604_1_;
        p_76604_4_.field_70330_m = p_76604_2_;
        p_76604_4_.field_70327_n = this.field_76647_h * 16 + p_76604_3_;
        if (this.func_76610_a(p_76604_1_, p_76604_2_, p_76604_3_) == 0 || !(Block.field_71973_m[this.func_76610_a(p_76604_1_, p_76604_2_, p_76604_3_)] instanceof ITileEntityProvider)) {
            return;
        }
        if (this.field_76648_i.containsKey(chunkPosition)) {
            ((TileEntity)this.field_76648_i.get(chunkPosition)).func_70313_j();
        }
        p_76604_4_.func_70312_q();
        this.field_76648_i.put(chunkPosition, p_76604_4_);
    }

    public void func_76627_f(int p_76627_1_, int p_76627_2_, int p_76627_3_) {
        TileEntity tileEntity;
        ChunkPosition chunkPosition = new ChunkPosition(p_76627_1_, p_76627_2_, p_76627_3_);
        if (this.field_76636_d && (tileEntity = (TileEntity)this.field_76648_i.remove(chunkPosition)) != null) {
            tileEntity.func_70313_j();
        }
    }

    public void func_76631_c() {
        this.field_76636_d = true;
        this.field_76637_e.func_72852_a(this.field_76648_i.values());
        for (int i = 0; i < this.field_76645_j.length; ++i) {
            for (Entity entity : this.field_76645_j[i]) {
                entity.func_110123_P();
            }
            this.field_76637_e.func_72868_a(this.field_76645_j[i]);
        }
    }

    public void func_76623_d() {
        this.field_76636_d = false;
        for (TileEntity tileEntity : this.field_76648_i.values()) {
            this.field_76637_e.func_72928_a(tileEntity);
        }
        for (int i = 0; i < this.field_76645_j.length; ++i) {
            this.field_76637_e.func_72828_b(this.field_76645_j[i]);
        }
    }

    public void func_76630_e() {
        this.field_76643_l = true;
    }

    public void func_76588_a(Entity p_76588_1_, AxisAlignedBB p_76588_2_, List p_76588_3_, IEntitySelector p_76588_4_) {
        int n = MathHelper.func_76128_c((p_76588_2_.field_72338_b - 2.0) / 16.0);
        int n2 = MathHelper.func_76128_c((p_76588_2_.field_72337_e + 2.0) / 16.0);
        if (n < 0) {
            n = 0;
            n2 = Math.max(n, n2);
        }
        if (n2 >= this.field_76645_j.length) {
            n2 = this.field_76645_j.length - 1;
            n = Math.min(n, n2);
        }
        for (int i = n; i <= n2; ++i) {
            List list = this.field_76645_j[i];
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity == p_76588_1_ || !entity.field_70121_D.func_72326_a(p_76588_2_) || p_76588_4_ != null && !p_76588_4_.func_82704_a(entity)) continue;
                p_76588_3_.add(entity);
                Entity[] entityArray = entity.func_70021_al();
                if (entityArray == null) continue;
                for (int k = 0; k < entityArray.length; ++k) {
                    entity = entityArray[k];
                    if (entity == p_76588_1_ || !entity.field_70121_D.func_72326_a(p_76588_2_) || p_76588_4_ != null && !p_76588_4_.func_82704_a(entity)) continue;
                    p_76588_3_.add(entity);
                }
            }
        }
    }

    public void func_76618_a(Class p_76618_1_, AxisAlignedBB p_76618_2_, List p_76618_3_, IEntitySelector p_76618_4_) {
        int n = MathHelper.func_76128_c((p_76618_2_.field_72338_b - 2.0) / 16.0);
        int n2 = MathHelper.func_76128_c((p_76618_2_.field_72337_e + 2.0) / 16.0);
        if (n < 0) {
            n = 0;
        } else if (n >= this.field_76645_j.length) {
            n = this.field_76645_j.length - 1;
        }
        if (n2 >= this.field_76645_j.length) {
            n2 = this.field_76645_j.length - 1;
        } else if (n2 < 0) {
            n2 = 0;
        }
        for (int i = n; i <= n2; ++i) {
            List list = this.field_76645_j[i];
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (!p_76618_1_.isAssignableFrom(entity.getClass()) || !entity.field_70121_D.func_72326_a(p_76618_2_) || p_76618_4_ != null && !p_76618_4_.func_82704_a(entity)) continue;
                p_76618_3_.add(entity);
            }
        }
    }

    public boolean func_76601_a(boolean p_76601_1_) {
        if (p_76601_1_ ? this.field_76644_m && this.field_76637_e.func_82737_E() != this.field_76641_n || this.field_76643_l : this.field_76644_m && this.field_76637_e.func_82737_E() >= this.field_76641_n + 600L) {
            return true;
        }
        return this.field_76643_l;
    }

    public Random func_76617_a(long p_76617_1_) {
        return new Random(this.field_76637_e.func_72905_C() + (long)(this.field_76635_g * this.field_76635_g * 4987142) + (long)(this.field_76635_g * 5947611) + (long)(this.field_76647_h * this.field_76647_h) * 4392871L + (long)(this.field_76647_h * 389711) ^ p_76617_1_);
    }

    public boolean func_76621_g() {
        return false;
    }

    public void func_76624_a(IChunkProvider p_76624_1_, IChunkProvider p_76624_2_, int p_76624_3_, int p_76624_4_) {
        if (!this.field_76646_k && p_76624_1_.func_73149_a(p_76624_3_ + 1, p_76624_4_ + 1) && p_76624_1_.func_73149_a(p_76624_3_, p_76624_4_ + 1) && p_76624_1_.func_73149_a(p_76624_3_ + 1, p_76624_4_)) {
            p_76624_1_.func_73153_a(p_76624_2_, p_76624_3_, p_76624_4_);
        }
        if (p_76624_1_.func_73149_a(p_76624_3_ - 1, p_76624_4_) && !p_76624_1_.func_73154_d((int)(p_76624_3_ - 1), (int)p_76624_4_).field_76646_k && p_76624_1_.func_73149_a(p_76624_3_ - 1, p_76624_4_ + 1) && p_76624_1_.func_73149_a(p_76624_3_, p_76624_4_ + 1) && p_76624_1_.func_73149_a(p_76624_3_ - 1, p_76624_4_ + 1)) {
            p_76624_1_.func_73153_a(p_76624_2_, p_76624_3_ - 1, p_76624_4_);
        }
        if (p_76624_1_.func_73149_a(p_76624_3_, p_76624_4_ - 1) && !p_76624_1_.func_73154_d((int)p_76624_3_, (int)(p_76624_4_ - 1)).field_76646_k && p_76624_1_.func_73149_a(p_76624_3_ + 1, p_76624_4_ - 1) && p_76624_1_.func_73149_a(p_76624_3_ + 1, p_76624_4_ - 1) && p_76624_1_.func_73149_a(p_76624_3_ + 1, p_76624_4_)) {
            p_76624_1_.func_73153_a(p_76624_2_, p_76624_3_, p_76624_4_ - 1);
        }
        if (p_76624_1_.func_73149_a(p_76624_3_ - 1, p_76624_4_ - 1) && !p_76624_1_.func_73154_d((int)(p_76624_3_ - 1), (int)(p_76624_4_ - 1)).field_76646_k && p_76624_1_.func_73149_a(p_76624_3_, p_76624_4_ - 1) && p_76624_1_.func_73149_a(p_76624_3_ - 1, p_76624_4_)) {
            p_76624_1_.func_73153_a(p_76624_2_, p_76624_3_ - 1, p_76624_4_ - 1);
        }
    }

    public int func_76626_d(int p_76626_1_, int p_76626_2_) {
        int n = p_76626_1_ | p_76626_2_ << 4;
        int n2 = this.field_76638_b[n];
        if (n2 == -999) {
            int n3 = this.func_76625_h() + 15;
            n2 = -1;
            while (n3 > 0 && n2 == -1) {
                Material material;
                int n4 = this.func_76610_a(p_76626_1_, n3, p_76626_2_);
                Material material2 = material = n4 == 0 ? Material.field_76249_a : Block.field_71973_m[n4].field_72018_cp;
                if (!material.func_76230_c() && !material.func_76224_d()) {
                    --n3;
                    continue;
                }
                n2 = n3 + 1;
            }
            this.field_76638_b[n] = n2;
        }
        return n2;
    }

    public void func_76586_k() {
        if (this.field_76650_s && !this.field_76637_e.field_73011_w.field_76576_e) {
            this.func_76593_q();
        }
    }

    public ChunkCoordIntPair func_76632_l() {
        return new ChunkCoordIntPair(this.field_76635_g, this.field_76647_h);
    }

    public boolean func_76606_c(int p_76606_1_, int p_76606_2_) {
        if (p_76606_1_ < 0) {
            p_76606_1_ = 0;
        }
        if (p_76606_2_ >= 256) {
            p_76606_2_ = 255;
        }
        for (int i = p_76606_1_; i <= p_76606_2_; i += 16) {
            ExtendedBlockStorage extendedBlockStorage = this.field_76652_q[i >> 4];
            if (extendedBlockStorage == null || extendedBlockStorage.func_76663_a()) continue;
            return false;
        }
        return true;
    }

    public void func_76602_a(ExtendedBlockStorage[] p_76602_1_) {
        this.field_76652_q = p_76602_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_76607_a(byte[] p_76607_1_, int p_76607_2_, int p_76607_3_, boolean p_76607_4_) {
        Object object;
        int n;
        int n2 = 0;
        boolean bl = !this.field_76637_e.field_73011_w.field_76576_e;
        for (n = 0; n < this.field_76652_q.length; ++n) {
            if ((p_76607_2_ & 1 << n) != 0) {
                if (this.field_76652_q[n] == null) {
                    this.field_76652_q[n] = new ExtendedBlockStorage(n << 4, bl);
                }
                object = this.field_76652_q[n].func_76658_g();
                System.arraycopy(p_76607_1_, n2, object, 0, ((byte[])object).length);
                n2 += ((byte[])object).length;
                continue;
            }
            if (!p_76607_4_ || this.field_76652_q[n] == null) continue;
            this.field_76652_q[n] = null;
        }
        for (n = 0; n < this.field_76652_q.length; ++n) {
            if ((p_76607_2_ & 1 << n) == 0 || this.field_76652_q[n] == null) continue;
            object = this.field_76652_q[n].func_76669_j();
            System.arraycopy(p_76607_1_, n2, object.field_76585_a, 0, object.field_76585_a.length);
            n2 += object.field_76585_a.length;
        }
        for (n = 0; n < this.field_76652_q.length; ++n) {
            if ((p_76607_2_ & 1 << n) == 0 || this.field_76652_q[n] == null) continue;
            object = this.field_76652_q[n].func_76661_k();
            System.arraycopy(p_76607_1_, n2, object.field_76585_a, 0, object.field_76585_a.length);
            n2 += object.field_76585_a.length;
        }
        if (bl) {
            for (n = 0; n < this.field_76652_q.length; ++n) {
                if ((p_76607_2_ & 1 << n) == 0 || this.field_76652_q[n] == null) continue;
                object = this.field_76652_q[n].func_76671_l();
                System.arraycopy(p_76607_1_, n2, object.field_76585_a, 0, object.field_76585_a.length);
                n2 += object.field_76585_a.length;
            }
        }
        for (n = 0; n < this.field_76652_q.length; ++n) {
            if ((p_76607_3_ & 1 << n) != 0) {
                if (this.field_76652_q[n] == null) {
                    n2 += 2048;
                    continue;
                }
                object = this.field_76652_q[n].func_76660_i();
                if (object == null) {
                    object = this.field_76652_q[n].func_76667_m();
                }
                System.arraycopy(p_76607_1_, n2, object.field_76585_a, 0, object.field_76585_a.length);
                n2 += object.field_76585_a.length;
                continue;
            }
            if (!p_76607_4_ || this.field_76652_q[n] == null || this.field_76652_q[n].func_76660_i() == null) continue;
            this.field_76652_q[n].func_76676_h();
        }
        if (p_76607_4_) {
            System.arraycopy(p_76607_1_, n2, this.field_76651_r, 0, this.field_76651_r.length);
            n2 += this.field_76651_r.length;
        }
        for (n = 0; n < this.field_76652_q.length; ++n) {
            if (this.field_76652_q[n] == null || (p_76607_2_ & 1 << n) == 0) continue;
            this.field_76652_q[n].func_76672_e();
        }
        this.func_76590_a();
        Iterator iterator = this.field_76648_i.values().iterator();
        while (iterator.hasNext()) {
            object = (TileEntity)iterator.next();
            object.func_70321_h();
        }
    }

    public BiomeGenBase func_76591_a(int p_76591_1_, int p_76591_2_, WorldChunkManager p_76591_3_) {
        int n = this.field_76651_r[p_76591_2_ << 4 | p_76591_1_] & 0xFF;
        if (n == 255) {
            BiomeGenBase biomeGenBase = p_76591_3_.func_76935_a((this.field_76635_g << 4) + p_76591_1_, (this.field_76647_h << 4) + p_76591_2_);
            n = biomeGenBase.field_76756_M;
            this.field_76651_r[p_76591_2_ << 4 | p_76591_1_] = (byte)(n & 0xFF);
        }
        if (BiomeGenBase.field_76773_a[n] == null) {
            return BiomeGenBase.field_76772_c;
        }
        return BiomeGenBase.field_76773_a[n];
    }

    public byte[] func_76605_m() {
        return this.field_76651_r;
    }

    public void func_76616_a(byte[] p_76616_1_) {
        this.field_76651_r = p_76616_1_;
    }

    public void func_76613_n() {
        this.field_76649_t = 0;
    }

    public void func_76594_o() {
        for (int i = 0; i < 8; ++i) {
            if (this.field_76649_t >= 4096) {
                return;
            }
            int n = this.field_76649_t % 16;
            int n2 = this.field_76649_t / 16 % 16;
            int n3 = this.field_76649_t / 256;
            ++this.field_76649_t;
            int n4 = (this.field_76635_g << 4) + n2;
            int n5 = (this.field_76647_h << 4) + n3;
            for (int j = 0; j < 16; ++j) {
                int n6 = (n << 4) + j;
                if ((this.field_76652_q[n] != null || j != 0 && j != 15 && n2 != 0 && n2 != 15 && n3 != 0 && n3 != 15) && (this.field_76652_q[n] == null || this.field_76652_q[n].func_76656_a(n2, j, n3) != 0)) continue;
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(n4, n6 - 1, n5)] > 0) {
                    this.field_76637_e.func_72969_x(n4, n6 - 1, n5);
                }
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(n4, n6 + 1, n5)] > 0) {
                    this.field_76637_e.func_72969_x(n4, n6 + 1, n5);
                }
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(n4 - 1, n6, n5)] > 0) {
                    this.field_76637_e.func_72969_x(n4 - 1, n6, n5);
                }
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(n4 + 1, n6, n5)] > 0) {
                    this.field_76637_e.func_72969_x(n4 + 1, n6, n5);
                }
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(n4, n6, n5 - 1)] > 0) {
                    this.field_76637_e.func_72969_x(n4, n6, n5 - 1);
                }
                if (Block.field_71984_q[this.field_76637_e.func_72798_a(n4, n6, n5 + 1)] > 0) {
                    this.field_76637_e.func_72969_x(n4, n6, n5 + 1);
                }
                this.field_76637_e.func_72969_x(n4, n6, n5);
            }
        }
    }
}

