/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.biome.WorldChunkManagerHell;
import net.minecraft.world.chunk.storage.AnvilConverterData;
import net.minecraft.world.chunk.storage.AnvilSaveConverterFileFilter;
import net.minecraft.world.chunk.storage.AnvilSaveHandler;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveFormatComparator;
import net.minecraft.world.storage.SaveFormatOld;
import net.minecraft.world.storage.WorldInfo;

public class AnvilSaveConverter
extends SaveFormatOld {
    public AnvilSaveConverter(File p_i2144_1_) {
        super(p_i2144_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List func_75799_b() throws AnvilConverterException {
        File[] fileArray;
        if (this.field_75808_a == null || !this.field_75808_a.exists() || !this.field_75808_a.isDirectory()) {
            throw new AnvilConverterException("Unable to read or access folder where game worlds are saved!");
        }
        ArrayList<SaveFormatComparator> arrayList = new ArrayList<SaveFormatComparator>();
        for (File file : fileArray = this.field_75808_a.listFiles()) {
            String string;
            WorldInfo worldInfo;
            if (!file.isDirectory() || (worldInfo = this.func_75803_c(string = file.getName())) == null || worldInfo.func_76088_k() != 19132 && worldInfo.func_76088_k() != 19133) continue;
            boolean bl = worldInfo.func_76088_k() != this.func_75812_c();
            String string2 = worldInfo.func_76065_j();
            if (string2 == null || MathHelper.func_76139_a(string2)) {
                string2 = string;
            }
            long l = 0L;
            arrayList.add(new SaveFormatComparator(string, string2, worldInfo.func_76057_l(), l, worldInfo.func_76077_q(), bl, worldInfo.func_76093_s(), worldInfo.func_76086_u()));
        }
        return arrayList;
    }

    protected int func_75812_c() {
        return 19133;
    }

    @Override
    public void func_75800_d() {
        RegionFileCache.func_76551_a();
    }

    @Override
    public ISaveHandler func_75804_a(String p_75804_1_, boolean p_75804_2_) {
        return new AnvilSaveHandler(this.field_75808_a, p_75804_1_, p_75804_2_);
    }

    @Override
    public boolean func_75801_b(String p_75801_1_) {
        WorldInfo worldInfo = this.func_75803_c(p_75801_1_);
        return worldInfo != null && worldInfo.func_76088_k() != this.func_75812_c();
    }

    @Override
    public boolean func_75805_a(String p_75805_1_, IProgressUpdate p_75805_2_) {
        p_75805_2_.func_73718_a(0);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        File file = new File(this.field_75808_a, p_75805_1_);
        File file2 = new File(file, "DIM-1");
        File file3 = new File(file, "DIM1");
        MinecraftServer.func_71276_C().func_98033_al().func_98233_a("Scanning folders...");
        this.func_75810_a(file, arrayList);
        if (file2.exists()) {
            this.func_75810_a(file2, arrayList2);
        }
        if (file3.exists()) {
            this.func_75810_a(file3, arrayList3);
        }
        int n = arrayList.size() + arrayList2.size() + arrayList3.size();
        MinecraftServer.func_71276_C().func_98033_al().func_98233_a("Total conversion count is " + n);
        WorldInfo worldInfo = this.func_75803_c(p_75805_1_);
        WorldChunkManager worldChunkManager = null;
        worldChunkManager = worldInfo.func_76067_t() == WorldType.field_77138_c ? new WorldChunkManagerHell(BiomeGenBase.field_76772_c, 0.5f, 0.5f) : new WorldChunkManager(worldInfo.func_76063_b(), worldInfo.func_76067_t());
        this.func_75813_a(new File(file, "region"), arrayList, worldChunkManager, 0, n, p_75805_2_);
        this.func_75813_a(new File(file2, "region"), arrayList2, new WorldChunkManagerHell(BiomeGenBase.field_76778_j, 1.0f, 0.0f), arrayList.size(), n, p_75805_2_);
        this.func_75813_a(new File(file3, "region"), arrayList3, new WorldChunkManagerHell(BiomeGenBase.field_76779_k, 0.5f, 0.0f), arrayList.size() + arrayList2.size(), n, p_75805_2_);
        worldInfo.func_76078_e(19133);
        if (worldInfo.func_76067_t() == WorldType.field_77136_e) {
            worldInfo.func_76085_a(WorldType.field_77137_b);
        }
        this.func_75809_f(p_75805_1_);
        ISaveHandler iSaveHandler = this.func_75804_a(p_75805_1_, false);
        iSaveHandler.func_75761_a(worldInfo);
        return true;
    }

    private void func_75809_f(String p_75809_1_) {
        File file = new File(this.field_75808_a, p_75809_1_);
        if (!file.exists()) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
            return;
        }
        File file2 = new File(file, "level.dat");
        if (!file2.exists()) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
            return;
        }
        File file3 = new File(file, "level.dat_mcr");
        if (!file2.renameTo(file3)) {
            System.out.println("Warning: Unable to create level.dat_mcr backup");
        }
    }

    private void func_75813_a(File p_75813_1_, Iterable p_75813_2_, WorldChunkManager p_75813_3_, int p_75813_4_, int p_75813_5_, IProgressUpdate p_75813_6_) {
        for (File file : p_75813_2_) {
            this.func_75811_a(p_75813_1_, file, p_75813_3_, p_75813_4_, p_75813_5_, p_75813_6_);
            int n = (int)Math.round(100.0 * (double)(++p_75813_4_) / (double)p_75813_5_);
            p_75813_6_.func_73718_a(n);
        }
    }

    private void func_75811_a(File p_75811_1_, File p_75811_2_, WorldChunkManager p_75811_3_, int p_75811_4_, int p_75811_5_, IProgressUpdate p_75811_6_) {
        try {
            String string = p_75811_2_.getName();
            RegionFile regionFile = new RegionFile(p_75811_2_);
            RegionFile regionFile2 = new RegionFile(new File(p_75811_1_, string.substring(0, string.length() - ".mcr".length()) + ".mca"));
            for (int i = 0; i < 32; ++i) {
                int n;
                for (n = 0; n < 32; ++n) {
                    if (!regionFile.func_76709_c(i, n) || regionFile2.func_76709_c(i, n)) continue;
                    DataInputStream dataInputStream = regionFile.func_76704_a(i, n);
                    if (dataInputStream == null) {
                        MinecraftServer.func_71276_C().func_98033_al().func_98236_b("Failed to fetch input stream");
                        continue;
                    }
                    NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74794_a(dataInputStream);
                    dataInputStream.close();
                    NBTTagCompound nBTTagCompound2 = nBTTagCompound.func_74775_l("Level");
                    AnvilConverterData anvilConverterData = ChunkLoader.func_76691_a(nBTTagCompound2);
                    NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
                    NBTTagCompound nBTTagCompound4 = new NBTTagCompound();
                    nBTTagCompound3.func_74782_a("Level", nBTTagCompound4);
                    ChunkLoader.func_76690_a(anvilConverterData, nBTTagCompound4, p_75811_3_);
                    DataOutputStream dataOutputStream = regionFile2.func_76710_b(i, n);
                    CompressedStreamTools.func_74800_a(nBTTagCompound3, dataOutputStream);
                    dataOutputStream.close();
                }
                n = (int)Math.round(100.0 * (double)(p_75811_4_ * 1024) / (double)(p_75811_5_ * 1024));
                int n2 = (int)Math.round(100.0 * (double)((i + 1) * 32 + p_75811_4_ * 1024) / (double)(p_75811_5_ * 1024));
                if (n2 <= n) continue;
                p_75811_6_.func_73718_a(n2);
            }
            regionFile.func_76708_c();
            regionFile2.func_76708_c();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void func_75810_a(File p_75810_1_, Collection p_75810_2_) {
        File file = new File(p_75810_1_, "region");
        File[] fileArray = file.listFiles(new AnvilSaveConverterFileFilter(this));
        if (fileArray != null) {
            Collections.addAll(p_75810_2_, fileArray);
        }
    }
}

