/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CryptManager {
    @SideOnly(value=Side.CLIENT)
    public static SecretKey func_75890_a() {
        CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
        cipherKeyGenerator.init(new KeyGenerationParameters(new SecureRandom(), 128));
        return new SecretKeySpec(cipherKeyGenerator.generateKey(), "AES");
    }

    public static KeyPair func_75891_b() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            System.err.println("Key pair generation failed!");
            return null;
        }
    }

    public static byte[] func_75895_a(String p_75895_0_, PublicKey p_75895_1_, SecretKey p_75895_2_) {
        try {
            return CryptManager.func_75893_a("SHA-1", p_75895_0_.getBytes("ISO_8859_1"), p_75895_2_.getEncoded(), p_75895_1_.getEncoded());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    private static byte[] func_75893_a(String p_75893_0_, byte[] ... p_75893_1_) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(p_75893_0_);
            for (byte[] byArray : p_75893_1_) {
                messageDigest.update(byArray);
            }
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public static PublicKey func_75896_a(byte[] p_75896_0_) {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(p_75896_0_);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
        }
        System.err.println("Public key reconstitute failed!");
        return null;
    }

    public static SecretKey func_75887_a(PrivateKey p_75887_0_, byte[] p_75887_1_) {
        return new SecretKeySpec(CryptManager.func_75889_b(p_75887_0_, p_75887_1_), "AES");
    }

    @SideOnly(value=Side.CLIENT)
    public static byte[] func_75894_a(Key p_75894_0_, byte[] p_75894_1_) {
        return CryptManager.func_75885_a(1, p_75894_0_, p_75894_1_);
    }

    public static byte[] func_75889_b(Key p_75889_0_, byte[] p_75889_1_) {
        return CryptManager.func_75885_a(2, p_75889_0_, p_75889_1_);
    }

    private static byte[] func_75885_a(int p_75885_0_, Key p_75885_1_, byte[] p_75885_2_) {
        try {
            return CryptManager.func_75886_a(p_75885_0_, p_75885_1_.getAlgorithm(), p_75885_1_).doFinal(p_75885_2_);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
        }
        catch (BadPaddingException badPaddingException) {
            badPaddingException.printStackTrace();
        }
        System.err.println("Cipher data failed!");
        return null;
    }

    private static Cipher func_75886_a(int p_75886_0_, String p_75886_1_, Key p_75886_2_) {
        try {
            Cipher cipher = Cipher.getInstance(p_75886_1_);
            cipher.init(p_75886_0_, p_75886_2_);
            return cipher;
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
        System.err.println("Cipher creation failed!");
        return null;
    }

    private static BufferedBlockCipher func_75892_a(boolean p_75892_0_, Key p_75892_1_) {
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher((BlockCipher)new CFBBlockCipher((BlockCipher)new AESFastEngine(), 8));
        bufferedBlockCipher.init(p_75892_0_, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(p_75892_1_.getEncoded()), p_75892_1_.getEncoded(), 0, 16));
        return bufferedBlockCipher;
    }

    public static OutputStream func_75897_a(SecretKey p_75897_0_, OutputStream p_75897_1_) {
        return new CipherOutputStream(p_75897_1_, CryptManager.func_75892_a(true, p_75897_0_));
    }

    public static InputStream func_75888_a(SecretKey p_75888_0_, InputStream p_75888_1_) {
        return new CipherInputStream(p_75888_1_, CryptManager.func_75892_a(false, p_75888_0_));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

