/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.rcon;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConOutputStream;
import net.minecraft.network.rcon.RConThreadBase;
import net.minecraft.network.rcon.RConThreadQueryAuth;
import net.minecraft.network.rcon.RConUtils;
import net.minecraft.server.MinecraftServer;

public class RConThreadQuery
extends RConThreadBase {
    private long field_72629_g;
    private int field_72636_h;
    private int field_72637_i;
    private int field_72634_j;
    private String field_72635_k;
    private String field_72632_l;
    private DatagramSocket field_72633_m;
    private byte[] field_72630_n = new byte[1460];
    private DatagramPacket field_72631_o;
    private Map field_72644_p;
    private String field_72643_q;
    private String field_72642_r;
    private Map field_72641_s;
    private long field_72640_t;
    private RConOutputStream field_72639_u;
    private long field_72638_v;

    public RConThreadQuery(IServer p_i1536_1_) {
        super(p_i1536_1_);
        this.field_72636_h = p_i1536_1_.func_71327_a("query.port", 0);
        this.field_72642_r = p_i1536_1_.func_71277_t();
        this.field_72637_i = p_i1536_1_.func_71234_u();
        this.field_72635_k = p_i1536_1_.func_71274_v();
        this.field_72634_j = p_i1536_1_.func_71275_y();
        this.field_72632_l = p_i1536_1_.func_71270_I();
        this.field_72638_v = 0L;
        this.field_72643_q = "0.0.0.0";
        if (0 == this.field_72642_r.length() || this.field_72643_q.equals(this.field_72642_r)) {
            this.field_72642_r = "0.0.0.0";
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.field_72643_q = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                this.func_72606_c("Unable to determine local host IP, please set server-ip in '" + p_i1536_1_.func_71329_c() + "' : " + unknownHostException.getMessage());
            }
        } else {
            this.field_72643_q = this.field_72642_r;
        }
        if (0 == this.field_72636_h) {
            this.field_72636_h = this.field_72637_i;
            this.func_72609_b("Setting default query port to " + this.field_72636_h);
            p_i1536_1_.func_71328_a("query.port", this.field_72636_h);
            p_i1536_1_.func_71328_a("debug", false);
            p_i1536_1_.func_71326_a();
        }
        this.field_72644_p = new HashMap();
        this.field_72639_u = new RConOutputStream(1460);
        this.field_72641_s = new HashMap();
        this.field_72640_t = new Date().getTime();
    }

    private void func_72620_a(byte[] p_72620_1_, DatagramPacket p_72620_2_) throws IOException {
        this.field_72633_m.send(new DatagramPacket(p_72620_1_, p_72620_1_.length, p_72620_2_.getSocketAddress()));
    }

    private boolean func_72621_a(DatagramPacket p_72621_1_) throws IOException {
        byte[] byArray = p_72621_1_.getData();
        int n = p_72621_1_.getLength();
        SocketAddress socketAddress = p_72621_1_.getSocketAddress();
        this.func_72607_a("Packet len " + n + " [" + socketAddress + "]");
        if (3 > n || -2 != byArray[0] || -3 != byArray[1]) {
            this.func_72607_a("Invalid packet [" + socketAddress + "]");
            return false;
        }
        this.func_72607_a("Packet '" + RConUtils.func_72663_a(byArray[2]) + "' [" + socketAddress + "]");
        switch (byArray[2]) {
            case 9: {
                this.func_72622_d(p_72621_1_);
                this.func_72607_a("Challenge [" + socketAddress + "]");
                return true;
            }
            case 0: {
                if (!this.func_72627_c(p_72621_1_).booleanValue()) {
                    this.func_72607_a("Invalid challenge [" + socketAddress + "]");
                    return false;
                }
                if (15 == n) {
                    this.func_72620_a(this.func_72624_b(p_72621_1_), p_72621_1_);
                    this.func_72607_a("Rules [" + socketAddress + "]");
                    break;
                }
                RConOutputStream rConOutputStream = new RConOutputStream(1460);
                rConOutputStream.func_72667_a(0);
                rConOutputStream.func_72670_a(this.func_72625_a(p_72621_1_.getSocketAddress()));
                rConOutputStream.func_72671_a(this.field_72635_k);
                rConOutputStream.func_72671_a("SMP");
                rConOutputStream.func_72671_a(this.field_72632_l);
                rConOutputStream.func_72671_a(Integer.toString(this.func_72603_d()));
                rConOutputStream.func_72671_a(Integer.toString(this.field_72634_j));
                rConOutputStream.func_72668_a((short)this.field_72637_i);
                rConOutputStream.func_72671_a(this.field_72643_q);
                this.func_72620_a(rConOutputStream.func_72672_a(), p_72621_1_);
                this.func_72607_a("Status [" + socketAddress + "]");
            }
        }
        return true;
    }

    private byte[] func_72624_b(DatagramPacket p_72624_1_) throws IOException {
        long l = MinecraftServer.func_130071_aq();
        if (l < this.field_72638_v + 5000L) {
            byte[] byArray = this.field_72639_u.func_72672_a();
            byte[] byArray2 = this.func_72625_a(p_72624_1_.getSocketAddress());
            byArray[1] = byArray2[0];
            byArray[2] = byArray2[1];
            byArray[3] = byArray2[2];
            byArray[4] = byArray2[3];
            return byArray;
        }
        this.field_72638_v = l;
        this.field_72639_u.func_72669_b();
        this.field_72639_u.func_72667_a(0);
        this.field_72639_u.func_72670_a(this.func_72625_a(p_72624_1_.getSocketAddress()));
        this.field_72639_u.func_72671_a("splitnum");
        this.field_72639_u.func_72667_a(128);
        this.field_72639_u.func_72667_a(0);
        this.field_72639_u.func_72671_a("hostname");
        this.field_72639_u.func_72671_a(this.field_72635_k);
        this.field_72639_u.func_72671_a("gametype");
        this.field_72639_u.func_72671_a("SMP");
        this.field_72639_u.func_72671_a("game_id");
        this.field_72639_u.func_72671_a("MINECRAFT");
        this.field_72639_u.func_72671_a("version");
        this.field_72639_u.func_72671_a(this.field_72617_b.func_71249_w());
        this.field_72639_u.func_72671_a("plugins");
        this.field_72639_u.func_72671_a(this.field_72617_b.func_71258_A());
        this.field_72639_u.func_72671_a("map");
        this.field_72639_u.func_72671_a(this.field_72632_l);
        this.field_72639_u.func_72671_a("numplayers");
        this.field_72639_u.func_72671_a("" + this.func_72603_d());
        this.field_72639_u.func_72671_a("maxplayers");
        this.field_72639_u.func_72671_a("" + this.field_72634_j);
        this.field_72639_u.func_72671_a("hostport");
        this.field_72639_u.func_72671_a("" + this.field_72637_i);
        this.field_72639_u.func_72671_a("hostip");
        this.field_72639_u.func_72671_a(this.field_72643_q);
        this.field_72639_u.func_72667_a(0);
        this.field_72639_u.func_72667_a(1);
        this.field_72639_u.func_72671_a("player_");
        this.field_72639_u.func_72667_a(0);
        String[] stringArray = this.field_72617_b.func_71213_z();
        byte by = (byte)stringArray.length;
        for (byte by2 = (byte)(by - 1); by2 >= 0; by2 = (byte)(by2 - 1)) {
            this.field_72639_u.func_72671_a(stringArray[by2]);
        }
        this.field_72639_u.func_72667_a(0);
        return this.field_72639_u.func_72672_a();
    }

    private byte[] func_72625_a(SocketAddress p_72625_1_) {
        return ((RConThreadQueryAuth)this.field_72641_s.get(p_72625_1_)).func_72591_c();
    }

    private Boolean func_72627_c(DatagramPacket p_72627_1_) {
        SocketAddress socketAddress = p_72627_1_.getSocketAddress();
        if (!this.field_72641_s.containsKey(socketAddress)) {
            return false;
        }
        byte[] byArray = p_72627_1_.getData();
        if (((RConThreadQueryAuth)this.field_72641_s.get(socketAddress)).func_72592_a() != RConUtils.func_72664_c(byArray, 7, p_72627_1_.getLength())) {
            return false;
        }
        return true;
    }

    private void func_72622_d(DatagramPacket p_72622_1_) throws IOException {
        RConThreadQueryAuth rConThreadQueryAuth = new RConThreadQueryAuth(this, p_72622_1_);
        this.field_72641_s.put(p_72622_1_.getSocketAddress(), rConThreadQueryAuth);
        this.func_72620_a(rConThreadQueryAuth.func_72594_b(), p_72622_1_);
    }

    private void func_72628_f() {
        if (!this.field_72619_a) {
            return;
        }
        long l = MinecraftServer.func_130071_aq();
        if (l < this.field_72629_g + 30000L) {
            return;
        }
        this.field_72629_g = l;
        Iterator iterator = this.field_72641_s.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((RConThreadQueryAuth)entry.getValue()).func_72593_a(l).booleanValue()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.func_72609_b("Query running on " + this.field_72642_r + ":" + this.field_72636_h);
        this.field_72629_g = MinecraftServer.func_130071_aq();
        this.field_72631_o = new DatagramPacket(this.field_72630_n, this.field_72630_n.length);
        try {
            while (this.field_72619_a) {
                try {
                    this.field_72633_m.receive(this.field_72631_o);
                    this.func_72628_f();
                    this.func_72621_a(this.field_72631_o);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.func_72628_f();
                }
                catch (PortUnreachableException portUnreachableException) {
                }
                catch (IOException iOException) {
                    this.func_72623_a(iOException);
                }
            }
        }
        finally {
            this.func_72611_e();
        }
    }

    @Override
    public void func_72602_a() {
        if (this.field_72619_a) {
            return;
        }
        if (0 >= this.field_72636_h || 65535 < this.field_72636_h) {
            this.func_72606_c("Invalid query port " + this.field_72636_h + " found in '" + this.field_72617_b.func_71329_c() + "' (queries disabled)");
            return;
        }
        if (this.func_72626_g()) {
            super.func_72602_a();
        }
    }

    private void func_72623_a(Exception p_72623_1_) {
        if (!this.field_72619_a) {
            return;
        }
        this.func_72606_c("Unexpected exception, buggy JRE? (" + p_72623_1_.toString() + ")");
        if (!this.func_72626_g()) {
            this.func_72610_d("Failed to recover from buggy JRE, shutting down!");
            this.field_72619_a = false;
        }
    }

    private boolean func_72626_g() {
        try {
            this.field_72633_m = new DatagramSocket(this.field_72636_h, InetAddress.getByName(this.field_72642_r));
            this.func_72601_a(this.field_72633_m);
            this.field_72633_m.setSoTimeout(500);
            return true;
        }
        catch (SocketException socketException) {
            this.func_72606_c("Unable to initialise query system on " + this.field_72642_r + ":" + this.field_72636_h + " (Socket): " + socketException.getMessage());
        }
        catch (UnknownHostException unknownHostException) {
            this.func_72606_c("Unable to initialise query system on " + this.field_72642_r + ":" + this.field_72636_h + " (Unknown Host): " + unknownHostException.getMessage());
        }
        catch (Exception exception) {
            this.func_72606_c("Unable to initialise query system on " + this.field_72642_r + ":" + this.field_72636_h + " (E): " + exception.getMessage());
        }
        return false;
    }
}

