/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.List;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.ReflectionWrapper;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.ChiselToolType;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IChiselModeItem;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.modes.TapeMeasureModes;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketSetColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTapeMeasure
extends Item
implements IChiselModeItem,
IItemScrollWheel {
    public ItemTapeMeasure() {
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        ChiselsAndBits.getConfig().helpText(LocalStrings.HelpTapeMeasure, tooltip, ClientSide.instance.getModeKey());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af() && playerIn.func_130014_f_().field_72995_K) {
            ClientSide.instance.tapeMeasures.clear();
        }
        ItemStack itemstack = playerIn.func_184586_b(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            if (playerIn.func_70093_af()) {
                ClientSide.instance.tapeMeasures.clear();
                return EnumActionResult.SUCCESS;
            }
            Pair<Vec3d, Vec3d> PlayerRay = ModUtil.getPlayerRay(playerIn);
            Vec3d ray_from = (Vec3d)PlayerRay.getLeft();
            Vec3d ray_to = (Vec3d)PlayerRay.getRight();
            RayTraceResult mop = playerIn.field_70170_p.func_180495_p(pos).func_177230_c().func_180636_a(playerIn.func_130014_f_().func_180495_p(pos), playerIn.field_70170_p, pos, ray_from, ray_to);
            if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                BitLocation loc = new BitLocation(mop, true, BitOperation.CHISEL);
                ClientSide.instance.pointAt(ChiselToolType.TAPEMEASURE, loc, hand);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public String getHighlightTip(ItemStack item, String displayName) {
        if (ChiselsAndBits.getConfig().itemNameModeDisplay) {
            return displayName + " - " + TapeMeasureModes.getMode((ItemStack)item).string.getLocal() + " - " + DeprecationHelper.translateToLocal("chiselsandbits.color." + this.getTapeColor(item).func_176762_d());
        }
        return displayName;
    }

    public EnumDyeColor getTapeColor(ItemStack item) {
        NBTTagCompound compound = item.func_77978_p();
        if (compound != null && compound.func_74764_b("color")) {
            try {
                return EnumDyeColor.valueOf((String)compound.func_74779_i("color"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return EnumDyeColor.WHITE;
    }

    @Override
    public void scroll(EntityPlayer player, ItemStack stack, int dwheel) {
        EnumDyeColor color = this.getTapeColor(stack);
        int next = color.ordinal() + (dwheel < 0 ? -1 : 1);
        if (next < 0) {
            next = EnumDyeColor.values().length - 1;
        }
        if (next >= EnumDyeColor.values().length) {
            next = 0;
        }
        EnumDyeColor col = EnumDyeColor.values()[next];
        this.setTapeColor(stack, col);
        PacketSetColor setColor = new PacketSetColor();
        setColor.chatNotification = ChiselsAndBits.getConfig().chatModeNotification;
        setColor.newColor = col;
        setColor.type = ChiselToolType.TAPEMEASURE;
        NetworkRouter.instance.sendToServer(setColor);
        ReflectionWrapper.instance.clearHighlightedStack();
    }

    public void setTapeColor(ItemStack stack, EnumDyeColor color) {
        stack.func_77983_a("color", (NBTBase)new NBTTagString(color.name()));
    }
}

