/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.crafting;

import java.util.Random;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitVisitor;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ChiselBlockCrafting
implements IRecipe {
    private ChiselBlockInfo getInfo(InventoryCrafting inv) {
        ChiselBlockInfo i = new ChiselBlockInfo();
        boolean noDuplicates = true;
        boolean noStrangeitems = true;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack is = inv.func_70301_a(x);
            if (ModUtil.isEmpty(is)) continue;
            if (is.func_77973_b() instanceof ItemBitBag) {
                if (i.bag_slot != -1) {
                    noDuplicates = false;
                }
                i.bag = is;
                i.bag_slot = x;
                continue;
            }
            if (is.func_77973_b() instanceof ItemChisel) {
                if (i.chisel_slot != -1) {
                    noDuplicates = false;
                }
                i.chisel = is;
                i.chisel_slot = x;
                continue;
            }
            if (is.func_77973_b() instanceof ItemBlock) {
                IBlockState actingState;
                if (i.block_slot != -1) {
                    noDuplicates = false;
                }
                if ((actingState = ModUtil.getStateFromItem(is)).func_177230_c() != Blocks.field_150350_a) {
                    try {
                        final IBitBrush state = ChiselsAndBits.getApi().createBrushFromState(actingState);
                        IBitAccess item = ChiselsAndBits.getApi().createBitItem(ModUtil.getEmptyStack());
                        assert (item != null);
                        item.visitBits(new IBitVisitor(){

                            @Override
                            public IBitBrush visitBit(int x, int y, int z, IBitBrush currentValue) {
                                return state;
                            }
                        });
                        i.block = item.getBitsAsItem(EnumFacing.EAST, ItemType.CHISLED_BLOCK, false);
                        if (i.block != null) {
                            ModUtil.setStackSize(i.block, ModUtil.getStackSize(is));
                            i.block_slot = x;
                            continue;
                        }
                    }
                    catch (APIExceptions.InvalidBitItem invalidBitItem) {
                        // empty catch block
                    }
                }
            }
            if (is.func_77973_b() instanceof ItemBlockChiseled) {
                if (i.block_slot != -1) {
                    noDuplicates = false;
                }
                i.block = is;
                i.block_slot = x;
                continue;
            }
            noStrangeitems = false;
        }
        i.isValid = i.chisel_slot != -1 && i.bag_slot != -1 && i.block_slot != -1 && noDuplicates && noStrangeitems;
        return i;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.getInfo((InventoryCrafting)inv).isValid;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ChiselBlockInfo cbc = this.getInfo(inv);
        cbc.doLogic();
        if (cbc.isValid && cbc.modified) {
            return cbc.bag;
        }
        return ModUtil.getEmptyStack();
    }

    public int func_77570_a() {
        return 3;
    }

    public ItemStack func_77571_b() {
        return ModUtil.getEmptyStack();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList list = NonNullList.func_191196_a();
        ChiselBlockInfo cbc = this.getInfo(inv);
        cbc.doLogic();
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            if (cbc.isValid && x == cbc.chisel_slot && !ModUtil.isEmpty(cbc.chisel) && cbc.chisel.func_77952_i() < cbc.chisel.func_77958_k()) {
                list.add((Object)cbc.chisel);
                continue;
            }
            if (cbc.isValid && x == cbc.block_slot && !ModUtil.isEmpty(cbc.block)) {
                list.add((Object)cbc.block);
                continue;
            }
            list.add((Object)ModUtil.getEmptyStack());
        }
        return list;
    }

    private static class ChiselBlockInfo {
        public ItemStack chisel = ModUtil.getEmptyStack();
        public int chisel_slot = -1;
        public ItemStack bag = ModUtil.getEmptyStack();
        public int bag_slot = -1;
        public ItemStack block = ModUtil.getEmptyStack();
        public int block_slot = -1;
        public boolean isValid;
        public boolean modified = false;

        private ChiselBlockInfo() {
        }

        public void doLogic() {
            this.bag = ModUtil.copy(this.bag);
            this.block = ModUtil.copy(this.block);
            this.chisel = ModUtil.copy(this.chisel);
            try {
                IBitAccess ba = ChiselsAndBits.getApi().createBitItem(this.block);
                Chiseler c = new Chiseler(this.chisel, ChiselsAndBits.getApi().getBitbag(this.bag));
                if (ba == null) {
                    return;
                }
                ba.visitBits(c);
                this.modified = c.modified;
                if (c.isSolid) {
                    if (ModUtil.getStackSize(this.block) == 1) {
                        this.block = ba.getBitsAsItem(EnumFacing.NORTH, ItemType.CHISLED_BLOCK, false);
                    } else {
                        this.modified = false;
                    }
                } else {
                    this.block = ModUtil.getEmptyStack();
                }
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }

        private static class Chiseler
        implements IBitVisitor {
            private final ItemStack chisel;
            private final IBitBag bbag;
            private final Random r = new Random();
            final IBitBrush airBrush = ChiselsAndBits.getApi().createBrushFromState(null);
            public boolean isSolid = false;
            public boolean modified = false;

            public Chiseler(ItemStack chisel, IBitBag bag) throws APIExceptions.InvalidBitItem {
                this.chisel = chisel;
                this.bbag = bag;
                this.r.setSeed(0L);
            }

            @Override
            public IBitBrush visitBit(int x, int y, int z, IBitBrush currentValue) {
                if (this.chisel.func_77952_i() < this.chisel.func_77958_k()) {
                    ModUtil.damageItem(this.chisel, this.r);
                    ItemStack is = currentValue.getItemStack(1);
                    if (is != null) {
                        for (int idx = 0; idx < this.bbag.getSlots(); ++idx) {
                            if (!ModUtil.isEmpty(this.bbag.insertItem(idx, is, false))) continue;
                            this.modified = true;
                            return this.airBrush;
                        }
                    }
                }
                this.isSolid = true;
                return currentValue;
            }
        }
    }
}

