/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.chiseledblock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.IStateRef;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.render.BaseBakedBlockModel;
import mod.chiselsandbits.render.chiseledblock.ChiselLayer;
import mod.chiselsandbits.render.chiseledblock.ChiseledModelBuilder;
import mod.chiselsandbits.render.chiseledblock.ChiselsAndBitsBakedQuad;
import mod.chiselsandbits.render.chiseledblock.FaceRegion;
import mod.chiselsandbits.render.chiseledblock.IFaceBuilder;
import mod.chiselsandbits.render.chiseledblock.ModelRenderState;
import mod.chiselsandbits.render.chiseledblock.UnpackedQuadBuilderWrapper;
import mod.chiselsandbits.render.helpers.ModelQuadLayer;
import mod.chiselsandbits.render.helpers.ModelUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.util.vector.Vector3f;

public class ChiseledBlockBaked
extends BaseBakedBlockModel {
    public static final float PIXELS_PER_BLOCK = 16.0f;
    private static final int[][] faceVertMap = new int[6][4];
    private static final float[][][] quadMapping = new float[6][4][6];
    private static final EnumFacing[] X_Faces = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST};
    private static final EnumFacing[] Y_Faces = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    private static final EnumFacing[] Z_Faces = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH};
    private ChiselLayer myLayer;
    private VertexFormat format;
    private TextureAtlasSprite sprite;
    private BakedQuad[] up;
    private BakedQuad[] down;
    private BakedQuad[] north;
    private BakedQuad[] south;
    private BakedQuad[] east;
    private BakedQuad[] west;
    private BakedQuad[] generic;

    public List<BakedQuad> getList(EnumFacing side) {
        if (side != null) {
            switch (side) {
                case DOWN: {
                    return this.asList(this.down);
                }
                case EAST: {
                    return this.asList(this.east);
                }
                case NORTH: {
                    return this.asList(this.north);
                }
                case SOUTH: {
                    return this.asList(this.south);
                }
                case UP: {
                    return this.asList(this.up);
                }
                case WEST: {
                    return this.asList(this.west);
                }
            }
        }
        return this.asList(this.generic);
    }

    private List<BakedQuad> asList(BakedQuad[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    private ChiseledBlockBaked() {
    }

    public ChiseledBlockBaked(int blockReference, ChiselLayer layer, VoxelBlobStateReference data, ModelRenderState mrs, VertexFormat format) {
        VoxelBlob vb;
        this.myLayer = layer;
        this.format = format;
        IBlockState state = ModUtil.getStateById(blockReference);
        IBakedModel originalModel = null;
        if (state != null) {
            originalModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        }
        if (originalModel != null && data != null && (vb = data.getVoxelBlob()) != null && layer.filter(vb)) {
            ChiseledModelBuilder builder = new ChiseledModelBuilder();
            this.generateFaces(builder, vb, mrs, data.weight);
            this.up = builder.getSide(EnumFacing.UP);
            this.down = builder.getSide(EnumFacing.DOWN);
            this.east = builder.getSide(EnumFacing.EAST);
            this.west = builder.getSide(EnumFacing.WEST);
            this.north = builder.getSide(EnumFacing.NORTH);
            this.south = builder.getSide(EnumFacing.SOUTH);
            this.generic = builder.getSide(null);
        }
    }

    public static ChiseledBlockBaked breakingParticleModel(ChiselLayer layer, Integer blockStateID) {
        return ModelUtil.getBreakingModel(layer, blockStateID);
    }

    public boolean isEmpty() {
        boolean trulyEmpty = this.getList(null).isEmpty();
        for (EnumFacing e : EnumFacing.field_82609_l) {
            trulyEmpty = trulyEmpty && this.getList(e).isEmpty();
        }
        return trulyEmpty;
    }

    private void generateFaces(ChiseledModelBuilder builder, VoxelBlob blob, ModelRenderState mrs, long weight) {
        ArrayList<ArrayList<FaceRegion>> rset = new ArrayList<ArrayList<FaceRegion>>();
        VoxelBlob.VisibleFace visFace = new VoxelBlob.VisibleFace();
        this.processXFaces(blob, visFace, mrs, rset);
        this.processYFaces(blob, visFace, mrs, rset);
        this.processZFaces(blob, visFace, mrs, rset);
        int[] to = new int[3];
        int[] from = new int[3];
        float[] uvs = new float[8];
        float[] pos = new float[3];
        IFaceBuilder faceBuilder = this.format == ChiselsAndBitsBakedQuad.VERTEX_FORMAT ? new ChiselsAndBitsBakedQuad.Builder() : new UnpackedQuadBuilderWrapper();
        for (ArrayList<FaceRegion> src : rset) {
            this.mergeFaces(src);
            for (FaceRegion region : src) {
                EnumFacing myFace = region.face;
                ChiseledBlockBaked.offsetVec(to, region.getMaxX(), region.getMaxY(), region.getMaxZ(), myFace, 1);
                ChiseledBlockBaked.offsetVec(from, region.getMinX(), region.getMinY(), region.getMinZ(), myFace, -1);
                ModelQuadLayer[] mpc = ModelUtil.getCachedFace(region.blockStateID, weight, myFace, this.myLayer.layer);
                if (mpc == null) continue;
                for (ModelQuadLayer pc : mpc) {
                    faceBuilder.begin(this.format);
                    faceBuilder.setFace(myFace, pc.tint);
                    float maxLightmap = 4.882887E-4f;
                    this.getFaceUvs(uvs, myFace, from, to, pc.uvs);
                    for (int vertNum = 0; vertNum < 4; ++vertNum) {
                        block10: for (int elementIndex = 0; elementIndex < this.format.func_177345_h(); ++elementIndex) {
                            VertexFormatElement element = this.format.func_177348_c(elementIndex);
                            switch (element.func_177375_c()) {
                                case POSITION: {
                                    this.getVertexPos(pos, myFace, vertNum, to, from);
                                    faceBuilder.put(elementIndex, pos[0], pos[1], pos[2]);
                                    continue block10;
                                }
                                case COLOR: {
                                    int cb = pc.color;
                                    faceBuilder.put(elementIndex, this.byteToFloat(cb >> 16), this.byteToFloat(cb >> 8), this.byteToFloat(cb), this.byteToFloat(cb >> 24));
                                    continue block10;
                                }
                                case NORMAL: {
                                    float normalShift = 0.999f;
                                    faceBuilder.put(elementIndex, 0.999f * (float)myFace.func_82601_c(), 0.999f * (float)myFace.func_96559_d(), 0.999f * (float)myFace.func_82599_e());
                                    continue block10;
                                }
                                case UV: {
                                    if (element.func_177369_e() == 1) {
                                        float v = 4.882887E-4f * (float)Math.max(0, Math.min(15, pc.light));
                                        faceBuilder.put(elementIndex, v, v);
                                        continue block10;
                                    }
                                    float u = uvs[faceVertMap[myFace.func_176745_a()][vertNum] * 2 + 0];
                                    float v = uvs[faceVertMap[myFace.func_176745_a()][vertNum] * 2 + 1];
                                    faceBuilder.put(elementIndex, pc.sprite.func_94214_a((double)u), pc.sprite.func_94207_b((double)v));
                                    continue block10;
                                }
                                default: {
                                    faceBuilder.put(elementIndex, new float[0]);
                                }
                            }
                        }
                    }
                    if (region.isEdge) {
                        builder.getList(myFace).add(faceBuilder.create(pc.sprite));
                        continue;
                    }
                    builder.getList(null).add(faceBuilder.create(pc.sprite));
                }
            }
        }
    }

    private float byteToFloat(int i) {
        return (float)(i & 0xFF) / 255.0f;
    }

    private void mergeFaces(ArrayList<FaceRegion> src) {
        boolean restart;
        block0: do {
            restart = false;
            int size = src.size();
            int sizeMinusOne = size - 1;
            for (int x = 0; x < sizeMinusOne; ++x) {
                FaceRegion faceA = src.get(x);
                for (int y = x + 1; y < size; ++y) {
                    FaceRegion faceB = src.get(y);
                    if (!faceA.extend(faceB)) continue;
                    src.set(y, src.get(sizeMinusOne));
                    src.remove(sizeMinusOne);
                    restart = true;
                    continue block0;
                }
            }
        } while (restart);
    }

    private void processXFaces(VoxelBlob blob, VoxelBlob.VisibleFace visFace, ModelRenderState mrs, ArrayList<ArrayList<FaceRegion>> rset) {
        ArrayList<FaceRegion> regions = null;
        ICullTest test = this.myLayer.getTest();
        for (EnumFacing myFace : X_Faces) {
            VoxelBlob nextTo;
            IStateRef nextToState = mrs != null && this.myLayer != ChiselLayer.SOLID ? mrs.get(myFace) : null;
            VoxelBlob voxelBlob = nextTo = nextToState == null ? null : nextToState.getVoxelBlob();
            if (!this.myLayer.filter(nextTo)) {
                nextTo = null;
            }
            for (int x = 0; x < blob.detail; ++x) {
                if (regions == null) {
                    regions = new ArrayList<FaceRegion>(16);
                }
                for (int z = 0; z < blob.detail; ++z) {
                    FaceRegion currentFace = null;
                    for (int y = 0; y < blob.detail; ++y) {
                        FaceRegion region = this.getRegion(blob, myFace, x, y, z, visFace, nextTo, test);
                        if (region == null) {
                            currentFace = null;
                            continue;
                        }
                        if (currentFace != null && currentFace.extend(region)) continue;
                        currentFace = region;
                        regions.add(region);
                    }
                }
                if (regions.isEmpty()) continue;
                rset.add(regions);
                regions = null;
            }
        }
    }

    private void processYFaces(VoxelBlob blob, VoxelBlob.VisibleFace visFace, ModelRenderState mrs, ArrayList<ArrayList<FaceRegion>> rset) {
        ArrayList<FaceRegion> regions = null;
        ICullTest test = this.myLayer.getTest();
        for (EnumFacing myFace : Y_Faces) {
            VoxelBlob nextTo;
            IStateRef nextToState = mrs != null && this.myLayer != ChiselLayer.SOLID ? mrs.get(myFace) : null;
            VoxelBlob voxelBlob = nextTo = nextToState == null ? null : nextToState.getVoxelBlob();
            if (!this.myLayer.filter(nextTo)) {
                nextTo = null;
            }
            for (int y = 0; y < blob.detail; ++y) {
                if (regions == null) {
                    regions = new ArrayList<FaceRegion>(16);
                }
                for (int z = 0; z < blob.detail; ++z) {
                    FaceRegion currentFace = null;
                    for (int x = 0; x < blob.detail; ++x) {
                        FaceRegion region = this.getRegion(blob, myFace, x, y, z, visFace, nextTo, test);
                        if (region == null) {
                            currentFace = null;
                            continue;
                        }
                        if (currentFace != null && currentFace.extend(region)) continue;
                        currentFace = region;
                        regions.add(region);
                    }
                }
                if (regions.isEmpty()) continue;
                rset.add(regions);
                regions = null;
            }
        }
    }

    private void processZFaces(VoxelBlob blob, VoxelBlob.VisibleFace visFace, ModelRenderState mrs, ArrayList<ArrayList<FaceRegion>> rset) {
        ArrayList<FaceRegion> regions = null;
        ICullTest test = this.myLayer.getTest();
        for (EnumFacing myFace : Z_Faces) {
            VoxelBlob nextTo;
            IStateRef nextToState = mrs != null && this.myLayer != ChiselLayer.SOLID ? mrs.get(myFace) : null;
            VoxelBlob voxelBlob = nextTo = nextToState == null ? null : nextToState.getVoxelBlob();
            if (!this.myLayer.filter(nextTo)) {
                nextTo = null;
            }
            for (int z = 0; z < blob.detail; ++z) {
                if (regions == null) {
                    regions = new ArrayList<FaceRegion>(16);
                }
                for (int y = 0; y < blob.detail; ++y) {
                    FaceRegion currentFace = null;
                    for (int x = 0; x < blob.detail; ++x) {
                        FaceRegion region = this.getRegion(blob, myFace, x, y, z, visFace, nextTo, test);
                        if (region == null) {
                            currentFace = null;
                            continue;
                        }
                        if (currentFace != null && currentFace.extend(region)) continue;
                        currentFace = region;
                        regions.add(region);
                    }
                }
                if (regions.isEmpty()) continue;
                rset.add(regions);
                regions = null;
            }
        }
    }

    private FaceRegion getRegion(VoxelBlob blob, EnumFacing myFace, int x, int y, int z, VoxelBlob.VisibleFace visFace, VoxelBlob nextTo, ICullTest test) {
        blob.visibleFace(myFace, x, y, z, visFace, nextTo, test);
        if (visFace.visibleFace) {
            Vec3i off = myFace.func_176730_m();
            return new FaceRegion(myFace, x * 2 + 1 + off.func_177958_n(), y * 2 + 1 + off.func_177956_o(), z * 2 + 1 + off.func_177952_p(), visFace.state, visFace.isEdge);
        }
        return null;
    }

    private void getVertexPos(float[] pos, EnumFacing side, int vertNum, int[] to, int[] from) {
        float[] interpos = quadMapping[side.ordinal()][vertNum];
        pos[0] = (float)to[0] * interpos[0] + (float)from[0] * interpos[1];
        pos[1] = (float)to[1] * interpos[2] + (float)from[1] * interpos[3];
        pos[2] = (float)to[2] * interpos[4] + (float)from[2] * interpos[5];
    }

    private void getFaceUvs(float[] uvs, EnumFacing face, int[] from, int[] to, float[] quadsUV) {
        float to_u = 0.0f;
        float to_v = 0.0f;
        float from_u = 0.0f;
        float from_v = 0.0f;
        switch (face) {
            case UP: {
                to_u = (float)to[0] / 16.0f;
                to_v = (float)to[2] / 16.0f;
                from_u = (float)from[0] / 16.0f;
                from_v = (float)from[2] / 16.0f;
                break;
            }
            case DOWN: {
                to_u = (float)to[0] / 16.0f;
                to_v = (float)to[2] / 16.0f;
                from_u = (float)from[0] / 16.0f;
                from_v = (float)from[2] / 16.0f;
                break;
            }
            case SOUTH: {
                to_u = (float)to[0] / 16.0f;
                to_v = (float)to[1] / 16.0f;
                from_u = (float)from[0] / 16.0f;
                from_v = (float)from[1] / 16.0f;
                break;
            }
            case NORTH: {
                to_u = (float)to[0] / 16.0f;
                to_v = (float)to[1] / 16.0f;
                from_u = (float)from[0] / 16.0f;
                from_v = (float)from[1] / 16.0f;
                break;
            }
            case EAST: {
                to_u = (float)to[1] / 16.0f;
                to_v = (float)to[2] / 16.0f;
                from_u = (float)from[1] / 16.0f;
                from_v = (float)from[2] / 16.0f;
                break;
            }
            case WEST: {
                to_u = (float)to[1] / 16.0f;
                to_v = (float)to[2] / 16.0f;
                from_u = (float)from[1] / 16.0f;
                from_v = (float)from[2] / 16.0f;
                break;
            }
        }
        uvs[0] = 16.0f * this.u(quadsUV, to_u, to_v);
        uvs[1] = 16.0f * this.v(quadsUV, to_u, to_v);
        uvs[2] = 16.0f * this.u(quadsUV, from_u, to_v);
        uvs[3] = 16.0f * this.v(quadsUV, from_u, to_v);
        uvs[4] = 16.0f * this.u(quadsUV, from_u, from_v);
        uvs[5] = 16.0f * this.v(quadsUV, from_u, from_v);
        uvs[6] = 16.0f * this.u(quadsUV, to_u, from_v);
        uvs[7] = 16.0f * this.v(quadsUV, to_u, from_v);
    }

    float u(float[] src, float inU, float inV) {
        float inv = 1.0f - inU;
        float u1 = src[0] * inU + inv * src[2];
        float u2 = src[4] * inU + inv * src[6];
        return u1 * inV + (1.0f - inV) * u2;
    }

    float v(float[] src, float inU, float inV) {
        float inv = 1.0f - inU;
        float v1 = src[1] * inU + inv * src[3];
        float v2 = src[5] * inU + inv * src[7];
        return v1 * inV + (1.0f - inV) * v2;
    }

    private static void offsetVec(int[] result, int toX, int toY, int toZ, EnumFacing f, int d) {
        int leftX = 0;
        boolean leftY = false;
        int leftZ = 0;
        boolean upX = false;
        int upY = 0;
        int upZ = 0;
        switch (f) {
            case DOWN: {
                leftX = 1;
                upZ = 1;
                break;
            }
            case EAST: {
                leftZ = 1;
                upY = 1;
                break;
            }
            case NORTH: {
                leftX = 1;
                upY = 1;
                break;
            }
            case SOUTH: {
                leftX = 1;
                upY = 1;
                break;
            }
            case UP: {
                leftX = 1;
                upZ = 1;
                break;
            }
            case WEST: {
                leftZ = 1;
                upY = 1;
                break;
            }
        }
        result[0] = (toX + leftX * d + 0 * d) / 2;
        result[1] = (toY + 0 * d + upY * d) / 2;
        result[2] = (toZ + leftZ * d + upZ * d) / 2;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.getList(side);
    }

    public TextureAtlasSprite func_177554_e() {
        return this.sprite != null ? this.sprite : ClientSide.instance.getMissingIcon();
    }

    public int faceCount() {
        int count = this.getList(null).size();
        for (EnumFacing f : EnumFacing.field_82609_l) {
            count += this.getList(f).size();
        }
        return count;
    }

    public boolean isAboveLimit() {
        return this.faceCount() >= ChiselsAndBits.getConfig().dynamicModelFaceCount;
    }

    public static ChiseledBlockBaked createFromTexture(TextureAtlasSprite findTexture, ChiselLayer layer) {
        ChiseledBlockBaked out = new ChiseledBlockBaked();
        out.sprite = findTexture;
        out.myLayer = layer;
        return out;
    }

    static {
        Vector3f to = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f from = new Vector3f(16.0f, 16.0f, 16.0f);
        for (EnumFacing myFace : EnumFacing.field_82609_l) {
            FaceBakery faceBakery = new FaceBakery();
            BlockPartRotation bpr = null;
            ModelRotation mr = ModelRotation.X0_Y0;
            float[] defUVs = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
            BlockFaceUV uv = new BlockFaceUV(defUVs, 0);
            BlockPartFace bpf = new BlockPartFace(myFace, 0, "", uv);
            TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            BakedQuad q = faceBakery.func_178414_a(to, from, bpf, texture, myFace, mr, bpr, true, true);
            int[] vertData = q.func_178209_a();
            int a = 0;
            int b = 2;
            switch (myFace) {
                case NORTH: 
                case SOUTH: {
                    a = 0;
                    b = 1;
                    break;
                }
                case EAST: 
                case WEST: {
                    a = 1;
                    b = 2;
                    break;
                }
            }
            int p = vertData.length / 4;
            for (int vertNum = 0; vertNum < 4; ++vertNum) {
                float A = Float.intBitsToFloat(vertData[vertNum * p + a]);
                float B = Float.intBitsToFloat(vertData[vertNum * p + b]);
                for (int o = 0; o < 3; ++o) {
                    float v = Float.intBitsToFloat(vertData[vertNum * p + o]);
                    float scaler = 0.0625f;
                    ChiseledBlockBaked.quadMapping[myFace.ordinal()][vertNum][o * 2] = v * 0.0625f;
                    ChiseledBlockBaked.quadMapping[myFace.ordinal()][vertNum][o * 2 + 1] = (1.0f - v) * 0.0625f;
                }
                ChiseledBlockBaked.faceVertMap[myFace.func_176745_a()][vertNum] = ModelUtil.isZero(A) && ModelUtil.isZero(B) ? 0 : (ModelUtil.isZero(A) && ModelUtil.isOne(B) ? 3 : (ModelUtil.isOne(A) && ModelUtil.isZero(B) ? 1 : 2));
            }
        }
    }
}

